#include "portab.h"
#include "osif.h"

#if GEMDOS
#include "osiferr.h"
#include "errno.h"
extern long trap();
#endif

long
readl(fd,buf,lnum)		/* CLEAR FUNCTION ***********/
int		fd;		/* file descriptor */
REG char	*buf;		/* addr */
long	 	lnum;		/* size */
{
    LONG	R;

#if GEMDOS

   if ((R = trap(READ,fd,lnum,buf)) < 0L)
      RETERR(FAILURE,((int) R ))
   else
      return (R);

#else

    REG UWORD	tmp;

	R = lnum;
	while (lnum != 0)
		{
		  tmp = (lnum < 32768L)? (int)lnum : 32768;
		  if (read(fd,buf,tmp) != tmp)
			break;
		  buf += tmp;
		  lnum -= tmp;
		}
	return(R-lnum);		/* number of bytes read */
#endif
}
                                                                                                    