
/*
 *	NAME:	rename
 *
 *	FUNCTION:  changes a file's name.
 *
 *	USAGE:
 *		int  rename(from,to)
 *
 *	ARGUMENTS:
 *		char * from -> a NULL terminated (existing) file name
 *		char * to -> the NULL terminated new file name
 *
 *	RETURNS:
 *		SUCCESS if everything ok, FAILURE o.w.
 *
 *	REVISION HISTORY:
 *		Split into separate files for pcdosb 12/84 JC
 *		Modifications for PCDOS 2.0  AS april,84
 *		Dynamic Checking for PCDOS versions. AS April,84
 *		Replaced conditional compiled expressions
 *		Changed rename4 call to dos2rename 3/85 JC
 *
*/

#include "portab.h"
#include "osif.h"
#if CPM
#include "osiferr.h"
#include "errno.h"
int
rename(from,to) 			/* CLEAR FUNCTION ***********/
char	*from;				/* Existing file name	    */
char	*to;				/* New file name	    */
{

	BYTE fcbbuf[32+16];			/* Extra large fcb	    */
  REG	struct fcbtab *fcbp;			/* FCB pointer		    */
  REG	WORD nuser;				/* new user #		    */
  REG	WORD xuser;				/* system user #	    */
	WORD rv;				/* Return value 	    */


	fcbp = fcbbuf;				/* Point fcb to start	    */
	if( FAILURE == _parsefn(from,fcbp))	/* Parse 'from' into fcb    */
		RETERR(FAILURE,EINVAL); 	/*    Bad filename	    */
	nuser = fcbp->fuser;			/* Save specified User #    */
	fcbp = &(fcbbuf[16]);			/* F_RENAME needs it	    */
	if( FAILURE == _parsefn(to,fcbp))	/* Parse 'to' to fcb[16]    */
		RETERR(FAILURE,EINVAL); 	/*    Bad filename	    */
	if( fcbp->fuser )			/* user # specified?	    */
	{					/*			    */
		if(nuser && nuser!=fcbp->fuser) /* Differing User #s?	    */
			RETERR(FAILURE,EINVAL); /*   that's a no-no         */
		nuser = fcbp->fuser;		/* Use this user #	    */
	}					/****			    */
	xuser = _chkuser(nuser);		/* Change user # if needed  */
						/****************************/
	rv = __OSIF(F_RENAME,fcbbuf);		/* Use special fcb	    */
						/****************************/
	_uchkuser(nuser,xuser); 		/* Change back if needed    */
	if( rv != 0 )				/* Did it work? 	    */
		RETERR(FAILURE,ERENAME);	/*   no...		    */
	return SUCCESS; 			/* It worked!		    */
}						/****************************/
#endif

#if PC1ONLY
int
rename(from,to) 			/* CLEAR FUNCTION ***********/
char	*from;				/* Existing file name	    */
char	*to;				/* New file name	    */
{
	return(_rename3(from, to));
}
#endif

#if PC2ONLY
int
rename(from,to) 			/* CLEAR FUNCTION ***********/
char	*from;				/* Existing file name	    */
char	*to;				/* New file name	    */
{
	return(dos2rename(from, to));
}
#endif

#if PCBOTH
#include	"osattr.h"
int
rename(from,to) 			/* CLEAR FUNCTION ***********/
char	*from;				/* Existing file name	    */
char	*to;				/* New file name	    */
{
	if(os_unixlike)
		return(dos2rename(from, to));
	else
		return(_rename1(from, to));
}
#endif
                                                                                                                     