/*
*
*	NAME:	__main
*
*	FUNCTION:
*		Routine "__main()" is entered from the "_main()" routine
*		to start a C program.  The command string from CP/M is parsed
*		into a UNIX-like "argc/argv" setup, including simple I/O
*		redirection.
*
*		This module can be compiled without wildcard parsing if the
*		symbol "NOWILD" (note upper case) is defined in the compile
*		line.
*
*	USAGE:
*		_main(command,length)
*
*	ARGUMENTS:
*		BYTE	*command   Is the address of the command line from CP/M
*		WORD	lenth	   Is the number of characters in the line,
*				   excluding the termination character (CR/LF).
*
*
*	REVISION HISTORY:
*
*		Edits:
*			2/85	  JC   Replaced conditional compiled expr
*			April-84  as   dynamic checking for pcdos versions
*			17-APR-84 as   deleted definitions of STDIN etc.(added
*						    to PORTAB.H
*			02-Feb-84 whf  nowild -> NOWILD, removed write()
*			01-Jan-84 whf  add in handle for OPTION*.h
*			08-Dec-83 whf  handle PC-DOS diffs, add ">>"
*							redirection
*			11-Oct-83 whf  converted to DRC from CPM68K
*
*
*	COMPILER OPTIONS: pcdos for 1.1, pcdos2 for 2.0 and IBMPC for
*			either of the two. cpm for CPM
*/


#include "portab.h"                             /* Include std definitions  */
#include "osif.h"                               /* Include CP/M Definitions */

char	*environ;				/* array of env strs */
int	envc;					/* # of env strs */

#if CPMXPC1
__main(com, len)
char	*com;
int	len;
{						/****************************/
	__main1(com, len);
}
#endif

#if PC2ONLY
__main(com, len)
char	*com;
int	len;
{						/****************************/
	__main4(com, len);
}
#endif

#if PCBOTH
#include "osattr.h"
__main(com, len)
char	*com;
int	len;
{						/****************************/
	if(os_unixlike)
		__main4(com, len);
	else
		__main1(com, len);
}
#endif

						/*			    */
_err(s1,s2)					/* Error routine	    */
	char	*s1;				/* Message text 	    */
	char	*s2;				/* Filename		    */
{						/****************************/
	char buf[128];				/* place to build message   */
						/*			    */
	strcpy(buf,s1); 			/* Output error message     */
	strcat(buf,s2); 			/* And filename 	    */
	strcat(buf,"\r\n$");                    /* + Newline                */
	__OSIF(C_WRITESTR,buf); 		/* output directly to CON:  */
	exit(-1);				/* And fail hard	    */
}						/****************************/

/*****************************************************************************/
/*****************************************************************************/
#ifndef NOWILD

/*
 *	Toasc routine -- combines the FCB name in the DMA and the user number
 *	/ drive field to produce an ascii file name for SEARCHes.
 *
 */
#if CPMPC1
#include	"ctype.h"
_toasc(p,c,buf)				/*****************************/
REG	FD	*p;				/* -> Data area 	     */
REG	BYTE	 c;				/* 0 .. 3 search code	     */
REG	BYTE	*buf;				/* Output buffer area	     */
{						/*****************************/
REG	BYTE	*f;				/* -> Fcb in DMA buffer      */
	WORD	 i;				/* Temp.		     */
						/*			     */
	*buf = NULL;				/* Nullify at first	     */
	i = FALSE;				/*****************************/
	f = p->buffer;				/* Pnt to results of search  */
#if CPM    /*================================================================*/
	f += c*32;				/* c == directory search code*/
	if( p->user )				/* User # not default?	     */
	{					/* Yes			     */
		i = (p->user) -1;		/* Cvt to real user #	     */
		if( i>=10 ) *buf++ = '1';       /* Assume user # <15         */
		*buf++ = '0' + (i % 10);        /* now for digits            */
		*buf++ = ':';                   /* finish off with this      */
		i = TRUE;			/* remember		     */
	};					/*****************************/
#endif	   /*================================================================*/
	if(p->fcb.drive)			/* Drive specified?	     */
	{					/* Yes			     */
	  if(i) 				/* User #?		     */
		buf--;				/* Yes, back up over ':'     */
	  *buf++ = p->fcb.drive - 1 + 'a';      /* Put in drive code         */
	  *buf++ = ':';                         /* And delimiter             */
	}					/*			     */
	for(i=1;i<9;i++)			/* Move the filename	     */
	{					/*****************************/
	   if(f[i] != ' ')                      /* Non-blank?                */
		*buf++ = tolower((f[i]&0x7f));	/* Yes, move it in	     */
	}					/*****************************/
	*buf++ = '.';                           /* Put in delimiter          */
	for(i=9; i<12; i++)			/* Move in extension	     */
	{					/*			     */
	   if(f[i] != ' ')                      /* Non-blank?                */
		*buf++ = tolower((f[i]&0x7f));	/* Yes, move it in	     */
	}					/*****************************/
	*buf++ = NULL;				/* Null at end		     */
}						/*****************************/

#endif /******************************************** pcdos & cpm  ************/
#else	   /*************************************** no wild		    */

nowildcards()		/* stubroutine for OPTION*.h package */
{
}
#endif







           