/*	DESKTOP.C	05/04/84 - 06/20/85	Lee Lorenzen		*/

/*
*	-------------------------------------------------------------
*	GEM Desktop					  Version 1.2
*	Serial No.  XXXX-0000-654321		  All Rights Reserved
*	Copyright (C) 1985			Digital Research Inc.
*	-------------------------------------------------------------
*/

#include <portab.h>
#include <machine.h>
#include <obdefs.h>
#include <taddr.h>
#include <dos.h>
#include <crysbind.h>
#include <deskdefn.h>
#include <deskapp.h>
#include <deskfpd.h>
#include <deskwin.h>
#include <infodef.h>
#include <deskbind.h>

#define ESCAPE 0x011B
						/* in GSXIF.A86		*/
EXTERN VOID	gsx_start();
						/* in DESKPRO.C		*/
EXTERN WORD	do_exec();
EXTERN WORD	do_exit();
						/* in DESKFPD.C		*/
EXTERN WORD	fpd_start();
EXTERN FNODE	*fpd_ofind();
						/* in DESKWIN.C		*/
EXTERN WORD	win_start();
EXTERN WORD	win_isel();
EXTERN BYTE	*win_iname();
EXTERN WNODE	*win_alloc();
EXTERN WNODE	*win_find();
EXTERN WNODE	*win_ontop();
EXTERN WNODE	*win_ith();
EXTERN WORD	win_free();
EXTERN VOID	win_bldview();
						/* in DESKAPP.C		*/
EXTERN WORD	app_start();
EXTERN WORD	app_blddesk();
EXTERN ANODE	*app_afind();
						/* in DESKACT.C		*/
EXTERN WORD	act_bsclick();
EXTERN WORD	act_bdown();
						/* in DESKRSRC.C	*/
EXTERN WORD	ini_rsrc();
EXTERN WORD	ini_tree();
EXTERN BYTE	*ini_str();

EXTERN WORD	DOS_ERR;
EXTERN WORD	gl_hchar;
EXTERN WORD	gl_wchar;

EXTERN WORD	gl_wbox;
EXTERN WORD	gl_hbox;

EXTERN WORD	gl_handle;

EXTERN GLOBES	G;

GLOBAL WORD	gl_apid;

GLOBAL BYTE	ILL_ITEM[] = {L2ITEM,L3ITEM,L4ITEM,L5ITEM,0};
GLOBAL BYTE	ILL_FILE[] = {FORMITEM,IDSKITEM,0};
GLOBAL BYTE	ILL_DOCU[] = {FORMITEM,IDSKITEM,IAPPITEM,0};
GLOBAL BYTE	ILL_FOLD[] = {OUTPITEM,FORMITEM,IDSKITEM,IAPPITEM,0};
GLOBAL BYTE	ILL_FDSK[] = {OUTPITEM,IAPPITEM,0};
GLOBAL BYTE	ILL_HDSK[] = {FORMITEM,OUTPITEM,IAPPITEM,0};
GLOBAL BYTE	ILL_TRSH[] = {OPENITEM,OUTPITEM,FORMITEM,
				IDSKITEM,IAPPITEM,IDSKITEM,0};
GLOBAL BYTE	ILL_NOSEL[] = {OPENITEM,SHOWITEM,FORMITEM,
				IDSKITEM,IAPPITEM,0};
GLOBAL BYTE	ILL_NOWIN[] = {NEWFITEM,CLSFITEM,CLSWITEM,0};
GLOBAL BYTE	ILL_YESWIN[] = {NEWFITEM,CLSFITEM,CLSWITEM,ICONITEM,TEXTITEM,
				NAMEITEM,DATEITEM,SIZEITEM,TYPEITEM,0};
GLOBAL BYTE	ILL_YSEL[] = {OPENITEM, IDSKITEM, FORMITEM, SHOWITEM, 0};

GLOBAL WORD	freq[]=
{
	262, 349, 329, 293, 349, 392, 440, 392, 349, 329, 262, 293,
	349, 262, 262, 293, 330, 349, 465, 440, 392, 349, 698
};

GLOBAL WORD	dura[]=
{
	4, 12, 4, 12, 4, 6, 2, 4, 4, 12, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 12, 4, 8, 4
};


GLOBAL WORD	gl_swtblks[3] =
{
	160,
	160,
	160
};


/*
*	Turn on the hour glass to signify a wait and turn it off when were
*	done.
*/
	VOID
desk_wait(turnon)
	WORD		turnon;
{
	graf_mouse( (turnon) ? HGLASS : ARROW, 0x0L);
}


/*
*	Given an icon index, go find the ANODE which it represents
*/
	ANODE
*i_find(wh, item, ppf, pisapp)
	WORD		wh;
	WORD		item;
	FNODE		**ppf;
	WORD		*pisapp;
{
	ANODE 	*pa;
	BYTE 	*pname;
	WNODE	*pw;
	FNODE	*pf;

	pa = (ANODE *) NULL;
	pf = (FNODE *) NULL;
	if (wh == 0)
	{
	  pname = win_iname(item);
	  pa = app_afind(TRUE, -1, item, pname, pisapp);
	}
	else
	{
	  pw = win_find(wh);
	  pf = fpd_ofind(pw->w_path->p_flist, item);
	  if (pf)
 	  {
	    pname = &pf->f_name[0];
	    if (pf->f_attr & F_SUBDIR)
	      pa = app_afind(FALSE, AT_ISFOLD, -1, pname, pisapp);
	    else
	      pa = app_afind(FALSE, AT_ISFILE, -1, pname, pisapp);

	  }
	}
	*ppf = pf;
	return (pa);
}

/*
*	Enable/Disable the menu items in dlist
*/
	VOID
men_list(mlist, dlist, enable)
	LONG		mlist;
	BYTE		*dlist;
	WORD		enable;
{
	while (*dlist)
	  menu_ienable(mlist, *dlist++, enable);
}

/*
* 	Based on current selected icons, figure out which
*	menu items should be selected (deselected)
*/
	VOID
men_update(tree)
	LONG		tree;
{
	WORD		item, nsel, junk, *pjunk, isapp;
	BYTE		*pvalue;
	ANODE		*appl;

	for (item = OPENITEM; item <= PREFITEM; item++)
	  menu_ienable(tree,item,TRUE);
	men_list(tree, ILL_ITEM, FALSE);

	nsel = 0;
	for (item = 0; item = win_isel(G.g_screen, G.g_croot, item); nsel++)
	{
	  appl = i_find(G.g_cwin, item, &pjunk, &isapp);
	  switch (appl->a_type)
	  {
	    case AT_ISFILE:
		if ( (isapp) ||
		     is_installed(appl) )
		  pvalue = ILL_FILE;
		else
		  pvalue = ILL_DOCU;
		break;
	    case AT_ISFOLD:
		pvalue = ILL_FOLD;
		break;
	    case AT_ISDISK:
		pvalue = (appl->a_aicon == IG_FLOPPY) ? ILL_FDSK : ILL_HDSK;
		break;
	    case AT_ISTRSH:
		pvalue = ILL_TRSH;
		break;
	  }
	  men_list(tree, pvalue, FALSE);
	}

	pvalue = (win_ontop()) ? ILL_YESWIN : ILL_NOWIN;
	men_list(tree, pvalue, pvalue == ILL_YESWIN);

	if ( nsel != 1 )
	{
	  pvalue = (nsel) ? ILL_YSEL : ILL_NOSEL;
	  men_list(tree, pvalue, FALSE);
	}
}

	WORD
do_deskmenu(item)
	WORD		item;
{
	WORD		done, touchob, i;
	LONG		tree;

	done = FALSE;
	switch( item )
	{
	  case ABOUITEM:
		tree = G.a_trees[AD_DINFO];
						/* draw the form	*/
		show_box(tree);
		while( !done )
		{
	          touchob = form_do(tree, 0);
	          touchob &= 0x7fff;
		  if ( touchob == DE_ICON )
		  {
		    for(i=0; i<23; i++)
		      sound(TRUE, freq[i], dura[i]);
		  }
		  else
		    done = TRUE;
		}   
		LWSET(OB_STATE(DE_OK), NORMAL);
		hide_box(tree);
		done = FALSE;
		break;
	}
	return(done);
}


	WORD
do_filemenu(item)
	WORD		item;
{
	WORD		done;
	WORD		curr, wh, junk, first;
	WORD		xc, yc, wc, hc;
	WNODE		*pw;
	ANODE		*pa;
	FNODE		*pf;
	BYTE		*pdst;
	
	done = FALSE;
	pw = win_ontop();
	curr = win_isel(G.g_screen, G.g_croot, 0);
	switch( item )
	{
	  case OPENITEM:
		if (curr)
		  done = do_open(curr);
		break;
	  case SHOWITEM:
		if (curr)
		  done = do_info(curr);
		break;
	  case NEWFITEM:
		if (pw)
		  fun_mkdir(pw);
		break;
	  case CLSFITEM:
		if (pw)
		  do_close(pw, FALSE);
		break;
	  case CLSWITEM:
		if (pw)
		  do_close(pw, TRUE);
		break; 
	  case FORMITEM:
		if (curr)
		  done = do_format(curr);
		break;   
	  case OUTPITEM:
						/* build cmd tail that	*/
						/*   looks like this:	*/
			/* C:\path\*.*,file.ext,file.ext,file.ext	*/
		G.g_tail[1] = NULL;
		if (pw)
		{
		  pdst = strcpy(&pw->w_path->p_spec[0], &G.g_tail[1]);
						/* while there are	*/
						/*   filenames append	*/
						/*   them in		*/
		  first = TRUE;
		  while(curr)
		  {
		    if (first)
		    {
		      while (*pdst != '\\')
		        pdst--;
		      pdst++;
		      *pdst = NULL;
		      first = FALSE;
		    }
		    else
		    {
		      pdst--;
		      *pdst++ = ',';
		    }
		    pa = i_find(G.g_cwin, curr, &pf, &junk);
		    pdst = strcpy(&pf->f_name[0], pdst);
						/* if there is room for	*/
						/*   another filename &;*/
						/*   then go fetch it	*/ 
		    if ( (&G.g_tail[127] - pdst) > 16 )
		      curr = win_isel(G.g_screen, G.g_croot, curr);
		    else
		      curr = 0;
		  }
		}
		strcpy(ini_str(ST_GEMOUT), &G.g_cmd[0]);
		done = do_run(TRUE, TRUE, -1, -1);
		break;
	  case QUITITEM:
		do_exit(G.a_cmd, G.a_tail);
		done = TRUE;
		break;
	}
	return(done);
}


	WORD
do_viewmenu(item)
	WORD		item;
{
	WORD		done;
	WORD		newview, newsort;
	WORD		chng_item;

	done = FALSE;
	newview = G.g_iview;
	newsort = G.g_isort;
	switch( item )
	{
	  case ICONITEM:
		newview = V_ICON;
		break;
	  case TEXTITEM:
		newview = V_TEXT;
		break;
	  case NAMEITEM:
		newsort = S_NAME;
		break;
	  case DATEITEM:
		newsort = S_DATE;
		break;
	  case SIZEITEM:
		newsort = S_SIZE;
		break;
	  case TYPEITEM:
		newsort = S_TYPE;
		break;
	}
	if ( (newview != G.g_iview) ||
	     (newsort != G.g_isort) )
	{
	  if (newview != G.g_iview)
	  {
	    menu_icheck(G.a_trees[AD_MENU], G.g_cviewitem, FALSE);
	    G.g_cviewitem = item;
	    menu_icheck(G.a_trees[AD_MENU], item, TRUE);
	  }
	  if (newsort != G.g_isort)
	  {
	    menu_icheck(G.a_trees[AD_MENU], G.g_csortitem, FALSE);
	    G.g_csortitem = item;
	    menu_icheck(G.a_trees[AD_MENU], item, TRUE);
	  }
	  win_view(newview, newsort);
	}
	return(done);
}



	WORD
do_optnmenu(item)
	WORD		item;
{
	ANODE		*pa;
	WORD		xc, yc, wc, hc;
	WORD		done, rebld, curr, junk, ret;
	FNODE		*pf;
	WORD		isapp;
	BYTE		*pstr;

	done = FALSE;
	rebld = FALSE;

	get_xywh(G.g_screen, G.g_croot, &xc, &yc, &wc, &hc);
	curr = win_isel(G.g_screen, G.g_croot, 0);
	if (curr)
	  pa = i_find(G.g_cwin, curr, &pf, &isapp);


	switch( item )
	{
	  case IDSKITEM:
		if (pa)
		  rebld = ins_disk(pa);
		if (rebld)
		{
		  app_blddesk();
		  wind_get(0, WF_WXYWH, &xc, &yc, &wc, &hc);
		  do_wredraw(0, xc, yc, wc, hc);
	        }
		break;
	  case IAPPITEM:
		if (pa)
		{
		  if (isapp)
		    pstr = &pf->f_name[0];
		  else if (is_installed(pa))
		    pstr = pa->a_pappl;
		  rebld = ins_app(pstr, pa);
		}
		if (rebld)
		{
		  desk_wait(TRUE);
		  win_bdall();
		  win_shwall();
		  desk_wait(FALSE);
		}
		break;
	  case PREFITEM:
		inf_pref();
		break;
	  case SAVEITEM:
		desk_wait(TRUE);
		cnx_put();
		app_save(TRUE);
		desk_wait(FALSE);
		break;
	  case DOSITEM:
		ret = do_cmd( "\0", "\0", FALSE);
		if (ret)
		  done = do_run(FALSE, TRUE, -1, -1);
		break;
	}
	return(done);
}


	WORD
hndl_button(clicks, mx, my, button, keystate)
	WORD		clicks;
	WORD		mx, my, button, keystate;
{
	WORD		done, junk;
	GRECT		c;
	WORD		wh, root;
	WORD		curr;
	WORD		dobj;
	WORD		dest_wh;
	WNODE		*pdw;

	done = FALSE;

	wh = wind_find(mx, my);

	if (wh != G.g_cwin)
	  desk_clear(G.g_cwin);

	desk_verify(wh, FALSE);

	G.g_wlastsel = wh;

	wind_get(wh, WF_WXYWH, &c.g_x, &c.g_y, &c.g_w, &c.g_h);

	if (clicks == 1)
	{
	  act_bsclick(G.g_cwin, G.a_screen, G.g_croot, mx, my, keystate, &c);
	  graf_mkstate(&junk, &junk, &button, &junk);
	  if (button & 0x0001)
	  {
	    dest_wh = act_bdown(G.g_cwin, G.a_screen, G.g_croot, mx, my, 
				keystate, &c, &dobj);
	    if (dest_wh != NIL)
	    {
 	      if (dest_wh)
	      {
		pdw = win_find(dest_wh);
		root = pdw->w_root;
	      }
	      else
		root = DROOT;
	      done = fun_drag(wh, dest_wh, root, dobj);
	    }
	  }
	}
	else
	{
	  act_bsclick(G.g_cwin, G.a_screen, G.g_croot, mx, my, keystate, &c);
	  done = do_filemenu(OPENITEM);
	}
	men_update(G.a_trees[AD_MENU]); 
	return(done);
}


	WORD
hndl_kbd(thechar)
	WORD		thechar;
{
	WORD		done;

	done = FALSE;
	if (thechar == ESCAPE)
	{
	  do_chktop();
	}
	return(done);
}


	WORD
hndl_menu(title, item)
	WORD		title;
	WORD		item;
{
	WORD		done;

	done = FALSE;
	switch( title )
	{
	  case DESKMENU:
		done = do_deskmenu(item);
		break;
	  case FILEMENU:
		done = do_filemenu(item);
		break;
	  case VIEWMENU:
		done = do_viewmenu(item);
						/* for every window	*/
						/*   go sort again and	*/
						/*   rebuild views	*/
		desk_wait(TRUE);
		win_srtall();
		win_bdall();
		win_shwall();
		desk_wait(FALSE);
		break;
	  case OPTNMENU:
		done = do_optnmenu(item);
		break;
	}
	menu_tnormal(G.a_trees[AD_MENU], title, TRUE);
	return(done);
}


	WORD
hndl_msg()
{
	WORD		done;
	WNODE		*pw;
	WORD		x, y, w, h;
	WORD		sl_value, isvert, change, menu;
	
	done = change = menu = FALSE;
	switch( G.g_rmsg[0] )
	{
	  case WM_TOPPED:
	  case WM_CLOSED:
	  case WM_FULLED:
	  case WM_ARROWED:
	  case WM_HSLID:
	  case WM_VSLID:
	  case WM_SIZED:
	  case WM_MOVED:
		desk_clear(G.g_cwin);
		break;
	}
	switch( G.g_rmsg[0] )
	{
	  case MN_SELECTED:
		desk_verify(G.g_wlastsel, FALSE);
		done = hndl_menu(G.g_rmsg[3], G.g_rmsg[4]);
		break;
	  case WM_REDRAW:
		menu = TRUE;
		if (G.g_rmsg[3])
		{
		  do_wredraw(G.g_rmsg[3], G.g_rmsg[4], G.g_rmsg[5], 
					G.g_rmsg[6], G.g_rmsg[7]);
		}
		break;
	  case WM_TOPPED:
		wind_set(G.g_rmsg[3], WF_TOP, 0, 0, 0, 0);
		wind_get(G.g_rmsg[3], WF_WXYWH, &x, &y, &w, &h);
		pw = win_find(G.g_rmsg[3]);
		win_top(pw);
		desk_verify(pw->w_id, FALSE);
		G.g_wlastsel = pw->w_id;
		change = TRUE;
		break;
	  case WM_CLOSED:
		do_filemenu(CLSFITEM);
		change = TRUE;
		break;
	  case WM_FULLED:
		do_wfull(G.g_rmsg[3]);
		desk_verify(G.g_rmsg[3], TRUE);
		change = TRUE;
		break;
	  case WM_ARROWED:
		win_arrow(G.g_rmsg[3], G.g_rmsg[4]);
		break;
	  case WM_HSLID:
		win_slide(G.g_rmsg[3], G.g_rmsg[4], FALSE);
		break;
	  case WM_VSLID:
		win_slide(G.g_rmsg[3], G.g_rmsg[4], TRUE);
		break;
	  case WM_SIZED:
	  case WM_MOVED:
		x = G.g_rmsg[4];
		y = G.g_rmsg[5];
		do_xyfix(&x, &y);
		w = G.g_rmsg[6];
		h = G.g_rmsg[7];
		wind_set(G.g_rmsg[3], WF_CXYWH, x, y, w, h);
		if (G.g_rmsg[0] == WM_SIZED)
		  desk_verify(G.g_rmsg[3], TRUE);
		else
		{
		  wind_get(G.g_rmsg[3], WF_WXYWH, &x, &y, &w, &h);
		  pw = win_find(G.g_rmsg[3]);
		  r_set(&G.g_screen[pw->w_root].ob_x, x, y, w, h);
		}
		change = TRUE;
		break;
	}
	if (change)
	  cnx_put();
	G.g_rmsg[0] = 0;
	if (!menu)
	  men_update(G.a_trees[AD_MENU]);
	return(done);
}


	VOID
cnx_put()
{

	WORD		iwin;
	WORD		thewin;
	WSAVE		*pws;
	WNODE		*pw;

	G.g_cnxsave.vitem_save = G.g_cviewitem - ICONITEM;
	G.g_cnxsave.sitem_save = G.g_csortitem - NAMEITEM;
	G.g_cnxsave.ccopy_save = G.g_ccopypref;
	G.g_cnxsave.cdele_save = G.g_cdelepref;
	G.g_cnxsave.cdclk_save = G.g_cdclkpref;

	thewin = 0;
	for (iwin=0; iwin < NUM_WNODES; iwin++) 
	{
	  pw = win_ith(iwin + 1);
	  if (pw->w_id)
	  {
	    pws = &G.g_cnxsave.win_save[thewin];
	    thewin++;
	    wind_get(pw->w_id, WF_CXYWH, &pws->x_save, &pws->y_save,
			&pws->w_save, &pws->h_save);
	    do_xyfix(&pws->x_save, &pws->y_save);
	    pws->hsl_save = pw->w_cvcol;
	    pws->vsl_save = pw->w_cvrow;
	    pws->obid_save = pw->w_obid;
	    strcpy( pw->w_path->p_spec, &pws->pth_save[0]);
	  }
	}
	for(; thewin < NUM_WNODES; thewin++)
	{
	  pws = &G.g_cnxsave.win_save[thewin];
	  pws->pth_save[0] = NULL;
	  pws->obid_save = 0x0;
	}
}


	VOID
cnx_get()
{
	WORD		iwin;
	WSAVE		*pws;
	WNODE		*pw;
	WORD		drv;
	BYTE		pname[8];
	BYTE		pext[3];

	do_viewmenu(ICONITEM + G.g_cnxsave.vitem_save);
	do_viewmenu(NAMEITEM + G.g_cnxsave.sitem_save);
	G.g_ccopypref = G.g_cnxsave.ccopy_save;
	G.g_cdelepref = G.g_cnxsave.cdele_save;
	G.g_cdclkpref = G.g_cnxsave.cdclk_save;
	G.g_cdclkpref = evnt_dclick(G.g_cdclkpref, TRUE);
	
	for (iwin=0; iwin<NUM_WNODES; iwin++)
	{
	  pws = &G.g_cnxsave.win_save[iwin];
	  if (pws->pth_save[0])
	  {
	    pw = win_alloc(pws->obid_save);
	    if (pw)
	    {
	      pw->w_cvcol = pws->hsl_save;
	      pw->w_cvrow = pws->vsl_save;
	      fpd_parse(&pws->pth_save[0], &drv, &G.g_tmppth[0], 
			&pname, &pext);
	      do_xyfix(&pws->x_save, &pws->y_save);
	      pro_chdir(drv, &G.g_tmppth);
	      if (!DOS_ERR)
	        do_diropen(pw, TRUE, pws->obid_save, drv, &G.g_tmppth[0], 
			&pname, &pext, &pws->x_save);
	      else
	        win_free(pw);
	    }
	  }
	}
	cnx_put();
}

	WORD
main()
{
	WORD		ret;
	WORD		i;
	WORD		done;
	WORD		flags, bdown;
	WORD		ev_which;
	WORD		mx, my, button, kstate, kret, bret;
	MOBLK		p1mor, p2mor;
	ICONBLK		icon_blk;

						/* initialize libraries	*/
	gl_apid = appl_init();
#if UNLINKED
						/* get GEM's gsx handle	*/
	gl_handle = graf_handle(&gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
						/* open a virtual work-	*/
						/*   station for use by	*/
						/*   the desktop	*/
	gsx_vopen();
						/* init gsx and related	*/
						/*   device dependent	*/
						/*   variables		*/
	gsx_start();
#endif
						/* set clip to working	*/
						/*   desk and calc full	*/
	wind_get(0, WF_WXYWH, &G.g_xdesk, &G.g_ydesk, &G.g_wdesk, &G.g_hdesk);

	wind_calc(WC_WORK, 0xffff, G.g_xdesk, G.g_ydesk, G.g_wdesk, G.g_hdesk,
			&G.g_xfull, &G.g_yfull, &G.g_wfull, &G.g_hfull);
						/* init long addrs that	*/
						/*   will be used alot	*/
	G.a_cmd = ADDR(&G.g_cmd[0]);
	G.a_tail = ADDR(&G.g_tail[0]);
	G.a_fcb1 = ADDR(&G.g_fcb1[0]);
	G.a_fcb2 = ADDR(&G.g_fcb2[0]);
	G.a_rmsg = ADDR(&G.g_rmsg[0]);
						/* initialize mouse	*/
	desk_wait(TRUE);
						/* initialize resources	*/
	ini_rsrc();
						/* initialize menus and	*/
						/*   dialogs		*/
	for(i=0; i<NUM_ADTREES; i++)
	  ini_tree(&G.a_trees[i], i);
						/* initialize icons 	*/
						/*   and apps from	*/
						/*   shell memory or	*/
						/*   from DESKTOP.APP	*/
						/*   and DESKHI/LO.ICN	*/
	if (!app_start())
	{
	  fun_alert(1, ST_NOFILE, NULLPTR);
	  do_exit(G.a_cmd, G.a_tail);
	  return(FALSE);
	}
						/* initialize windows	*/
	win_start();
						/* initialize folders,	*/
						/*   paths, and drives	*/
	fpd_start();
						/* show menu		*/
	desk_verify(0, FALSE);			/* should this be here	*/
	menu_bar(G.a_trees[AD_MENU], TRUE);	
						/* establish menu items	*/
						/*   that need to be	*/
						/*   checked, check 'em	*/
	G.g_cviewitem = ICONITEM;
	menu_icheck(G.a_trees[AD_MENU], G.g_cviewitem, TRUE);
	G.g_csortitem = NAMEITEM;
	menu_icheck(G.a_trees[AD_MENU], G.g_csortitem, TRUE);
						/* set up initial prefs	*/
	G.g_ccopypref = TRUE;
	G.g_cdelepref = TRUE;
	G.g_cdclkpref = 3;
						/* initialize desktop	*/
						/*   and its objects	*/
	app_blddesk();
						/* draw the initial desk*/
	do_wredraw(0, G.g_xdesk, G.g_ydesk, G.g_wdesk, G.g_hdesk);
						/* tell pws desktop	*/
						/*   tree is so GEM can	*/
						/*   handle desk drawing*/
	wind_set(0, WF_NEWDESK, G.a_screen, DROOT, 0);
						/* set up current parms	*/
	desk_verify(0, FALSE);
	G.g_wlastsel = 0;
						/* establish desktop's	*/
						/*   state from info 	*/
						/*   found in app_start	*/
	cnx_get();
	men_update(G.a_trees[AD_MENU]); 
						/* get ready for main	*/
						/*   loop		*/
	flags = MU_BUTTON | MU_MESAG | MU_KEYBD;
	done = FALSE;
						/* turn mouse on	*/
	desk_wait(FALSE);
						/* loop handling user	*/
						/*   input until done	*/
	proc_init(3, ADDR(&gl_swtblks[0]) );
	while( !done )
	{
						/* block for input	*/
	  ev_which = evnt_multi(flags, 0x02, 0xff, 0x01, 
				0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
				G.a_rmsg, 0, 0, 
				&mx, &my, &button, &kstate, &kret, &bret);
						/* grab the screen	*/
	  wind_update(TRUE);
						/* handle keybd message */
	  if (ev_which & MU_KEYBD)
	    done = hndl_kbd(kret);
						/* handle button down	*/
	  if (ev_which & MU_BUTTON)
	    done = hndl_button(bret, mx, my, button, kstate);
						/* handle system message*/
	  if (ev_which & MU_MESAG)
	    done = hndl_msg();
						/* free the screen	*/
	  wind_update(FALSE);
	}
	proc_exit();
						/* save state in memory	*/
						/*   for when we come	*/
						/*   back to the desktop*/
	cnx_put();
	app_save(FALSE);
						/* turn off the menu bar*/
	menu_bar(0x0L, FALSE);
#if UNLINKED
						/* close gsx virtual ws	*/
	gsx_vclose();
#endif
						/* exit the gem AES	*/
	ret = appl_exit();
	return(TRUE);
} /* main */
