
/*	fs.h

GEMDOS file system (plus some other things) header

Originally written by JSL.

MODIFICATION HISTORY

	11 Mar 85	SCC	Added bconostat().
	10 Apr 85	SCC	Removed MEDIA_CHANGE.
	12 Apr 85	EWF	Added KBBUFSZ.
			SCC	Installed EWF's change.

NAMES

	JSL	Jason S. Loveman
	SCC	Steve C. Cavender
	EWF	Eric W. Fleischman
*/

#define swp68(x) s68(&x)
#define swp68l(x) s68l(&x)
	
#define NULPTR ((char *) 0)
#define SLASH '\\'
#define MGET(x) ((x *) xmgetblk((sizeof(x) + 15)>>4))
#define dirscan(a,c) ((DND *) scan(a,c,0x10,&negone))
#define bconstat(a) trap13(1,a)
#define bconin(a) trap13(2,a)
#define bconout(a,b) trap13(3,a,b)
/* SCC  11 Mar 85 */
#define bconostat(a) trap13(8,a)
#define getbpb(a) trap13(7,a)
#define getmpb(a) trap13(0,a)
#define rwabs(a,b,c,d,e) if (rwerr = trap13(4,a,b,c,d,e)) 	{	\
		errdrv = e;						\
		longjmp(errbuf,rwerr);				}

#define min(a,b) (((a) < (b)) ? (a) : (b))
#define OFD struct _ofd
#define FCB struct _fcb
#define BPB struct _bpb
#define DND struct _dnd
#define BCB struct _bcb
#define DMD struct _dmd
#define MD struct _md
#define MPB struct _mpb
#define PD struct _pd
#define FTAB struct _ftab

#define SUPSIZ 1024	/* common supervisor stack size (in words) */
#define OPNFILES 40	/* max open files in system */
#define NCURDIR 40	/* max current directories in use in system */
#define NUMSTD 6	/* number of standard files */

#define	KBBUFSZ	80	/* size of typeahead buffer */		/* EWF  12 Apr 85 */

PD	/* this is the basepage format */
{
/* 0x00 */
	long	p_lowtpa;
	long	p_hitpa;
	long	p_tbase;
	long	p_tlen;
/* 0x10 */
	long	p_dbase;
	long	p_dlen;
	long	p_bbase;
	long	p_blen;
/* 0x20 */
	char	*p_xdta;
	PD	*p_parent;	/* parent PD */
	long	p_0fill[1];
	char	*p_env;		/* at offset 2ch (eat your heart out, Lee) */
/* 0x30 */
	char	p_uft[NUMSTD];	/* index into sys file table for std files */
	char	p_lddrv;
	char	p_curdrv;
	long	p_1fill[2];
/* 0x40 */
	char	p_curdir[16];	/* index into sys dir table */
/* 0x50 */
	long	p_2fill[4];
/* 0x60 */
	long	p_3fill[2];
	long	p_dreg[1];	/* dreg[0] */
	long	p_areg[5];	/* areg[3..7] */
/* 0x80 */
	char	p_cmdlin[0x80];
} ;

#define MF_FREE 1
MD
{
	MD	*m_link;
	long	m_start;
	long	m_length;
	PD	*m_own;
} ;

MPB /* memory partition block */
{
	MD	*mp_mfl;
	MD	*mp_mal;
	MD	*mp_rover;
} ;

/* OFD is dirty, because of change to startcl, length, time, date, etc. */
#define O_DIRTY 1
/* traversal of directory file (to buile directory tree) has completed */
#define O_COMPLETE 2
OFD /* open file descriptor */
{
	OFD	*o_link;
	int	o_flag;
	int	o_time;    /* the next 4 item must be in same order as FCB */
	int	o_date;
	int	o_strtcl;
	long	o_fileln;

	DMD	*o_dmd;
	DND	*o_dnode;
	OFD	*o_dirfil;
	long	o_dirbyt;  /* pos in dir of this files fcb (dcnt) */

	long	o_bytnum;  /* byte pointer within file */
	int	o_curcl;   /* current cluster pointer */
	int	o_currec;  /* rec number of current cluster */
	int	o_curbyt;  /* byte offset in current cluster */
	int	o_usecnt;  /* use count for inherited files */
	OFD	*o_thread; /* mulitple open thread list */
        int     o_mod;     /* mode file opened in (r, w, r/w) */
} ;

#define FA_SUBDIR	0x10
#define FA_NORM		0x27
#define FA_RO		0x01
FCB
{
	char	f_name[11];
	char	f_attrib;
	char	f_fill[10];
	int	f_time;
	int	f_date;
	int	f_clust;
	long	f_fileln;
} ;

DND /* directory node descriptor */
{
	char	d_name[11];
	char	d_fill;
	int	d_flag;
	int	d_strtcl;
	int	d_time;
	int	d_date;
	OFD	*d_ofd;
	DND	*d_parent;
	DND	*d_left; /* child */
	DND	*d_right; /* sib-link */
	DMD	*d_drv;
	OFD	*d_dirfil;
	long	d_dirpos;
	long	d_scan; /* current position in dir for DND tree */
	OFD	*d_files; /* open files on this node */
} ;

BPB /* bios parameter block */
{
	int	recsiz;
	int	clsiz;
	int 	clsizb;
	int	rdlen; /* root directory length in records */
	int	fsiz; /* fat size in records */
	int	fatrec; /* first fat record (of last fat) */
	int	datrec; /* first data record */
	int	numcl; /* number of data clusters available */
	int	b_flags; /* bit 0 = 0 for 12-bit fat, 1 for 16-bit */
} ;

DMD /* drive media block */
{
	int	m_recoff[3]; /* record offsets for fat,dir,data */
	int	m_drvnum;
	int	m_fsiz;
	int	m_clsiz;
	int	m_clsizb;
	int	m_recsiz;

	int	m_numcl;
	int	m_clrlog; /* clsiz in rec, log2 is shift */
	int	m_clrm;	 /* clsiz in rec, mask */
	int	m_rblog;  /* recsiz in bytes, shift */
	int	m_rbm;   /* recsiz in bytes, mask */
	int	m_clblog;
	OFD	*m_fatofd;

	OFD	*m_ofl;
	DND	*m_dtl; /* directory tree list */
	int	m_16; /* 16 bit fat ? */
} ;

BCB
{
	BCB	*b_link;
	int	b_bufdrv;
	int	b_buftyp;
	int	b_bufrec;
	int	b_dirty;
	DMD	*b_dm;
	char	*b_bufr;
} ;

/* point these at OFDs when needed */
FTAB
{
	OFD	*f_ofd;
	PD	*f_own; /* file owners */
	int	f_use;  /* use count */
} ;

