
/*	CALC.C		08/03/84 - 11/10/84	Andrew Muir		*/

/*** INCLUDE FILES ******************************************************/

#include <portab.h>
#include <machine.h>
#include <obdefs.h>
#include <taddr.h>
#include <crysbind.h>
#include <calclock.h>

/*** DEFINES ***********************************************************/

GLOBAL BYTE	*gl_disp;

/*** GLOBAL VARIABLES ***************************************************/

EXTERN WORD	gl_apid;
EXTERN WORD	gl_handle;

GLOBAL WORD	gl_rmsg[8];
GLOBAL LONG	ad_rmsg;
GLOBAL LONG	ad_calc;
GLOBAL WORD	wh_calc;
GLOBAL WORD	gl_itcalc;

GLOBAL LONG	ad_clok;
GLOBAL WORD	wh_clok;
GLOBAL WORD	gl_itclok;	

GLOBAL WORD	gl_xdesk;
GLOBAL WORD	gl_ydesk;
GLOBAL WORD	gl_wdesk;
GLOBAL WORD	gl_hdesk;

GLOBAL WORD	gl_flags;
GLOBAL WORD	gl_button;
GLOBAL WORD	gl_wtop;

GLOBAL WORD	gl_wchar;
GLOBAL WORD	gl_hchar;
GLOBAL WORD	gl_wbox;
GLOBAL WORD	gl_hbox;
GLOBAL WORD     color;

WORD		last_op, last_inp, last_key;
BYTE		inp_str[DISP_LEN+1], inp_idx;

BYTE	stack_num;
BYTE	dec_pt1,dec_pt2;
UBYTE	neg1,neg2;
BYTE	num_dig;
WORD	add_on;
BYTE	stack_pt;
BYTE	pt_seen,eror;
UBYTE	op1[10],op2[10],result[10],memory[10];
BYTE	temp_pt;
WORD	al_min,al_hour;
WORD	done_one;
WORD	al_set;
WORD	not_zero;
LONG    MEMEMPTY;
LONG    MEMFULL;
LONG    TIMEON;
LONG    ALARMON;
 


/*
*	Initializes the clock. Assigns the ted infos to the proper objects
*	and the strings to the proper ted infos.
*/
	LONG
ini_clok()
{
	LONG		tree;
	WORD		i, j;
	BYTE		*ptemp;

	tree = ADDR(&the_clok[0]);
	ptemp = clok_str[0];
        TIMEON = 0x09001100L;
        ALARMON = 0x0a001200L;

	j = 0;
	for (i=0; i < CLOK_OBS; i++)
	{
	  rsrc_obfix(tree, i);
	  if (the_clok[i].ob_type == G_BOXTEXT)
	  {
	    the_clok[i].ob_spec = ADDR(&clok_ted[j]);
	    clok_ted[j].te_ptext = ADDR(clok_str[j]);
	    ptemp = clok_str[j];
            ptemp[0] = ' ';
            ptemp[1] = ' ';
	    j++;
          }
	}
					/* If the current system has more   */
					/* than two colors, change the color*/					/* and the fill pattern to take ad- */
					/* vantage of that fact		    */
 	if (color != 1)
	  {	
           TIMEON = 0x09001170L;
           ALARMON = 0x0a001270L;
	   the_clok[THEALARM].ob_state = NORMAL;
	   the_clok[3].ob_spec = 0x09001170L;	
	   the_clok[4].ob_spec = 0x20001273L;	
	   the_clok[6].ob_spec = 0x3a001173L;	
	   the_clok[8].ob_spec = 0x20001173L;	
	   the_clok[10].ob_spec = 0x20001273L;	
	   the_clok[11].ob_spec = 0x0b001170L;	
	   the_clok[14].ob_spec = 0x2f001475L;	
	   the_clok[16].ob_spec = 0x2f001475L;	
	   the_clok[17].ob_spec = 0x20001475L;	
	   clok_ted[0].te_color = 0x1173;
	   clok_ted[1].te_color = 0x1173;
	   clok_ted[2].te_color = 0x1173;
	   clok_ted[3].te_color = 0x1175;
	   clok_ted[4].te_color = 0x1175;
	   clok_ted[5].te_color = 0x1175;
	   clok_ted[6].te_color = 0x1175;
	  }  
	return(tree);
}  /* ini_clok */

/*
*	Initializes the calculator. Assigns the ted infos to the proper
*	objects	and the strings to the proper ted infos.
*/
	LONG
ini_calc()
{
	LONG		tree;
	WORD		i, j;

	tree = ADDR(&the_calc[0]);
	gl_disp = the_str[0];

	j = 0;			  
        MEMEMPTY = 0x20001106L;
        MEMFULL =  0x6d001106L;
	for (i=0; i<NUM_OBS; i++)
	{
	  rsrc_obfix(tree, i);
	  if (the_calc[i].ob_type == G_BOXTEXT)
	  {
	    the_calc[i].ob_spec = ADDR(&the_ted[j]);
	    the_ted[j].te_ptext = ADDR(the_str[j]);
	    j++;
          }
	}
					/* If the current system has more   */
					/* than two colors, change the color*/					/* and the fill pattern to take ad- */
					/* vantage of that fact		    */
	if (color != 1)
	  {
           MEMEMPTY = 0x20001176L;
	   MEMFULL  = 0x6d001176L;
	   the_calc[0].ob_spec = 0x00fd1274L;
	   the_calc[3].ob_spec = 0x43ff1175L;
	   the_calc[5].ob_spec = 0x2aff1175L;
	   the_calc[7].ob_spec = 0x37ff1170L;
	   the_calc[8].ob_spec = 0x38ff1170L;
	   the_calc[9].ob_spec = 0x39ff1170L;
	   the_calc[10].ob_spec = 0x2fff1175L;
	   the_calc[12].ob_spec = 0x34ff1170L;
	   the_calc[13].ob_spec = 0x35ff1170L;
	   the_calc[14].ob_spec = 0x36ff1170L;
	   the_calc[15].ob_spec = 0x2bff1175L;
	   the_calc[17].ob_spec = 0x31ff1170L;
	   the_calc[18].ob_spec = 0x32ff1170L;
	   the_calc[19].ob_spec = 0x33ff1170L;
	   the_calc[20].ob_spec = 0x2dff1175L;
	   the_calc[22].ob_spec = 0x30ff1170L;
	   the_calc[23].ob_spec = 0x2eff1175L;
	   the_calc[24].ob_spec = 0x25ff1175L;
	   the_calc[25].ob_spec = 0x20001176L;
	   the_calc[26].ob_spec = 0x20001176L;
	   the_calc[27].ob_spec = 0x3dff1175L;
	   the_ted[0].te_color = 0x1176;
	   the_ted[1].te_color = 0x1175;
	   the_ted[2].te_color = 0x1175;
	   the_ted[3].te_color = 0x1175;
	   the_ted[4].te_color = 0x1175;
	   the_ted[5].te_color = 0x1175;
	   the_ted[6].te_color = 0x1175;
	  }  
	return(tree);
} /* ini_calc */


/*
*		Clears the calculator's display
*/

	VOID
clr_calc()
{
	WORD		ii;

	for(ii = 0; ii < DISP_LEN; inp_str[ii++] = ' ');
	inp_str[DISP_LEN] = NULL;
	inp_idx = 0;
	inp_str[0] = '0';
} /* clr_calc */




/*
* 		Dispalys,on the calculator the string pointed to by
*		pnumstr.
*/
	VOID
display(pnumstr)
	BYTE		*pnumstr;
{
 	WORD		ii, jj;
	WORD		xdisp, ydisp;       
					/* right-just display string	*/
	jj = DISP_LEN;
	for (ii = jj; ii >= 0; ii--)
	{
	  if (pnumstr[ii] != ' ')
	  {
	    gl_disp[jj] = pnumstr[ii];
	    jj--;
	  } /* if */
	} /* for */
	for (ii = jj; ii >= 0; gl_disp[ii--] = ' ');
	objc_offset(ad_calc,THEDISP,&xdisp,&ydisp);
	objc_draw(ad_calc,THEDISP,0,xdisp,ydisp,
  	         the_calc[THEDISP].ob_width,the_calc[THEDISP].ob_height);	 
} /* display */


/*
*		Opens the desk accessorie's window.
*/
	VOID
do_open(wh, x, y, w, h)
	WORD		wh;
	WORD		x, y, w, h;
{
	graf_mouse(2, 0x0L);
	graf_growbox(2*gl_wchar, 0, 4*gl_wchar, gl_hchar, x, y, w, h);
	wind_open(wh, x, y, w, h);
	graf_mouse(0, 0x0L);
} /* do_open */


/*
*		Closes the desk accessorie's window.
*/
	VOID
do_close(wh)
	WORD		wh;
{
	WORD		x, y, w, h;

	graf_mouse(2, 0x0L);
	wind_get(wh, WF_CXYWH, &x, &y, &w, &h);
	wind_close(wh);
	graf_shrinkbox(2*gl_wchar, 0, 4*gl_wchar, gl_hchar, x, y, w, h);
	graf_mouse(0, 0x0L);
} /* do_close */



/*
*		Draws the object "obj_disp",from either the clock
*		or the calculator trees.
*/
	WORD
do_redraw(w_handle,obj_disp,depth, xc, yc, wc, hc)
	WORD		w_handle;
	BYTE		obj_disp;
	WORD		depth;
	WORD		xc, yc, wc, hc;
{
	WORD		x, y, w, h,tree;

	graf_mouse(M_OFF, 0x0L);

	wind_get(w_handle, WF_FIRSTXYWH, &x, &y, &w, &h);
	while ( w && h )
	{
	  if ( r_intersect(xc, yc, wc, hc, &x, &y, &w, &h) )  
	    {	
	     if (w_handle == wh_calc)
	       objc_draw(ad_calc, obj_disp, depth, x, y, w, h);
	     if (w_handle == wh_clok)
	       objc_draw(ad_clok, obj_disp, depth, x, y, w, h);  
	    }
	  wind_get(w_handle,WF_NEXTXYWH, &x, &y, &w, &h);
	}
	graf_mouse(M_ON, 0x0L);
} /* do_redraw */

/*
*		Creates and positions the desk accessorie's window
*		and opens the accessory onto the window.
*/
	WORD
ac_open(olist, pname)
	OBJECT		olist[];
	BYTE		*pname;
{
	WORD		wh;
	WORD		x, y, w, h;

					/* 0x0B = NAME | CLOSER | MOVER	*/
	wh = wind_create(0x000B, gl_xdesk, gl_ydesk, gl_wdesk, gl_hdesk);
	if (wh != -1)
	  {
	   wind_set(wh, WF_NAME, ADDR(pname), 0, 0);
	   wind_calc(WC_BORDER, 0x000B, olist[0].ob_x, olist[0].ob_y,
				olist[0].ob_width, olist[0].ob_height,
				&x, &y, &w, &h);
	   x = wm_xfix(x); 
	   y = wm_yfix(y); 
	   wind_calc(WC_WORK, 0x000B, x, y, w, h, &olist[0].ob_x, &olist[0].ob_y,
				&olist[0].ob_width, &olist[0].ob_height);
	   gl_wtop = wh;
	   do_open(wh, x, y, w, h);
	  }
	return(wh);
}

/*
*		aligns the desk accessories window with a byte
*		boundary.
*/
	WORD
wm_xfix(rx)
	WORD	rx;
{ 	       
	return((rx & 0xfff0) + ((rx & 0x000c) ? 0x10 : 0));
}
  
/*
*		aligns the desk accessories window with a byte
*		boundary.
*/
	WORD
wm_yfix(ry)
	WORD	ry;
{ 	       
	return(ry & 0xfffe);
}
  

/*
*		Processes all messages sent to the desk accessories
*/

	VOID
hndl_mesag()
{
	WORD		ii;
	WORD		x, y, w, h;

	x = gl_rmsg[4];
	y = gl_rmsg[5];
	w = gl_rmsg[6];
	h = gl_rmsg[7];

	switch( gl_rmsg[0] )
	{
	  case AC_OPEN:	   
						/* Opens the calculator    */
						/* and clears the display. */
		   if ( (gl_rmsg[4] == gl_itcalc) && 
		        (!wh_calc) )
		     {
		      wh_calc = ac_open(&the_calc[0], " Calculator "); 
		      zero_clr();	
		      display(&inp_str);
		      if (wh_calc == -1)
			wh_calc = 0;
		     }
						/* Opens the clock. */
		if ( (gl_rmsg[4] == gl_itclok) && 
		        (!wh_clok) )
		{	
		  wh_clok = ac_open(&the_clok[0], " Clock "); 
	          if (wh_clok == -1)
		    wh_clok = 0;
		}
		break;
	  case WM_REDRAW:
						/* Draws the desk accessory */
						/* whose handle is in	    */
						/* gl_rmsg[3].		    */

		do_redraw(gl_rmsg[3],ROOT,1, x, y, w, h);

						/* If the clock was drawn  */
						/* it displays the correct */
						/* time and date.	*/

		if (gl_rmsg[3] == wh_clok)
		   {
		    show_hour();
		    show_min();
		    show_ampm();    
		    show_month();
		    show_date();
		    show_year();	 
		   }		
		break;				    
	  case WM_TOPPED:
							/* Brings the desk  */
							/* accessory whose  */
							/* handle is in     */
							/* gl_rmsg[3] to    */
							/* top.		    */

		wind_set(gl_rmsg[3], WF_TOP, 0, 0, 0, 0);
		gl_wtop = gl_rmsg[3];
		break;
	  case WM_CLOSED:
						/* Close the top desk ac- */
						/* cesory.	          */
		do_close(gl_rmsg[3]);
		wind_delete(gl_rmsg[3]);
		if (gl_wtop == wh_calc)
		{
                  wh_calc = 0;	      
							/* Clear memory. */
/*		  the_calc[MEMFLG].ob_spec = MEMEMPTY;
		  for (ii = 0;ii < 10;memory[ii++] = 0);*/
		  gl_wtop = wh_clok;
							/* Clear display. */

		  for (ii = 0;ii < DISP_LEN - 1;gl_disp[ii++] = 0);
		  zero_clr();
                }
		else
		{
		  if (gl_wtop == wh_clok)
		  {		     
		    wh_clok = 0;	     
		    gl_wtop = wh_calc;
		    the_clok[SW_TIME].ob_spec = TIMEON;	
                  }
		}
		break;
	  case AC_CLOSE:
					/* Close the desk accessory */
					/* when an application ter- */
					/* ates.		    */	
		wh_clok = 0;
		wh_calc = 0;
		if  (gl_rmsg[4] == gl_itclok)
		  {
		   the_clok[SW_TIME].ob_spec = TIMEON;	
                  }
					/* Clear the calculator display */
		if  (gl_rmsg[4] == gl_itcalc)
		{	
		  for (ii=0; ii < DISP_LEN - 1; gl_disp[ii++]=' ');
		  gl_disp[DISP_LEN] = NULL;
		  for (ii = 0;ii < DISP_LEN - 1;gl_disp[ii++] = 0);
		  zero_clr();
		  gl_disp[0] = '0';
							/* Clear memory. */
		  the_calc[MEMFLG].ob_spec = MEMEMPTY;
		  for (ii = 0;ii < 10;memory[ii++] = 0);
		}
		break;
	  case WM_MOVED:
						/* Move the desk accessory */
		x = wm_xfix(gl_rmsg[4]);
		y = wm_yfix(gl_rmsg[5]);
		wind_set(gl_rmsg[3], WF_CXYWH, x, y, w, h);
		wind_get(gl_rmsg[3], WF_WXYWH, &x, &y, &w, &h);
		if (gl_rmsg[3] == wh_calc)
		{
	          the_calc[ROOT].ob_x = x;
	          the_calc[ROOT].ob_y = y;
		}
	        if (gl_rmsg[3] == wh_clok)
		{
	          the_clok[ROOT].ob_x = x;
	          the_clok[ROOT].ob_y = y;
		}
		break;
	} /* switch */
	gl_rmsg[0] = 0;
} /* hndl_mesag */


/*
*		Creates the error message.
*/
	VOID
dsply_err() 
{	       
	clr_calc();
	strcpy("error", &inp_str[0]);
/*	stack_num = 1;*/
	stack_pt = 19;
	pt_seen = 0;	
}


/*		
*		Check for the overflow error.If the error occurs display
*		the error message.
*/
	VOID
over_err()
{
	if (num_dig > 13)
	{
	  eror = TRUE;
	  dsply_err();	  
	} 
}             


/*
*		Check for the divide by zero error. If the error occurs dis-
*		play the error message.
*/

	VOID
zero_err()
{
	BYTE		non_zero;
	WORD		ii;

	non_zero = FALSE;
   	if (last_op == DIVIDE)
        {
	  for (ii = 1;ii < 10;ii++)
            if (op2[ii] != 0)
              non_zero = TRUE;
          if (!non_zero)
          {
            eror = TRUE;
	    dsply_err();
          }					 
	}
}	

/*
*		Check for error conditions, and if none exist perform
*		the operation.
*/

	VOID
do_op(oper)
	WORD		oper;
{
	if (!eror)	
	  zero_err();
        if (!eror) 
	{
	switch( oper )
	{	
	  case PLUS:
	  	_FLD_ADD(result,op2,op1);
		break;
	  case TIMES:			   
		_FLD_MUL(result,op2,op1);
		break;
	  case MINUS:			   
		_FLD_SUB(result,op2,op1);
		break;
	  case DIVIDE:
		_FLD_DIV(result,op2,op1);
		break;
	}
	if (result[0] == 0)
	  result[0] = 63;
     }
}


/*
*		Take the parameter "number" and push it on one of the
*		operand stacks.Most significant digit in the first half
*		of the last byte. Second most significant in the second
*		half of the last byte.
*/

	VOID
push_bcd(number)
	BYTE	number;				
{
	UBYTE	tmp_num;

	tmp_num =  number - '0'; 
	if (stack_pt % 2)
	   tmp_num = (tmp_num << 4) & 0xf0;
        if (stack_num == 0)
           op1[stack_pt/2] = (op1[stack_pt/2]) | tmp_num;
         else
            op2[stack_pt/2] = (op2[stack_pt/2]) | tmp_num;
	stack_pt--;
}			


/*
*	Clears out trailing zeroes.  If the last non-zero value is a
*	decimal point then it clears that out too.  If everything was
*	cleared out then it turns the whole display into a single zero.
*/
	VOID
clr_zero()
{      	    
	WORD		jj;
  
	jj = 14;
       	while (((inp_str[jj] == '0') ||
		(inp_str[jj] == ' ')) &&
		 (jj >= temp_pt))
	  inp_str[jj--] = ' ';			     
	if (inp_str[jj] == '.')
	  inp_str[jj] = ' ';		
	if (inp_str[0] == ' ')
          clr_calc();
}


/*
*	Adds a leading minus sign to the display string.  This should only
*	be called if the sign of the display is negative
*/
	VOID
do_sign()
{	
	WORD		jj;

        for (jj = 12;jj >= 1;jj--)
	  inp_str[jj + 1] = inp_str[jj];
        inp_str[1] = inp_str[0];	
        inp_str[0] = '-';	  
	temp_pt++;	
}	  


/*
*	Clears the calculators display string and draws a zero display.
*	Then takes the result of the last operation and converts it into 
*	a number that can be placed in the display string.
*/
	VOID
get_rslt()
{
	BYTE		num_temp;
	BYTE		temp;
	WORD		counter;
	WORD		ii;

	clr_calc();
	counter = 19;	
	if ((result[0] & 0x7f) < 63)
	  temp_pt = (63 - (result[0] & 0x7f));
        else
	  temp_pt = ((result[0] & 0x7f) - 63);
	for(ii = 0;ii < 13;ii++)
	{
	  if (counter > 2)
	  {	
	    temp = result[counter/2];
	    num_temp = counter << 7;
	    counter-- ;
	    if (num_temp)
	      temp  = (temp & 0xf0) >> 4;
	    else
	      temp = temp & 0x0f;			   
	    inp_str[ii] = temp + '0';
	  }
	}
						/* if a fraction, then	*/
						/*   put in the right #	*/
						/*   of leading zeroes	*/
	if (((result[0] & 0x7f) <= 63) && 
	    (!(((result[0] & 0x7f) == 63) && 
	     (last_op == TIMES))))		   
	{
	 if (last_op == TIMES)
           temp_pt--;
	 if (last_op == DIVIDE)
           temp_pt++;
	 temp_pt = (temp_pt > 14) ? 14 : temp_pt;
	 for (ii = 14;ii >= temp_pt;ii--)
	   inp_str[ii] = inp_str[ii - temp_pt];
	 if (!((inp_str[0] == '0') && (inp_str[1] != '.')))
	   for (ii = 0;ii < temp_pt;inp_str[ii++] = '0');
	 if (last_op == TIMES)
	   temp_pt++;
	 if (last_op == DIVIDE)
           temp_pt--;
	}
}


/*
*	Zero the calculator display string and other related globals
*/
	VOID
zero_res()
{
	  zero_clr();
	  stack_num = 0;
	  last_op = NOP;
	  eror = FALSE;
}


/*
*	Convert raw display string from last operation into a 
*	displayable string with a decimal point and a sign.
*/
	VOID
pop_bcd()
{
	WORD		ii;

						/* get raw display str.	*/
	get_rslt();
						/* special kludge for 	*/
						/*   times and divide	*/
	if ((last_inp != RETMEM) && (last_inp != PERCENT))
	{	
	  if (last_op == TIMES)
	    temp_pt++;
	  if ((last_op == DIVIDE) && (temp_pt != 0))
	    temp_pt--;
	}
						/* insert decimal pt	*/
	temp_pt = ((result[0] & 0x7f) < 63) ? 0 : temp_pt;
	for (ii = 13;ii >= temp_pt;ii--)
	  inp_str[ii + 1] = inp_str[ii];
	inp_str[temp_pt] = '.';
						/* insert minus sign	*/
        if ((result[0] & 0x7f) < 63) 
          temp_pt = 1;
	if (result[0] & 0x80)	     
	  do_sign();
						/* clear trailing zeros	*/
	clr_zero();
/*	if ((inp_str[0] == '0') && (inp_str[1] != '.'))
	{
	  last_inp = NOP;
	  zero_res();
	}  */
}

/*
*		Changes the sign of the number in the display.
*/

	VOID
do_neg()
{
	WORD		ii;

	if (inp_str[0] != '0') 
        {
	  if ((stack_num == 0) ||
	      (last_inp == EQUAL) ||
                    (last_inp == NOP))
					/* Change the first operand. */
	   {
	     if (last_inp == RETMEM)
	     {
					/* Loads the contents of the memory */
					/* into the first operand.	    */

	       for (ii = 0;ii < 10;op1[ii] = memory[ii++]);
	       dec_pt1 = (op1[0] & 0x7f) - 64;
	       neg1 = (memory[0] & 0x80);
	       op1[0] = (op1[0] ^ 0x80);	
      	     }			   
	     if (last_inp == EQUAL)
	     { 
	       neg1 = (op1[0] & 0x80);	
			
	       op1[0] = (op1[0] ^ 0x80);

	      }  
	      neg1 = (neg1 ^ 0x80);
	     }	
            else
	      {
	       if (last_inp == RETMEM)
		 {			    
	          for (ii = 0;ii < 10;op2[ii] = memory[ii++]);
		  dec_pt2 = (op2[0] & 0x7f) - 64;
		  neg2 = (memory[0] & 0x80);
		 }
	       neg2 = (neg2 ^ 0x80);
	       op2[0] = (op2[0] ^ 0x80);
	      }
	   if (last_inp != EQUAL)
	     last_inp = NUM;
          if (inp_str[0] == '-')
	  { 
	    inp_str[0] = inp_str[1];
	    for (ii = 1;ii < 14;ii++)
              inp_str[ii] = inp_str[ii + 1];
          }			
          else	       	  
					/* Display the sign of the number */
					/* in the display.		  */
	    do_sign();
	}	   
	  last_inp = (inp_str[0] == '0') ? NOP : PLUMIN;
	 
}


/*
*		Clears the last entry of the calculator.
*/

	VOID
clr_ent(stk_num)
	WORD		stk_num;
{
	WORD		ii;
				/* Set the display to "0" */
	clr_calc();
	num_dig = 0;
	pt_seen = 0;
	stack_pt = 19;
	add_on = 64;
				/* Clear the first operand, */
				/* and reset the flags.     */
	if (stk_num == 0)
	{
	  dec_pt1 = 64;
	  neg1 = 0;
	  for (ii = 0; ii < 10;op1[ii++] = 0);
	}
	else
	{
	  dec_pt2 = 64;	
	  neg2 = 0;
	  for (ii = 0; ii < 10;op2[ii++] = 0);
	}
}

/*
*		Clear the contents of the memory and clear the displays
*		memory flag.
*/
 
	VOID
clr_mem()
{
	WORD		ii;

	for (ii=1; ii < 10; memory[ii++] = 0);
	memory[0] = 64;
	the_calc[MEMFLG].ob_spec = MEMEMPTY;
						/* Draw the memory flag */
	objc_draw(ad_calc, MEMFLG , 0,
                  the_calc[MEMFLG].ob_x + the_calc[ROOT].ob_x,
		  the_calc[MEMFLG].ob_y + the_calc[ROOT].ob_y,
		  the_calc[MEMFLG].ob_width,the_calc[MEMFLG].ob_height);
}

/*
*		Display the contents of the memory.
*/

	VOID
ret_mem()
{
	WORD		ii;

	for (ii=0; ii < 10; result[ii] = memory[ii++]);
	last_inp = RETMEM;
	pop_bcd(); 
	inp_idx = 0;
	num_dig = 0;
}

/*
*		Transfers the results of all arithmatic involving the
*		memory from the result stack to the memory. As well as
*		setting the displays memory flag.
*/

	VOID
mem_op()
{
	WORD		ii;

        for (ii = 0;ii < 10;memory[ii] = result[ii++]);
	last_inp = EQUAL;
	the_calc[MEMFLG].ob_spec = MEMFULL;
	objc_draw(ad_calc, MEMFLG , 0,
                  the_calc[MEMFLG].ob_x + the_calc[ROOT].ob_x,
		  the_calc[MEMFLG].ob_y + the_calc[ROOT].ob_y,
		  the_calc[MEMFLG].ob_width,the_calc[MEMFLG].ob_height);
}

/*
*		Adds the value shown in the display to the memory.
*/

	VOID
mem_plus()
{
	WORD		ii;

    	if (((stack_num == 0) || (last_inp == EQUAL)) || 
             ((stack_num == 1) && (last_inp == PLUMIN)))
	 {  	
	   if (dec_pt1 == 64)
	     dec_pt1 = num_dig - 1;
	   if (last_inp == PLUMIN)
	      {
	       if (last_op == DIVIDE)
		  op1[0]--;
	       if ((last_op == TIMES) || (last_op == PLUS))
		  op1[0]++;
	      }	
	   if ((last_inp == PLUMIN) && (op1[0] == 0))
             op1[0] = (64 + dec_pt1) | neg1;
	   if ((last_inp != EQUAL) && (last_inp != PLUMIN))
             op1[0] = (64 + dec_pt1) | neg1;
	   dec_pt1 =64;
	   if (last_inp == RETMEM)
	     for (ii = 0;ii < 10;op1[ii] = memory[ii++]);	
	   _FLD_ADD(result,op1,memory);
      	  }
        else
	   {
	    if (dec_pt2 == 64)
	      dec_pt2 = num_dig - 1;
            op2[0] = (64 + dec_pt2) | neg2;
	    dec_pt2 = 64;	
	   if (last_inp == RETMEM)
	     for (ii = 0;ii < 10;op2[ii] = memory[ii++]);
           _FLD_ADD(result,op2,memory);
	   }	  
	mem_op(); 
}

/*
*		Subtracts the number in the display from the
*		contents of the memory.
*/		
						
	VOID
mem_sub()
{
	WORD		ii;


    	if (((stack_num == 0) || (last_inp == EQUAL)) || 
             ((stack_num == 1) && (last_inp == PLUMIN)))
	 {  	
	   if (dec_pt1 == 64)
	     dec_pt1 = num_dig - 1;
	   if (last_inp == PLUMIN)
	      {
	       if (last_op == DIVIDE)
		  op1[0]--;
	       if ((last_op == TIMES) || (last_op == PLUS))
		  op1[0]++;
	      }	
	   if ((last_inp == PLUMIN) && (op1[0] == 0))
             op1[0] = (64 + dec_pt1) | neg1;
	   if ((last_inp != EQUAL) && (last_inp != PLUMIN))
             op1[0] = (64 + dec_pt1) | neg1;
	   dec_pt1 =64;
	   if (last_inp == RETMEM)
	     for (ii = 0;ii < 10;op1[ii] = memory[ii++]);
	   _FLD_SUB(result,op1,memory);
      	  }
        else
	   {
	    if (dec_pt2 == 64)
	      dec_pt2 = num_dig - 1;
            op2[0] = (64 + dec_pt2) | neg2;
	    dec_pt2 = 64;	
	   if (last_inp == RETMEM)
	     for (ii = 0; ii < 10;op2[ii] = memory[ii++]);
           _FLD_SUB(result,op2,memory);
	   }	  
	mem_op(); 
}


/*
*		Performs the arithmatic operation specified.
*/

	VOID
solve()
{	      
	WORD		dummy;
	WORD		ii;
	WORD		the_same;

				/*Reset the flags */
        dec_pt2 = 64;	
	neg1 = 0;
	neg2 = 0;
	add_on = 64;
	not_zero = FALSE;
	pt_seen = 0;
	the_same = TRUE;
				/* Perform the arithmatic operation */
	do_op(last_op);  
				/* Check for error conditions  and  */
				/* display the result, if no error. */
	over_err();	
	if (!eror)				  
	  pop_bcd();
	dummy = result[0] & 0x7f;
        if (dummy > 76)
          dsply_err();	
	eror = FALSE;	
				/* Transfer the result to the first operand */

	for(ii = 0;ii < 10;op1[ii++] = NULL);	
	for(ii = 0;ii < 10;op1[ii] = result[ii++]);
        num_dig = 0;
	inp_idx = 0;
	stack_pt = 19;
				/* Correct the exponent */
	if (last_op == TIMES)
          op1[0]++;
        if (last_op == DIVIDE)
          op1[0]--;	
}

/*
*		Set the second operand up for the operation.
*
*/

	VOID
set_op2()
{	 
 	if (dec_pt2 == 64)
	   dec_pt2 = num_dig - 1; 
        num_dig = 0; 
	op2[0] = (add_on + dec_pt2) | neg2;	    
	add_on = 64;
	if (last_inp == PERCENT)
	  op2[0] = result[0];      
}

/*
*		Reset the calculator.
*/

	VOID
zero_clr()
{
	WORD		ii;

	clr_ent(0);
	clr_ent(1);
}


/*
*		Process all calculator functions.
*/

	WORD
hndl_calc(obj)
	WORD		obj;
{
	WORD		operand;
	WORD		value;
	WORD		ii;
	BYTE		is_neg;
	BYTE		inp_num;

	value = 0;
	switch(obj)
	{
	  case THECALC:
		break;
	  case NINE:
		value++;
	  case EIGHT:
		value++;
	  case SEVEN:
		value++;
	  case SIX:
		value++;
	  case FIVE:
		value++;
	  case FOUR:
		value++;
	  case THREE:
		value++;
	  case TWO:
		value++;
	  case ONE:
		value++;
	  case ZERO:
					/* If a digit is selected, push     */
					/* it on the correct operand stack. */

		if ( (last_inp == EQUAL) ||
		     (last_inp == RETMEM)  )  

					/* Reset calculator */
		  zero_res();
	        if ( (last_inp == NOP) ||
		     (last_inp == EQUAL)  )

					/* Clear for a new number */
       		  clr_calc();
		
		if ((num_dig != 14) && (last_inp != PLUMIN))
		     {
		      if (value != 0) 
			not_zero = TRUE;	
	              inp_num = '0' + value;
		      inp_str[inp_idx++] = value + '0';
					
						/* If the digit is a "0"   */
						/* and only zeros and a    */
						/* decimal point have been */
						/* seen decrement the ex-  */
						/* ponent.		   */ 
		      if ((value == 0) && (!not_zero) && (inp_idx != 1))
			add_on--;
		      else
                      {	 
		        num_dig++;	
	                push_bcd(inp_num);
		      }
					/* If a zero is the first digit */
					/* ignore it.			*/
		      last_inp = NUM;	
	              if ((inp_idx == 1) && (inp_str[0] == '0'))   
		        {
		         inp_idx--;  
		         num_dig--;
		         stack_pt = 19;
/*			 last_inp = NOP; */
		        }	 
                    }
		if (num_dig == 14)
		{
		  clr_ent(stack_num);
		  last_inp = NOP;
		  dsply_err();
		}
		break;
	  case RETMEM:
	  	ret_mem();
		break;
	  case MEMPLU:
		mem_plus();
		break;	     
	  case MEMMIN:
		mem_sub();
		break;
	  case CLRMEM:
		clr_mem();
		break;
	  case PLUMIN:
					/* Can only change sign after a  */
					/* number is displayed.          */
		if (last_inp != NOP)
		{
		  do_neg();
/*		  if (last_inp != EQUAL)
	            last_inp = PLUMIN;*/
		}
		break;
	  case POINT:
		if ( (last_inp == EQUAL) ||
		     (last_inp == RETMEM) || 
		     (last_inp == PLUMIN)  )
			
				/* Reset calculator for a new operation */

		  zero_res();
	       	if ((stack_pt != 1) && (pt_seen == 0))
	       	    {
				/* Clear calculator for a new number */

	       		if (last_inp != NUM)
			     clr_calc();

				/* Set the decimal point to the number of */
				/* digits entered.			  */

			if (num_dig != 14)
			{
			  if (stack_num == 0)		
			    dec_pt1 = inp_idx - 1;
		          else
			    dec_pt2 = inp_idx - 1;
			  last_inp = POINT;
			  inp_str[inp_idx++] = '.';
			  pt_seen = 1;
			}
		    }
		break;	 
	  case PERCENT:

			/* Detremine the percentage of the value, and */
			/* display that percentage.		      */	 
		if (last_inp == NUM)
		  {  
	             if (dec_pt2 == 64)
		       dec_pt2 = num_dig - 1; 
		     last_inp = PERCENT;	
		     op2[0] = 63 + dec_pt2;
		     _FLD_MUL(result,op2,op1);
		     last_inp = PERCENT;
		     pop_bcd();		
		     for (ii = 0;ii < 10;op2[ii] = result[ii++]);
		  }
		break;	
	  case MINUS:
	  case PLUS:
	  case TIMES:
	  case DIVIDE: 		     
		if (last_inp != NOP)
		{
		is_neg = FALSE;
		stack_pt = 19;			  
		pt_seen = 0;
	        if (last_inp == RETMEM)

				/* Transfer the contents of the memory to  */
				/* proper operand stack, and solve the     */
				/* operation if required.		   */
               	  if (stack_num == 0)
		    for (ii = 0;ii < 10;op1[ii] = memory[ii++]);
       	           else
               	     {
	        	for (ii = 0;ii < 10;op2[ii] = memory[ii++]);	 
			last_inp = NOP;
			if (last_op != NOP)
		          solve();
               	     } 
		if ((last_op == NOP) && (last_inp != RETMEM))
		{				      
				/* Setup the first operand */	
		  stack_num = 0;
		  over_err();
		  if (dec_pt1 == 64)
		    dec_pt1 = num_dig - 1;
               	  num_dig = 0;
		  op1[0] = (add_on + dec_pt1) | neg1;
		  add_on = 64;
		  not_zero = FALSE;
		  neg1 = 0;
      	        }
		else	  
                  if ((last_op != EQUAL) && (last_inp != RETMEM))	 
		  {     
		    set_op2();
		    solve();	
		  }
		for(ii = 0;ii < 10;op2[ii++] = NULL);
		for(ii = 0;ii < 10;result[ii++] = NULL);
		last_inp = NOP;
		last_op = obj;		  
		stack_num = 1;
		}
		break;
	  case EQUAL:		
		if (last_op != EQUAL)
		{	   
	          if (last_inp == RETMEM)
		    for (ii = 0;ii < 10;op2[ii] = memory[ii++]);	 
		  else
		    set_op2();	
		  last_inp = EQUAL;
		  solve();
		  stack_num = 1;
		  last_op = EQUAL;
		}
		break;
	  case CLRNTRY:
				/* Clear the last entry. */
		num_dig = 0;
		pt_seen = 0;
		clr_ent(stack_num);
		last_inp = NOP;
                break;
	  case THECLR:
				/* Reset the calculator. */
		last_inp = NUM;
		zero_res();
		break;
	} /* switch */
	  display(&inp_str[0]);
	  if ((last_inp == PERCENT) || 
	      (inp_str[0] == 'e'))	
	    clr_calc ();		
	return(FALSE);
} /* hndl_calc */


/*
*		Convert a key stroke to the proper calculator button.
*/

	WORD
find_chr(key)
	WORD		key;
{
	WORD		ob;
	WORD		value;

	ob = 0;
	value = 0;
	switch(key)
        {
	   case '0':
  		ob = ZERO;
		break;
           case '9':
		value++;
	   case '8':
		value++;
	   case '7':	
		value++;
	   case '6':	
		value++;
	   case '5':	
		value++;
	   case '4':	
		value++;
	   case '3':	
		value++;
	   case '2':	
		value++;
	   case '1':
		ob = (16 - (8 * (value / 3)) + (value + 1));		
		break;
	   case 'M':
	   case 'm':
		ob = THE_M;
		break;	      
	   case 'E':
	   case 'e':
		ob = THE_E;
	        break;
	   case 'R':
	   case 'r':
	       if (last_key == THE_M)
		 ob = RETMEM;
	       break; 			
	   case 'C':
	   case 'c':
		if (last_key == THE_E)
		  ob = CLRNTRY;
                 else
		   if (last_key == THE_M)
		     ob = CLRMEM;
		    else	       
		      ob = THECLR;
		break;
	   case '%':
		ob = PERCENT;
		break;
	   case '+':
		if (last_key == THE_M)
		  ob = MEMPLU;
		 else
	           ob = PLUS;
		break;
	   case '-':  
		if (last_key == THE_M)	
		  ob = MEMMIN;
		 else
		   ob = MINUS;
		break;
	    case '*':
		ob = TIMES;
		break;
	    case 92:
		ob = PLUMIN;
		break;	
	    case '/':
		ob = DIVIDE;
		break;
	    case '.':
		ob = POINT;
		break;
	    case '=':
		ob = EQUAL;
		break;
    }
	return(ob);
}


/************************************************************************/
/****************************** THE CLOCK *******************************/
/************************************************************************/


/*
*		Display the clock object specified by the parmater dsp_obj.
*/

	VOID
disp_clok(dsp_obj)
	WORD		dsp_obj;
{
	WORD		xdsp,ydsp;       			   

	objc_offset(ad_clok,dsp_obj,&xdsp,&ydsp);
	do_redraw(wh_clok,dsp_obj,0,xdsp,ydsp,
  	         the_clok[dsp_obj].ob_width,the_clok[dsp_obj].ob_height);	 
}  /* disp_clok */


/*
*		Decide wether it is AM or PM and display the appropriate
*		one.
*/

	VOID
show_ampm()
{
	UWORD		time;
	BYTE		*ptemp;

	ptemp = clok_str[2];
				/* Get the alarm hour if the alarm is */
				/* currently displayed.		      */

	if (the_clok[SW_TIME].ob_spec == ALARMON)
	  time = al_hour;
	 else
	   {
            time = dos_gtime();
            time >>= 8;
	   }
	ptemp[0] = (time > 11) ? 'p' : 'a';
	ptemp[1] = 'm'; 
	disp_clok(AM_PM); 
} 

/*
*		Convert from an integer value to an ascii value.
*/

	VOID
i_to_a(ival, zlead, pstr)
	UWORD		ival;
	WORD		zlead;
	BYTE		pstr[];
{
	pstr[0] = (ival / 10) + 48;
	pstr[1] = (ival % 10) + 48;
	if ( (!zlead) &&
	     (pstr[0] == '0') )
	  pstr[0] = ' ';
}


/*
*			Determine the corect monute and display it.
*/
	VOID
show_min()
{
	UWORD		time;
	BYTE		*ptemp;

	ptemp = clok_str[1];
	if (the_clok[SW_TIME].ob_spec == ALARMON)
	  time = al_min;
	 else
	   {
	    time = dos_gtime();
	    time &= 0x00ff;
	   }
	i_to_a(time, TRUE, &ptemp[0]);
	disp_clok(MINUTE);  
}


/*
*		Determine the correct hour and display it.
*/

	VOID
show_hour()
{
	UWORD		time;
	BYTE		*ptemp;

	ptemp = clok_str[0];
	if (the_clok[SW_TIME].ob_spec == ALARMON)
	  time = al_hour;
	 else
	   {
	    time = dos_gtime();
	    time >>= 8;
	   }
				/* Convert from 0 - 23 scale to 0 - 11 */
	if (time > 11)
	  {
	   if (time > 12)
   	     time -= 12;	
	  }
				/* Convert from 0 - 11 scale to 1 -12 */
	if (time == 0)
	  time = 12;	
	i_to_a(time, FALSE, &ptemp[0]);
  	disp_clok(HOUR);   
} 

/*
*		Determine the correct month and display it.
*/

	VOID
show_month()
{
	UWORD		date;
	BYTE		*ptemp;

	ptemp = clok_str[4];
	date = dos_gdate();
	date >>= 8;
	i_to_a(date, FALSE, &ptemp[0]);
	disp_clok(MONTH);    
}

/*
*		Deteemine the correct date and display it.
*/

	VOID
show_date()
{
	UWORD		date;
	BYTE		*ptemp;

	ptemp = clok_str[5];
	date = dos_gdate();
	date &= 0x00ff;
	i_to_a(date, FALSE, &ptemp[0]);
  	disp_clok(THEDATE);  
} 


/*
*		Determine the correct year and display it.
*/
	VOID
show_year()
{
	UWORD		date;
	BYTE		*ptemp;

	ptemp = clok_str[6];
	date = dos_gyear();
	date = (date - 1900) % 100;
	i_to_a(date, TRUE, &ptemp[0]);
	disp_clok(YEAR);       
}


/*
*		Selects or de-selects the clock value which is to be changed.
*/
	VOID
light_it(obj, state)
	WORD		obj;
{
	WORD		x,y,w,h;

	x = the_clok[ROOT].ob_x + the_clok[obj].ob_x;
	y = the_clok[ROOT].ob_y + the_clok[obj].ob_y;
	w = the_clok[ROOT].ob_width;
	h = the_clok[ROOT].ob_height;
	objc_change(ad_clok, obj, 0, x, y, w, h, state, TRUE);  
}


/*
*		Selcts the object which is going to be changed, and if 
*		another one of the objects is already selected it de-selecs
*		that object.
*/
	VOID
hi_light(obj)
	WORD		obj;
{
	WORD		x,y,w,h;
	WORD		ii;

	for (ii=0; ii < CLOK_OBS; ii++)
	{
	  if (the_clok[ii].ob_state == SELECTED)
 	  {
	    light_it(ii, NORMAL);
	    done_one = FALSE;
    	  }
	}
	light_it(obj, SELECTED);
}


/*
*		Takes the user's input and sets the hour to that value.
*		If the value is not a valid hour no change occurs.
*/

	VOID
set_hour(the_hour, ptemp)
	WORD		the_hour;
	BYTE		*ptemp;
{			    
	WORD		tmp_hour;	 
	WORD		no_eror;
	WORD		temp;

          tmp_hour = (((ptemp[0] - 48) * 10) + the_hour) ;
 	  no_eror = !( (tmp_hour < 1) || (tmp_hour > 12) );
	  if (tmp_hour == 12)
            tmp_hour = 0; 
	  if ( no_eror )
	  {
	    if (the_clok[SW_TIME].ob_spec == ALARMON)
	    {
			/* If al_hour > 11 then PM must be displayed, */
			/* convert to 0 -23 scale.		      */
	      if (al_hour > 11)
	        tmp_hour += 12;	
              al_hour = tmp_hour;
	    }	
	    else
	    {	
	      temp = dos_gtime();
	      temp >>= 8;
	      if (temp > 11)
	        tmp_hour += 12;	
              dos_shour(tmp_hour);
	    }	
	  }
	  return(no_eror);
}		



/*
*		Takes the user's input and sets the minute to that value.
*		If the value is not a valid minute no change occurs.
*/

	VOID
set_min(the_min, ptemp)
	WORD		the_min;
	BYTE		*ptemp;
{			    
	WORD		tmp_min;	 
	WORD		no_eror;

          tmp_min = ((ptemp[0] - 48) * 10) + the_min ;
 	  no_eror = !( (tmp_min < 0) || (tmp_min > 59) );
	  if ( no_eror )
	  {
	    if (the_clok[SW_TIME].ob_spec == ALARMON)
              al_min = tmp_min;
	    else
              dos_smin(tmp_min);
	  }
	  return(no_eror);
}

/*
*		Toggles between AM and PM.
*/

	VOID
set_ampm()
{
  	WORD		tmp_hour;
	BYTE		*qtemp;

	qtemp = clok_str[2];
	if (the_clok[SW_TIME].ob_spec == ALARMON)
	{
	  al_hour += (al_hour < 12) ? 12 : -12;
	}
	else
	{
          tmp_hour = (dos_gtime() >> 8);
	  tmp_hour += (qtemp[0] == 'a') ? 12 : -12;
	  dos_shour(tmp_hour);
	}
	show_ampm();
}	 



/*
*		Takes the user's input and sets the month to that value.
*		If the value is not a valid month no change occurs.
*/

	VOID
set_month(the_month, ptemp)
	WORD		the_month;
	BYTE		*ptemp;
{			    
	WORD		tmp_month;	 
	WORD		no_eror;

          tmp_month = ((ptemp[0] - 48) * 10) + the_month ;
 	  no_eror = dos_smonth(tmp_month);
	  return(no_eror);
}		



/*
*		Takes the user's input and sets the date to that value.
*		If the value is not a valid date no change occurs.
*/

	VOID
set_date(the_day, ptemp)
	WORD		the_day;
	BYTE		*ptemp;
{			    
	WORD		tmp_day;	 
	WORD		no_eror;

          tmp_day = ((ptemp[0] - 48) * 10) + the_day ;
 	  no_eror = dos_sdate(tmp_day);
	  return(no_eror);
}		



/*
*		Takes the user's input and sets the year to that value.
*		If the value is not a valid year no change occurs.
*/

	VOID
set_year(the_year, ptemp)
	WORD		the_year;
	BYTE		*ptemp;
{			    
	WORD		tmp_year;	 
	WORD		no_eror;

          tmp_year = ((ptemp[0] - 48) * 10) + the_year ;
 	  no_eror = dos_syear(tmp_year);
	  return(no_eror);
}		

/*
*		Determine which object to set, and set it.
*/
	WORD
set_it(last_inp, value)
	WORD		last_inp;
	WORD		value;
{
	WORD		ret;
	WORD		num;
	BYTE		*ptemp;

	switch(last_inp)
	{
	    case THEDATE:	num = 5;	break;
	    case YEAR:		num = 6;	break;
	    case MONTH:		num = 4;	break;
	    case HOUR:		num = 0;	break;
	    case MINUTE:	num = 1;	break;
	}
	ptemp = clok_str[num];
				/* After one digit has been typed */
				/* done one is set to true, and   */
				/* you wait for the second digit. */
	if (!done_one)
        {			       	
	  done_one = TRUE;
	  ptemp[0] = value + 48;	
	  ret = 0;
  	}
	else
	{
	  done_one = FALSE;
	  switch(last_inp)
	  {
	    case THEDATE:
		ret = set_date(value, ptemp);	     
		break;
	    case YEAR:
		ret = set_year(value, ptemp);
		break;
	    case MONTH:
		ret = set_month(value, ptemp);			
		break;
	    case HOUR:
		ret = set_hour(value, ptemp);
		break;
	    case MINUTE:
		ret = set_min(value, ptemp);
		break;
	  }
	  if ( ret )
	    ret = 1;
	  else
	    ret = -1;
	}
	return(ret);
}

/*
*		Show the new value of the object which was changed.
*/

	WORD
show_it(last_inp)
	WORD		last_inp;
{

	switch(last_inp)
	{
	  case THEDATE:
		show_date();	     
		break;
	  case YEAR:
		show_year();
		break;
	  case MONTH:
		show_month();			
		break;
	  case HOUR:
		show_hour();
		break;
	  case MINUTE:
		show_min();
		break;
	}
}


/*
*		Processes all of the changes to the clock.
*/
    	WORD
hndl_clok(obj)
	WORD	obj;
{
	BYTE		xdisp,ydisp;
	WORD		ret, value;

	value = 0;
	switch (obj)
	{
	  case THECLOCK:
		break;
	  case THEALARM:
				/* If the alarm icon is chosen, toggle  */
				/* a selected and a normal state.	*/
				/* If the current system has more than	*/
				/* one color the color is toggled be-	*/
				/* red and black.			*/
	        if (color != 1)
		  {
		   if (the_clok[THEALARM].ob_spec == 0x0b001270L)
		     {
		      al_set = FALSE;	
	              the_clok[THEALARM].ob_spec = 0x0b001170L;
		     }
	            else 
		      {
		       al_set = TRUE;	
		       the_clok[THEALARM].ob_spec = 0x0b001270L;
		      }	
		   }
		if (color == 1)
		  {
		   if (!al_set)
		     {
		      al_set = TRUE;
		      the_clok[THEALARM].ob_state = NORMAL;   
		     }
		    else 
		      {
		       al_set = FALSE;
		       the_clok[THEALARM].ob_state = DISABLED;	
		      }	
		   }  
		disp_clok(THEALARM);
		break;
	  case SW_TIME:
				/* If the time/alarm flag is chosen the */
				/* clock will toggle between displaying	*/
				/* the time and the alarm.		*/

		if (the_clok[SW_TIME].ob_spec == TIMEON)
		  the_clok[SW_TIME].ob_spec = ALARMON;
		else
		  the_clok[SW_TIME].ob_spec = TIMEON;
		disp_clok(SW_TIME);
		show_hour();
		show_min();
		show_ampm();
		break;			 
	  case AM_PM:
		set_ampm();
		break;
	  case YEAR:
	  case MONTH:
	  case THEDATE:
	  case HOUR:	    
	  case MINUTE:	  
				/* Highlight the object selected and	*/
				/* for the numeric input.		*/
		hi_light(obj);
		last_inp = obj;
		break;	    
	  case '9':
		value++;
	  case '8':
		value++;
	  case '7':
		value++;
	  case '6':
	  	value++;
	  case '5':
		value++;
	  case '4':
		value++;
	  case '3':
		value++;
	  case '2':
		value++;
	  case '1':
		value++;
	  case '0':
				/* Set the clock object specified by 	*/
				/* last_inp with the value entered.	*/
		ret = set_it(last_inp, value);
		if (ret != 0)
		{
		  light_it(last_inp, NORMAL);
				/* If no error occured show the new	*/
				/* else beep.				*/
		  if (ret == 1)
		    show_it(last_inp);
		  if (ret == -1)
		    beep();
		}		
		break;		
	 }
	return(FALSE);
}
				
/*
*		Determine wether the alarm time is the same as the
*		system time and if so ring the bell.
*/

	VOID
bell()
{

	UWORD		time_hour,time_min;
	WORD		jj;  

	time_hour = dos_gtime();
	time_min = (time_hour & 0x00ff);
	time_hour >>= 8;		   
	if (time_min == al_min) 
	  if (time_hour == al_hour)  
	    for (jj = 0;jj <= 4;jj++)
	      beep();   
}
  
/*
*		Determine how many milli-seconds until the next minute.
*		and return that value.
*/

	LONG
set_timer()
{
	LONG		time_left;

	time_left = dos_gsec();
	time_left >>= 8;
	time_left = (60 - (time_left + 0)) * 1000;
	return(time_left);
}	  			

/*
*		Check to see if the time is currently being displayed.
*		if so display the new time.If the alarm is set check to
*		see if it is time to ring the alarm.
*/

	VOID
change_time()
{
            if (wh_clok)
              {
		if (the_clok[SW_TIME].ob_spec == TIMEON)
		  {
		   evnt_timer(500L);
		   show_hour();
		   show_min();
		   show_ampm();
		   show_month();
		   show_date();
		   show_year();
		  }				       
 	      }                           
	      if (al_set)
		bell();  
}
  
/************************************************************************/
/* m a i n								*/
/************************************************************************/
main()
{
	LONG		tree;
	WORD		ev_which;
	WORD		ret, done, ii, junk, spec[4];
	WORD		mx, my, mb, ks, kret, bret;
	WORD		curr_ob;
	WORD		x, y, w, h;

	ret = appl_init();
	color = ret;
	gl_handle = graf_handle(&gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
						/* register as desk	*/
						/*   accessory		*/
	gl_itcalc = menu_register(gl_apid, ADDR("  Calculator") );
	gl_itclok = menu_register(gl_apid, ADDR("  Clock"));
						/* init. message address*/
	ad_rmsg = ADDR(&gl_rmsg[0]);
						/* get desktop size	*/
	wind_get(0, WF_WXYWH, &gl_xdesk, &gl_ydesk, &gl_wdesk, &gl_hdesk);
						/* initialize mouse	*/
	graf_mouse(0, 0x0L);
						/* initialize calc	*/		  
	gl_disp = the_str[0];
	ad_calc = ini_calc();
    	ad_clok = ini_clok();

						/* starting spot is	*/
						/*   centered on desk	*/
	   the_calc[ROOT].ob_y = (gl_hdesk - the_calc[ROOT].ob_height) / 2;
	   the_calc[ROOT].ob_x = (gl_wdesk - the_calc[ROOT].ob_width) / 2;
						/* starting spot is the	*/
						/* upper left corner	*/
	   the_clok[ROOT].ob_y = (the_clok[ROOT].ob_height + 2); 
	   the_clok[ROOT].ob_x = 6;

						/* get ready for main	*/
						/*   loop		*/  
	gl_flags = MU_BUTTON | MU_MESAG | MU_KEYBD | MU_TIMER;
	gl_button = 0x01;

	done = FALSE;
						/* Clear display	*/
	for(ii = 0; ii < DISP_LEN; inp_str[ii++] = ' ');
	inp_str[DISP_LEN] = NULL;
	inp_idx = 0;
	inp_str[inp_idx] = '0';
	al_min = 0;
	al_hour = 0;
	al_set = FALSE;
	add_on = 64;
	last_op = NOP;
	last_key = NOP;
	stack_pt = 19;
	dec_pt1 = 64;
	dec_pt2 = 64;
	not_zero = FALSE;
	last_inp = NUM;
	wh_calc = 0;
	wh_clok = 0;
	gl_wtop = 0;

						/* begin main loop	*/
	while (!done)
	{
						/* wait for mouse 	*/
						/*   button to go down	*/
	  ev_which = evnt_multi(gl_flags, 0x01, 0xff, gl_button,
				0, 0, 0, 0, 0,
				0, 0, 0, 0, 0,
				ad_rmsg,set_timer(),
				&mx, &my, &mb, &ks, &kret, &bret);

	  wind_update(TRUE);
	  wind_get(0, WF_TOP, &gl_wtop, &spec[1], &spec[2], &spec[3]);
	  if (!gl_wtop)
	    gl_wtop = -1;
							/* handle timer		*/
	  if (ev_which & MU_TIMER)
	    change_time();	
						/* handle message	*/
	  if (ev_which & MU_MESAG)
	    hndl_mesag();
	  					/* handle keyboard	*/
	   if (ev_which & MU_KEYBD)
						/* if clock on top	*/
	     if (gl_wtop == wh_clok)
	       {	
	        curr_ob = (kret & 0x00ff);
	        done = hndl_clok(curr_ob);
	       }
						/* if calculator on top	*/
	     else  	
              {
		if (set_timer() > 58000)
		  change_time();
						/* find key entered	*/

  	       	curr_ob = find_chr( (kret & 0x00ff));	
	       	last_key = curr_ob;
	        if ((curr_ob) && (curr_ob != THE_E) && (curr_ob != THE_M))
	          {
		   tree = ad_calc;
		   x = the_calc[ROOT].ob_x + the_calc[curr_ob].ob_x;
		   y = the_calc[ROOT].ob_y + the_calc[curr_ob].ob_y;
		   w = the_calc[ROOT].ob_width;
		   h = the_calc[ROOT].ob_height;

					/* highlight the selected key */

		   objc_change(ad_calc, curr_ob, 0, x, y, w, h, SELECTED, TRUE);
		   evnt_timer(0L);
		   objc_change(ad_calc, curr_ob, 0, x, y, w, h, NORMAL, TRUE);
		   done = hndl_calc(curr_ob);	
	          }
              }                	        
					/* handle mouse		*/  
	  if (ev_which & MU_BUTTON)
	  {
	    if (gl_button == 0x01)
	      if (gl_wtop == wh_clok)
	        {				/* find out what the	*/
						/*   mouse is over	*/
	          graf_mkstate(&mx, &my, &junk, &junk);
	          curr_ob = objc_find(ad_clok, ROOT, MAX_DEPTH, mx, my);
	          if ( (curr_ob != NIL) && (curr_ob != THECLOCK) &&
			(curr_ob != TOPBOX) && (curr_ob != LOWBOX))
	            {
	             if ( graf_watchbox(ad_clok, curr_ob, SELECTED, NORMAL) )
		       {
		        tree = ad_clok; 
		        x = the_clok[ROOT].ob_x + the_clok[curr_ob].ob_x;
		        y = the_clok[ROOT].ob_y + the_clok[curr_ob].ob_y;
		        w = the_clok[ROOT].ob_width;
		        h = the_clok[ROOT].ob_height;
		        objc_change(ad_clok, curr_ob, 0, x, y, w, h, NORMAL, TRUE);
		        done = hndl_clok(curr_ob);  
		       }     /* if */
	            } /* if */
	        }  /* if gl_button */
	    if (gl_wtop == wh_calc)	
	        {				/* find out what the	*/
						/*   mouse is over	*/
		  if (set_timer() > 58000)
		    change_time();
	          graf_mkstate(&mx, &my, &junk, &junk);
	          curr_ob = objc_find(ad_calc, ROOT, MAX_DEPTH, mx, my);
	          if ( (curr_ob != NIL) && 
		     (curr_ob != THECALC) &&
		     (curr_ob != THEDISP) )
	           {
		    if ( graf_watchbox(ad_calc, curr_ob, SELECTED, NORMAL) )
	              {
		       tree = ad_calc; 
		       x = the_calc[ROOT].ob_x + the_calc[curr_ob].ob_x;
		       y = the_calc[ROOT].ob_y + the_calc[curr_ob].ob_y;
		       w = the_calc[ROOT].ob_width;
		       h = the_calc[ROOT].ob_height;
		       objc_change(ad_calc, curr_ob, 0, x, y, w, h, NORMAL, TRUE);
		       done = hndl_calc(curr_ob);  
	              }     /* if */
	            } /* if */
	         }  /* if gl_button */
	 }
	  wind_get(0, WF_TOP, &gl_wtop, &spec[1], &spec[2], &spec[3]);
	  if (!gl_wtop)
	    gl_wtop = -1;
	 wind_update(FALSE);
	} /* while */						   

						/* since we're a desk	*/
						/*   accessory we should*/
						/*   never terminate	*/
} /* main */