;
;
;** LABEL REFERENCE LIST PRINT OUT TO CONSOLE **
;THIS ROUTINE IS ESPECIAL FOR AX68K.COM .
;
;
;
;SYMBOL DEFINITION LIBRARY
;
	DEL3	EQU	0
	DEL4	EQU	';'
	CR	EQU	0DH
	SPACE	EQU	20H
	TAB	EQU	9
	LF	EQU	0AH
	EOF	EQU	1AH
;
;TERMINATER
;
TERM1	EQU	CR
TERM2	EQU	0FFH ;END
TERM3	EQU	0FEH ;INDEX
;
;DATA BUFFER AREA DEFINITION
;
CBASE	EQU	6	;CP/M TPA END ADDR.POINTER
;
;FDOS USE
;
;SYSTEM CALL COMMANDS
;
REBOOT	EQU	0	;CP/M RE-BOOT
BDOS	EQU	5
FCB	EQU	5CH	;FILE CONTROL BLOCK ADDR.
SETDMA	EQU	26
OPEN	EQU	15
READS	EQU	20	;SEQUENTIAL READ
WRITES	EQU	21	;SEQUENTIAL WRITE
CLOSE	EQU	16
MAKE	EQU	22
DELETE	EQU	19
LIST	EQU	5
CONOUT	EQU	2
;
;
;BUFFER AREA DEFINITION
;
LABTOP	EQU	3D2FH	;THIS ADDRESS IS PECULIAR TO THIS AX68K.COM
;IF REWRITED THE AX68K,THEN REWRITE THIS ADDRESS.
;(REFER SLIST.DOC)
;
;
;MAIN
;
	ORG	100H
;
LABELP:	LXI	H,BEGMES
	CALL	MESSAGE
	LXI	H,LINBUF	;LINE BUFFER
	MVI	B,0	;HASH BLOCK NUMBER
LABELP1: CALL	BLKPRN	;BLOCK PRINT OUT
	INR	B
	MOV	A,B
	CPI	32
	JC	LABELP1
	LXI	H,ENDMES
	CALL	MESSAGE
	JMP	REBOOT
;
;
;SR. BLKPRN
;BLOCK (B) PRINT OUT
;
;
BLKPRN:	PUSH	B
	XRA	A
	STA	PCOUNT	;PRINT COUNT RESET
	CALL	PCRLF	;CR/LF PRINT
	POP	B
	PUSH	B
	MOV	A,B
	ADD	A
	MOV	B,A
	MVI	C,0	;BC=(HASH NUMBER)*512
	LXI	H,LABTOP
	DAD	B	;HL=BLOCK TOP ADDRESS
	XCHG
BLKPR0:	LDAX	D
	CPI	TERM2	;END MARK ?
	JNZ	BLKPR1	;NO
	POP	B
	RET
;
BLKPR1:	CPI	TERM3	;INDEX ?
	JNZ	BLKPR2
	INX	D
	XCHG
;GET INDEXED LINK ADDRESS
	MOV	A,M
	INX	H
	MOV	H,M
	MOV	L,A	;NOW, HL=INDEXED ADDRESS
	XCHG
	JMP	BLKPR0
;
;PRINT LABEL 1 WORD
;
BLKPR2:	CALL	LABP	;LABEL PRINT
	LDA	PCOUNT	;PRINT COUNTS
	CPI	30
	JC	BLKPR0
	CALL	PCRLF	;PRINT CR/LF
	XRA	A
	STA	PCOUNT	;RESET PCOUNT
	JMP	BLKPR0
;
;
;
;LABEL WORD PRINT
;
;
LABP:	LXI	H,LINBUF ;LINE BUFFER
	LDA	PCOUNT
	MOV	B,A
LABP1:	LDAX	D
	INX	D
	ORA	A	;DEL3 ?
	JZ	LABP3
	MOV	M,A
	INX	H
	INR	B
	JMP	LABP1
;
LABP3:	MOV	A,B
	ANI	0F8H
	ADI	8	;TAB COUNTS COMPENSATION
	ADI	16	;NEXT DATA COUNTS
	STA	PCOUNT
	MVI	M,TAB
	INX	H
	CALL	QHAT	;NEXT DATA PART TRANSLATE TO ASCII
	MVI	M,SPACE
	INX	H
	CALL	QHAT
	MVI	M,TAB
	INX	H
	MVI	M,0
;
	LXI	H,LINBUF
	CALL	MESSAGE
	RET
;
;2 BYTES DATA TO ASCII 4 CHAR.
;
QHAT:	CALL	DHAT2	;1 BYTE TRANS.
	CALL	DHAT2
	RET
;
;
;PRINT MESSAGE TO CONSOLE
;
;FROM (HL)~ UNTIL HIT 0H
;BC,DE CONSERVED
;
MESSAGE:	PUSH	D
	PUSH	B
MSG1:	MOV	A,M
	ORA	A
	JZ	MSG2
	INX	H
	PUSH	H
	MOV	E,A
	MVI	C,CONOUT
	CALL	BDOS
	POP	H
	JMP	MSG1
;
MSG2:	POP	B
	POP	D
	RET
;
;
;CR/LF
;
PCRLF:	PUSH	H
	PUSH	D
	MVI	E,CR
	MVI	C,CONOUT
	CALL	BDOS
	MVI	E,LF
	MVI	C,CONOUT
	CALL	BDOS
	POP	D
	POP	H
	RET
;
;
;DHAT HEX TO ASCII TRANS.(DOUBLE)
;
DHAT2:	LDAX	D
	INX	D
DHAT:	PUSH	A
	RAR!RAR!RAR!RAR
	CALL	HAT
	POP	A
HAT:	ANI	0FH
	CPI	0AH
	JC	HAT1
	ADI	7
HAT1:	ADI	30H
	MOV	M,A
	INX	H
	RET
;
;MEESAGES
;
BEGMES:	DB 'SYMBOL TABLE LIST',CR,LF,CR,LF,0
;
ENDMES:	DB CR,LF,CR,LF,CR,LF
	DB 'SYMBOL REFERENCE END.',CR,LF,0
;
;
;PRINT COUNTS
;
PCOUNT:	DS	1
;
;LINE BUFFER
;
LINBUF:	DS	256
;
END
