	PAGE	60,132
	TITLE	BACKUP FOR A1 MS-DOS VER 2.0
;************************************************
;*						*
;*	BACKUP COMMAND UTILITY			*
;*						*
;*		BACK UP ONE OR MORE FILES	*
;*		FROM HARD DISK(5"HD) TO		*
;*		DISKETTES(5"2D/5"2DD(8/9 SECTOR	*
;*		TRACK))				*
;*						*
;************************************************
;
; JUN./15/1984	Final version for the first user release on APC III.
;
CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,SS:CODE,ES:CODE
;****************
;   CONSTANT	*
;****************
;FUNCTION CALL
;
CON_OUT		EQU  02H		; CONSOLE OUTPUT
CON_CHK		EQU  0C08H		; FLUSH BUFFER,READ KEYBOARD
GET_DEF		EQU  19H		; GET DEFAULT DRIVE NO
SET_DTA         EQU  1AH		; SET DTA
GET_FREE	EQU  36H		; GET DISK FREE SPACE
MK_DIR		EQU  39H		; CREATE SUB_DIRECTORY
RM_DIR		EQU  3AH		; REMOVE DIRECTORY
CH_DIR		EQU  3BH		; CHANGE THE CURRENT DIRECTORY
FL_CREAT	EQU  3CH		; CREATE FILE
FL_OPEN		EQU  3DH		; OPEN A FILE
FL_CLOSE 	EQU  3EH		; CLOSE A FILE HANDLE
FL_READ		EQU  3FH		; READ FROM FILE/DEVICE
FL_WRITE	EQU  40H		; WRITE TO A FILE/DEVICE
DEL_FILE	EQU  41H		; DELETE FILE           
CH_MODE		EQU  43H		; CHANGE ATTRIBUTE
GET_CUR		EQU  47H		; RETURN TEXT OF CURRENT DIRECTORY
MEM_ALLOC	EQU  48H		; ALLOCATE MEMORY
SETBLOCK	EQU  4AH		; MODIFY ALLOCATED MEMORY BLOCKS
PROC_TERM	EQU  4CH		; PROCESS TERMINATE
SEARCH_FIRST	EQU  4EH		; FIND MATCH FILE
SEARCH_NEXT	EQU  4FH		; STEP THROUGH A DIRECTORY MATCHING FILES
FILE_TIME_DATE	EQU  57H		; GET/SET DATE/ TIME OF FILE
;
BDOS		EQU  21H		; BDOS CALL
;
	BEGIN	EQU  $
	ORG	     100H
START:
	JMP	     BACKUP_EXECUTE
;****************
;*   DATA AREA	*
;****************
;
DEF_DRV_NO	DB   0			; DEFAULT DRIVE NO
ALL_BU_FLAG	DB   0			; ALL FILE BACKUP FLAG
					;   01H = FILE NAME SPECIFIED
					;   00H = FILE NAME NO SPECIFIED
DEST_FULL_FLAG	DB   0			; DESTINATION DISK FULL CHECK FLAG
					;   01H = DISK FULL
					;   00H = DISK NO FULL
SOURCE		DB   0			; SOURCE DRIVE NO
DEST		DB   0			; DESTINATION DRIVE NO
WTLNG		DW   0			; WRITE LENGTH
REMAIN_LNG	DW   0			; REMAIN LNG
MULTI_VOL_NO	DW   0			; MULTI VOLUME NO
MULTI_VOL_FL	DB   0			; MULTI VOLUME FLAG
					;   00H = SINGLE VOLUME
					;   01H = MULTI VOLUME AND NOT END VOLUME
					;   FFH = END VOLUME OF MULTI
MULTI_FILE_NO	DB   0			; MULTI VOLUME NO OF FILE
DIRECTORY_COUNT	DW   0			; DIRECTORY COUNT
ROOT_COUNT	DB   0			; ROOT COUNT
FILE_COPY_FLAG	DB   0			; FILE COPY FLAG
					;   01H = 1 OR MORE FILE COPIED
					;   00H = NO FILE COPIED
DIR_COPY_FLAG	DB   0			; DIR COPY FLAG
					;   01H = 1 OR MORE DIRECTORY MAKED
					;   00H = NO DIRECTORY MAKED
;
COPY_START_FLAG DB    0			; COPY START FLAG
					;   01H = COPY ALREADY START
					;   00H = COPY NOT START
M_AREA		DB   0			; MOUNTH SAVE AREA
D_AREA		DB   0			; DAY SAVE AREA
Y_AREA		DW   0			; YEAR SAVE AREA
;
BACKUPID_PATH	DB   '@:\BACKUPID.@@@',0 ; BACKUPID.@@@ FILE PATH NAME
ENTRY_CHECK_PATH DB  '@:\BACKUPID.$$$',0 ;ENTRY FULL CHECK PATH NAME
S_WILD_FILE	DB   '@:*.*',0		; SOURCE DRIVE WILD PATH NAME
D_WILD_FILE	DB   '@:*.*',0		; DESTINATION DRIVE WILD PATH NAME
SOURCE_PAIR	DB   '@:..',0		; SOURCE DRIVE PARENT DIR BACK PATH NAME
DEST_PAIR	DB   '@:..',0		; DESTINATION DRIVE PARENT DIR BACK PATH NAME
FILE_WILD	DB   '\*.*',0		; FILE WILD CARD 
SOURCE_PATH	DB   '@:',128 DUP (0)	; SOURCE DRIVE PATH NAME AREA
SOURCE_IN_PATH	DB   '@:',128 DUP (0)	; SOURCE DRIVE PATH NAME ORIGINAL AREA
SOURCE_DIR_PATH	DB   '@:',128 DUP (0)	; SOURCE DRIVE DIRECTORY PATH NAME AREA
SOURCE_FILE_PATH DB  '@:',14 DUP (0)	; SOURCE DRIVE FILE PATH NAME AREA
DEST_PATH	DB   '@:',128 DUP(0)	; DESTINATION DRIVE PATH NAME AREA
DEST_DIR_PATH	DB   '@:',128 DUP (0)	; DESTINATION DRIVE DIRECTORY PATH NAME AREA
DIR_MAKE_PATH	DB   '@:',128 DUP (0)	; DIRECTORY MAKE PATH NAME 
DEST_ROOT_PATH	DB   '@:\',0		; DESTINATION DRIVE ROOT PATH NAME
;
BACKUPID_HAND	DW   0			; BACKUPID.@@@ FILE HANDLE
SOURCE_HAND	DW   0			; SOURCE FILE HANDLE
DEST_HAND	DW   0			; DESTINATION HANDLE
BACKUPID_BUFF	DB   512 DUP(0)		; BACKUPID.@@@ FILE READ/WRITE BUFFER
FILE_HEADER	DB   0,'@:',125 DUP (0)	; FILE HEADER WRITE BUFFER
;
FIND_BUF_RES	DB   21 DUP(?)		; RESERVED
FIND_BUF_ATTR	DB   0			; ATTRIBUTE FOUND
FIND_BUF_TIME	DW   0			; TIME
FIND_BUF_DATE	DW   0			; DATE
FIND_BUF_SIZE_L	DW   0			; LOW(SIZE)
FIND_BUF_SIZE_H	DW   0			; HIGH(SIZE)
FIND_BUF_PNAME	DB   13 DUP(?)		; PACKED NAME
;
BACKUP_BUFFER	DW    0			; BACKUP BUFFER POINTER
CUR_FILE_NAME	DB   14 DUP (0)		; CURRENT FILE NAME SAVE AREA
END_FILE_NAME	DB   14 DUP (0)		; END COPIED FILE NAME SAVE AREA
PATH_DISP_AREA	DB   128 DUP (0)	; PATH NAME DISPLAY AREA
FILE_DISP_AREA	DB   13 DUP (0),0DH,0AH,0 ; FILE NAME DISPLAY AREA
INCLUDE	B:BACK_MSG.INC

		DB   128 DUP(?)		; STACK AREA
STACKA		EQU  $
;
include	b:back_prs.inc

;
;--------------- BACKUP ? process: display BACKUP command summary
;
quest_exit:
	mov	dx,offset backup_msg
	mov	ah,09h			; display string func.
	int	bdos

	mov	al,0			; normal end
	jmp	backup_end

;
;-------------- Ctrl+Break interrupt operation
;
CTRL_BREAK:
	MOV	AL,3			; terminate code 3
	JMP	BACKUP_END

;
;--------------- parameter or option syntax error exit
;
PARA_ERROR:
	MOV	SI,OFFSET ERRMSG_00
	CALL	PMSG			; ERROR MESSAGE OUT
	MOV	AL,4			; terminate code 4
	JMP	BACKUP_END	
	PAGE
;
;--------------- BACKUP command main process
;
BACKUP_EXECUTE:
	MOV	SP,OFFSET STACKA	; reset stack pointer

	MOV	DX,OFFSET CTRL_BREAK
	MOV	AL,23H			; INT 23H ctrl+c break vector 
	MOV	AH,25H			; SET VECTOR
	INT	BDOS
;
	call	ps			; parse BACKUP command line
	jc	para_error		; 
	jnz	quest_exit		; ? option is specified

	MOV	ALL_BU_FLAG,01H		; backup all files on
	cmp	filename,0		; specified flie name ?
	jnz	all_bu_off		; filename is specified
	cmp	ext,0			; specified file ext ?
	jz	skip_bu_off		; file ext is not specified
all_bu_off:
	MOV	ALL_BU_FLAG,00H		; backup specified file only
skip_bu_off:
	mov	al,source_drive		; 
	sub	al,"A"			; drive char. - 41h
	mov	source,al
	cmp	source_drive,0		; specified source drive ?
	jnz	skip_default		; source drive is specified
	MOV	AH,GET_DEF		; get default drive number
	INT	BDOS			; DEFAULT DRIVE NO GET
	MOV	DEF_DRV_NO,AL		; DEFAULT DRIVE NO SET
	MOV	SOURCE,AL		; SET SOURCE DRIVE NO
skip_default:
	mov	al,destination_drive
	sub	al,"A"			; drive char. - 41h
	MOV	DEST,AL			; SET DESTINATION DRIVE NO
	cmp	al,source		; check different drive from destination
	JE	PARA_ERROR		;	
	cmp	option_d,0		; specified /d option ?
	jz	skip_check_date		; /d is not specified
	cmp	option_d_str,0		; specified date string ?
	jz	para_error
      	call	check_date		; check date format
        jc	para_error

skip_check_date:
	mov	di,offset source_in_path+2
	cmp	path,0			; specified path ?
	jz	check_file		; path is not specified
	mov	si,offset path
set_source_path:
	lodsb				; mov al,ptr[si] inc si
	cmp	al,0			; string end ?
	jz	check_file		; end of path string
	stosb				; mov ptr[di],al inc di
	jmp short set_source_path

check_file:
	cmp	filename,0		; specified file name ?
	jz	check_ext		; file name is not specified
	mov	si,offset filename	; append file name
append_file:
	lodsb
	cmp	al,0
	jz	check_ext		; end of file string
	stosb
	jmp	short append_file

check_ext:
	cmp	ext,0			; specified file extention
	jz	skip_set_ext		; extentio is not specified
	mov	si,offset ext		; append file extent
	mov	byte ptr[di],"."	; append "."
	inc	di
append_ext:
	lodsb
	cmp	al,0			; end of file extention
	jz	skip_set_ext
	stosb
	jmp	short append_ext

skip_set_ext:
	mov	di,offset source_path
	mov	si,offset source_in_path
copy_path:
	lodsb
	cmp	al,0			; end of string ?
	jz	exit_path_copy
	stosb
	jmp	short copy_path

exit_path_copy:
;
;--------------- initialize 
;
	MOV	WORD PTR MULTI_VOL_NO,0
	MOV	BYTE PTR MULTI_VOL_FL,0
	MOV	FILE_COPY_FLAG,0	; FILE COPY FLAG INIT
	MOV	DIR_COPY_FLAG,0		; DIR COPY FLAG INIT
;
	MOV	AL,DEST
	ADD	AL,'A'
	MOV	D_WILD_FILE,AL		; SET DESTINATION DRIVE NAME
	MOV	DEST_PATH,AL		;
	MOV	BACKUPID_PATH,AL	;
	MOV	DEST_DIR_PATH,AL
	MOV	DEST_PAIR,AL		;
	MOV	DIR_MAKE_PATH,AL
	MOV	DEST_ROOT_PATH,AL	;
	MOV	ENTRY_CHECK_PATH,AL	;
;
	MOV	AL,SOURCE		;
	ADD	AL,'A'			;
	MOV	SOURCE_PATH,AL		; SET SOURCE DRIVE NAME
	MOV	SOURCE_IN_PATH,AL
	MOV	S_WILD_FILE,AL		;
	MOV	FILE_HEADER+1,AL
	MOV	SOURCE_PAIR,AL		;
	MOV	SOURCE_DIR_PATH,AL
	MOV	SOURCE_FILE_PATH,AL

	MOV	SI,OFFSET FILE_HEADER+3
	MOV	AH,GET_CUR
	MOV	DL,SOURCE
	INC	DL
	INT	BDOS			; GET current dir on source
;
;***	MEMORY ALOCATE	***
;
	MOV	BX,OFFSET ENDLOC	;
	MOV	CL,4			;
	SHR	BX,CL			;
	MOV	AH,SETBLOCK		; SET BLOCK
	INT	BDOS			;
;
	MOV	AH,MEM_ALLOC		;
	MOV	BX,0FFFFH		;
	INT	BDOS			; MEMORY ALLOCATE
	JNC	BACKUP_START
	MOV	AH,MEM_ALLOC		;
	INT	BDOS			; allocate memory avairable sixe in bx
BACKUP_START:
	MOV	BACKUP_BUFFER,AX	; save allocated memory segment

	CALL	BACKUP			; EXEC BACKUP

;
;--------------- BACKUP command exit process
;
BACKUP_END:
	PUSH	AX			;
	MOV	DI,OFFSET FILE_HEADER+1
	CALL	SKIP_ZERO
	CMP	DI,OFFSET FILE_HEADER+3	; CHECK ROOT DIRECTORY
	JNZ	BACKUP_END_00
	MOV	BYTE PTR [DI],'\'	; SET "\"
BACKUP_END_00:
	MOV	DX,OFFSET FILE_HEADER+1
	MOV	AH,CH_DIR
	INT	BDOS			; RESET CURRENT DIRECTORY
	POP	AX
;
	MOV	AH,PROC_TERM		; AL = terminate code
	INT	BDOS			; return to MS-DOS
	page
;********************************
;* 	BACKUP EXECUTE		*
;********************************
BACKUP:
	CMP	OPTION_A,0		; specified /a option ?
	JNZ	BACKUP01		; skip prompt message
;
;--------------- requir diskette and delete all files and directories
;
BACKUP00:
	CALL	PROMPT			; PROMPT MESSAGE
	MOV	AL,DEST			; SET DESTINATION DRIVE NO ON AL
	CALL	FILE_DELETE		; delete all files on the diskette
	JC	BACKUP00		; FILE DELETE ERROR
;
	CALL	CR_BACKUPID		; create BACKUPID.@@@ file
	JNC	BACKUP02		; go to display strat message
	MOV	SI,OFFSET ERRMSG_50
	JMP	BACKUP_ERR		; error exit
;
;--------------- CHECK BACKUPID.@@@ FILE FOR /A OPTION
;
BACKUP01:
	MOV	AH,FL_OPEN		;
	MOV	AL,0			; READ OPEN
	MOV	DX,OFFSET BACKUPID_PATH
	INT	BDOS			; BACKUPID.@@@ FILE OPEN
	JNC	BACKUP010		; OK
	MOV	SI,OFFSET ERRMSG_10
	JMP	BACKUP_ERR		; ERROR EXIT

BACKUP010:
	MOV	BX,AX			; SET HANDLE
	PUSH	AX			;
	MOV	AH,FL_READ		;
	MOV	DX,OFFSET BACKUPID_BUFF
	MOV	CX,512			;
	INT	BDOS			; BACKUPID.@@@ READ
	POP	AX			;
	jc	BACKUP012;		; error

	MOV	BX,AX			;
	MOV	AH,FL_CLOSE
	INT	BDOS			; close BACKUPID.@@@ flie
	JNC	BACKUP014		; OK
BACKUP012:
	MOV	SI,OFFSET ERRMSG_50
	JMP	BACKUP_ERR		; error exit

;
;--------------- initial set for /a option
;
BACKUP014:
	MOV	AL,BACKUPID_BUFF
	MOV	MULTI_VOL_FL,AL		; SET MULTI VOLUME FLAG
	MOV	AX,WORD PTR BACKUPID_BUFF+1
	MOV	MULTI_VOL_NO,AX		;
	MOV	SI,OFFSET MSG_12
	CALL	BINASCII		; SET VOLUME NO
;
	CMP	BACKUPID_BUFF,01H	; MULTI VOLEME END OR SINGLE ?
	JNZ	BACKUP02 		; OK. go to backup start message
	MOV	SI,OFFSET ERRMSG_20
	JMP	BACKUP_ERR		; error exit
;
;
;--------------- START MESSAGE OUT
;
BACKUP02:
	MOV	SI,OFFSET MSG_10
	CALL	PMSG
;
;****	SOURCE PATH SET	****
;
	MOV	AL,SOURCE_PATH+2
	CMP	AL,'\'			; CHECK ROOT PATH
	JZ 	BACKUP09		; skip appending root path
	MOV	SOURCE_PATH+2,'\'
	MOV	AH,GET_CUR		;
	MOV	SI,OFFSET SOURCE_PATH+3
	MOV	DL,SOURCE		;
	INC	DL			;
	INT	BDOS			; GET CURRENT dir on source
	MOV	DI,OFFSET SOURCE_PATH
	CALL	SKIP_ZERO		; SKIP UNTIL ZERO
	CMP	DI,OFFSET SOURCE_PATH+3
	JZ 	BACKUP06		;
	MOV	BYTE PTR [DI],'\'	; append path delimiter
	INC	DI			;
BACKUP06:
	CMP	ALL_BU_FLAG,0		;
	JE	BACKUP08		; skip appending wild card
	MOV	SI,OFFSET FILE_WILD+1
	MOV	CX,4
	REP	MOVSB			; SET '*.*'
	JMP	SHORT BACKUP10		;
BACKUP08:
	MOV	SI,OFFSET SOURCE_IN_PATH+2
	CALL	TRANS_ASCIZ
	JMP	SHORT BACKUP10
BACKUP09:
	CMP	ALL_BU_FLAG,0
	JE	BACKUP10		; skip appending wild card
	MOV	DI,OFFSET SOURCE_PATH+2
	CALL	SKIP_ZERO		;
	MOV	SI,OFFSET FILE_WILD+1
	MOV	CX,4			;
	REP	MOVSB			;
BACKUP10:
;
;--------------- check last string of first parametre
;
	MOV	AH,SET_DTA		;
	MOV	DX,OFFSET FIND_BUF_RES
	INT	BDOS			; set DTA to FIND_BUF_RES

	MOV	AH,SEARCH_FIRST		;
	MOV	CX,0010H		; file attributes D
	MOV	DX,OFFSET SOURCE_PATH
	INT	BDOS			; DIRECTORY ENTRY SEARCH
	JC 	BACKUP15 		; found entry except sub-dir
	TEST	FIND_BUF_ATTR,10H	;
	JZ	BACKUP15		;
	CMP	ALL_BU_FLAG,0		; PATH NOT INPUT
	JNZ	BACKUP15		;
;
;--------------- last string of first parameter is path name
;
	MOV	DI,OFFSET SOURCE_PATH
	CALL	SKIP_ZERO		; ZERO SKIP
	MOV	SI,OFFSET FILE_WILD
	MOV	CX,4			;
	REP	MOVSB			; append wild card
;
;--------------- make dir and change dir on destination
;
BACKUP15:
	MOV	SI,OFFSET SOURCE_PATH+2
	MOV	DI,OFFSET DEST_DIR_PATH+2
	CALL	PATH_DIR_CHECK
	MOV	SI,OFFSET DEST_DIR_PATH
	CALL	DIR_MAKE		; make DESTINATION DIRECTORY
;
	MOV	SI,OFFSET SOURCE_PATH+2
	MOV	DI,OFFSET SOURCE_DIR_PATH+2
	CALL	PATH_DIR_CHECK		;
	MOV	DX,OFFSET SOURCE_DIR_PATH
	MOV	AH,CH_DIR		; SOURCE DIRECTORY CHANGE
	INT	BDOS			;
	JNC	BACKUP151		;
	JMP	BACKUP_NOT_FOUND	; error exit
;
;--------------- set source filename
;
BACKUP151:
	MOV	DI,OFFSET SOURCE_PATH
	CALL	FILE_PICK		; FILE NAME PICK UP
	MOV	ROOT_COUNT,0		; RESET ROOT COUNT
	MOV	DIRECTORY_COUNT,0
	MOV	SI,DI			;
	MOV	DI,OFFSET SOURCE_FILE_PATH+2
	CALL	TRANS_ASCIZ		; FILE NAME TRANS
	MOV	SI,OFFSET SOURCE_DIR_PATH+3
	MOV	DI,OFFSET PATH_DISP_AREA
	CALL	TRANS_ASCIZ		; PATH DISP AREA SET
	MOV	DX,OFFSET SOURCE_FILE_PATH
;
;--------------- search first into source drive
;
BACKUP154:
	MOV	CX,0027H		; file attr. A,S,H,or R
	CMP	OPTION_S,0		; specified /s option ?
	JE	BACKUP158		; /s option is not specified
	MOV	CX,0037H		; file attr. A,D,S,H,or R
BACKUP158:				;
	MOV	AH,SEARCH_FIRST		;
	INT	BDOS			; FIND MATCH FILE
	JNC	BACKUP16		;
	JMP	BACKUP_NOT_FOUND	; error exit
;
;****   OPTION CHECK AND DIRECTORY CHECK
;
BACKUP16:
	CMP	OPTION_M,0		; specified /m option ?
	JZ	BACKUP164		; /m option is not specified
	TEST	FIND_BUF_ATTR,20H	; check file attr. A
	JNZ	BACKUP164		; ARCHIVE BIT on
	TEST	FIND_BUF_ATTR,10H	; check file attr D
	JNZ	BACKUP164
	JMP	BACKUP50		; go to next file search
BACKUP164:
	CMP	OPTION_D,0		; specified /d option ?
	JZ	BACKUP166		; /d option is not specified
	CALL	DATE_CHECK		; compare specified date
	JNC	BACKUP166		; modified on or after
	TEST	FIND_BUF_ATTR,10H	; check file attr D
	JNZ	BACKUP166
	JMP	BACKUP50		; go to next file search
BACKUP166:
	TEST	FIND_BUF_ATTR,10H	; check file attr. D
	JNZ	BACKUP168		;
	JMP	BACKUP18
;
;--------------- check  .  dir entry
;
BACKUP168:
	CMP	FIND_BUF_PNAME,'.'
	JNZ	BACKUP16800		;
;
;--------------- skip pare directory entries (. and ..)
;
	MOV	AH,SEARCH_NEXT		;
	INT	BDOS			; skip . dir
	MOV	AH,SEARCH_NEXT		;
	INT	BDOS			; skip .. dir
	JNC	BACKUP16		;
	MOV	DIR_COPY_FLAG,1		; set on directory copy flag
	JMP	BACKUP60		; go to next sub dir
;
;--------------- check dir entry full on destination
;
BACKUP16800:
	CALL	DIR_ENTRY_CHECK		; ENTRY FULL CHECK
	JNC	BACKUP1682		; OK
	CMP	AX,5			;
	JNZ	BACKUP1680		; I/O ERROR
;
	MOV	COPY_START_FLAG,0	;
	CALL	MULTI_VOLUME_PROCESS	; MULTI VOLUME PROCESS
	JNC	BACKUP1682		; OK
BACKUP1680:
	MOV	SI,OFFSET ERRMSG_50	;
	JMP	BACKUP_ERR		; ERROR EXIT
;
;--------------- set path name 
;
BACKUP1682:
	MOV	SI,OFFSET FIND_BUF_PNAME
	MOV	DI,OFFSET SOURCE_PATH+2	; set SOURCE_PATH
	MOV	CX,13			;
	REP	MOVSB			; SET DIR NAME on source
;
	MOV	SI,OFFSET FIND_BUF_PNAME
	MOV	DI,OFFSET DEST_PATH+2	; set DEST_PATH
	MOV	CX,13			;
	REP	MOVSB			;
;
;--------------- set directory level and change dir on source
;
	MOV	DI,OFFSET SOURCE_DIR_PATH
	CALL	SKIP_ZERO		;
	CMP	DI,OFFSET SOURCE_DIR_PATH+3
	JZ	BACKUP169		; SKIP
	MOV	BYTE PTR [DI],'\'	; append path delimiter
	INC	DI			;
BACKUP169:
	MOV	SI,OFFSET FIND_BUF_PNAME
	CALL	TRANS_ASCIZ		; SET DIR PATH TO SOURCE
	MOV	SI,OFFSET SOURCE_DIR_PATH+2
	MOV	DI,OFFSET DEST_DIR_PATH+2
	MOV	CX,128			;
	REP	MOVSB			; SET DIR PATH TO DESTINATION

	MOV	SI,OFFSET FIND_BUF_PNAME; set PATH_DISP_AREA
	MOV	DI,OFFSET PATH_DISP_AREA
	CALL	SKIP_ZERO
	MOV	BYTE PTR [DI],'\'	; set ASCIZ zero
	INC	DI
	CALL	TRANS_ASCIZ
;
	MOV	DX,OFFSET SOURCE_PATH
	MOV	AH,CH_DIR		;
	INT	BDOS			; CHANGE DIRECTORY on source
;
;--------------- make dir and change dir on destination
;
	MOV	DX,OFFSET DEST_PATH
	MOV	AH,MK_DIR		;
	INT	BDOS			; MAKE DIRECTORY on destination
	MOV	DX,OFFSET DEST_PATH
	MOV	AH,CH_DIR		;
	INT	BDOS			; CHANGE DIRECTORY on destination
;
	INC	ROOT_COUNT		; COUNT UP ROOT COUNT
	MOV	DX,OFFSET S_WILD_FILE
	JMP	BACKUP154		; go to first search 
;
;--------------- SET START NAME ON BACKUPID.@@@ BUFFER
;
BACKUP18:
	CMP	DIRECTORY_COUNT,0	; at a first time ?
	JZ 	BACKUP182		; OK
	CMP	FILE_COPY_FLAG,0
	jnz	BACKUP20		; go to set last backed up filename
BACKUP182:
	CMP	OPTION_A,01H		; specified /a option ?
	JZ	BACKUP20		; /a option is not specified
;
	call	set_1st_name		; set first filename into BACKUPID
;
;-------------- set source filename and destination filename
;
BACKUP20:				;
	CLD
	MOV	SI,OFFSET FIND_BUF_PNAME
	MOV	DI,OFFSET SOURCE_PATH+2
	MOV	CX,13
	REP	MOVSB			; SET SOURCE FILE NAME
;
	MOV	SI,OFFSET FIND_BUF_PNAME
	MOV	DI,OFFSET DEST_PATH+2
	MOV	CX,13
	REP	MOVSB			; SET DESTINATION FILE NAME
;
;--------------- SOURCE FILE OPEN
;
	MOV	AH,FL_OPEN
	MOV	DX,OFFSET SOURCE_PATH
	MOV	AL,0			; READ OPEN
	INT	BDOS			; SOURCE FILE OPEN
	JNC	BACKUP22
	MOV	SI,OFFSET ERRMSG_40	;
	JMP	BACKUP_ERR		; ERROR EXIT
;
BACKUP22:
	MOV	SOURCE_HAND,AX		; SET SOURCE HANDLE
;
	MOV	AX,512			;
	CALL	DISK_FREE_CHECK		; DISK FREE AREA CHECK
	CMP	DEST_FULL_FLAG,0
	JE	BACKUP23		;
	MOV	MULTI_FILE_NO,0		;
	MOV	COPY_START_FLAG,0	;
	CALL	MULTI_VOLUME_PROCESS	; MULTI PROCESS
;
;--------------- OPTION A CHECK AND DESTINATION FILE OPEN OR CREATE
;
BACKUP23:
	CMP	OPTION_A,0		; option a check
	JZ	BACKUP232		; no skip
;
;-------------- open destination file for /a option
;
BACKUP230:
	MOV	AH,FL_OPEN
	MOV	AL,1
	MOV	DX,OFFSET DEST_PATH
	INT	BDOS			; file write open
	JNC	BACKUP24		; normal end 
	CMP	AX,5			; file read_only check
	JNE	BACKUP232		; no
	MOV	AH,CH_MODE
	MOV	DX,OFFSET DEST_PATH
	MOV	CX,0020H
	MOV	AL,01H
	INT	BDOS			; file mode change
	JMP	SHORT BACKUP230		; retry
;
;-------------- creat destination file
;
BACKUP232:
	MOV	AH,FL_CREAT 		;
	MOV	DX,OFFSET DEST_PATH	;
	MOV	CX,0020H		;
	INT	BDOS			; DESTINATION FILE CREATE
	JNC	BACKUP24		;
;
	CMP	AX,5			; FILE ENTRY FULL CHECK
	JNZ	BACKUP25		; i/o error
;
	MOV	MULTI_FILE_NO,0		; RESET MULTI FILE SEQ NO
	CALL	MULTI_VOLUME_PROCESS	; MULTI VOLUME PROCESS
	JNC	BACKUP232		; NORMAL RETURN
BACKUP24:
	MOV	DEST_HAND,AX		; SET DESTINATION HANDLE
;
;--------------- FILE NAME DISPLAY
;
	CALL	FILE_DISP		;
;
;--------------- set last backup filename
;
	MOV	SI,OFFSET FIND_BUF_PNAME;
	MOV	DI,OFFSET END_FILE_NAME
	MOV	CX,13
	REP	MOVSB			; SET LAST BACK UP FILENAME
;
	MOV	FILE_COPY_FLAG,1	; SET ON FILE COPY FLAG
;
	MOV	AL,0			;
	MOV	MULTI_FILE_NO,AL	; RESET MULTI VOLUME NO OF FILE
	call	w_file_header		; write file header 128 bytes
	JNC	BACKUP26
BACKUP25:
	MOV	SI,OFFSET ERRMSG_50	;
	JMP	BACKUP_ERR		; error exit
;
BACKUP26:
	CMP	DEST_FULL_FLAG,0
	JE	BACKUP30
	call	multi_file		; multi file process
	jc	backup25		; error
;*
;*	SOURCE FILE --> DESTINATION FILE
;*
BACKUP30:
	MOV	DEST_FULL_FLAG,0
;
	PUSH	DS			;
	MOV	DS,BACKUP_BUFFER	; READ BASE ADDRESS
	XOR	DX,DX			; READ OFFSET ADDRESS
	MOV	BX,CS:SOURCE_HAND
	MOV	CX,8000H		; 32K
	MOV	AH,FL_READ		; READ source file
	INT	BDOS			;
	POP	DS			;
	JNC	BACKUP32		; OK
	MOV	SI,OFFSET ERRMSG_40	;
	JMP	BACKUP_ERR		; error exit
BACKUP32:
	CMP	AX,0			; END OF FILE
	JE	BACKUP40		; go to file copy end process
;
	CALL	DISK_FREE_CHECK		;
;
	PUSH	DS			;
	MOV	DS,BACKUP_BUFFER	; WRITE BASE ADDRESS
	XOR	DX,DX			; WRITE OFFSET ADDRESS
	MOV	CX,AX			; WRITE LENGTH
	MOV	BX,CS:DEST_HAND		;
	MOV	AH,FL_WRITE		; WRITE destination file
	MOV	CS:WTLNG,CX		;
	INT	BDOS			;
	POP	DS			;
	JNC	BACKUP26		; OK
BACKUP33:
	MOV	SI,OFFSET ERRMSG_50	;
	JMP	BACKUP_ERR		; error exit
;
;
;****	COPY END PROCESS	****
;
BACKUP40:
	call	cl_dest_file		; close destination file
	jc	backup33		; error
	call	cl_src_file		; close source file
	JNC	BACKUP50
	MOV	SI,OFFSET ERRMSG_40	
	JMP	BACKUP_ERR		; error exit
;
;--------------- search next into current dir
;
BACKUP50:
	MOV	AH,SEARCH_NEXT		; STEP THROUGH A DIRECTORY
	INT	BDOS			; MATCHING FILES
	JC	BACKUP60		; end of file entry
	inc	DIRECTORY_COUNT		; 
	JMP	BACKUP16		; go to next file backup
;
;-------------- pop up directory level
;
BACKUP60:
	CMP	ROOT_COUNT,0		; CHECK DIRECTORY level
	JZ	BACKUP61		;
	MOV	DX,OFFSET SOURCE_PAIR
	MOV	AH,CH_DIR		;
	INT	BDOS			; CHANGE DIRECTORY PAIR
;
	MOV	DX,OFFSET DEST_PAIR
	MOV	AH,CH_DIR		;
	INT	BDOS			;
;
	DEC	ROOT_COUNT		;
;
	MOV	DI,OFFSET SOURCE_DIR_PATH
	CALL	FILE_PICK		; FILE NAME PICK UP
	MOV	SI,DI			;
	MOV	DI,OFFSET CUR_FILE_NAME
	CALL	TRANS_ASCIZ		;
	MOV	DI,OFFSET SOURCE_DIR_PATH
	CALL	PATH_DIR_PAIR		; REMOVE PATH DIR FROM SOURCE
	MOV	DI,OFFSET DEST_DIR_PATH
	CALL	PATH_DIR_PAIR		; REMOVE PATH DIR FROM DSET
	MOV	DI,OFFSET PATH_DISP_AREA
	CALL	PATH_DIR_PAIR
;
;--------------- skip source files which are already backed up.
;
	MOV	DX,OFFSET S_WILD_FILE
	MOV	AH,SEARCH_FIRST
	MOV	CX,0037H		; file attr. A,D,S,H,or R
	INT	BDOS			; search first
BACKUP600:
	MOV	SI,OFFSET FIND_BUF_PNAME
	MOV	DI,OFFSET CUR_FILE_NAME
	CALL	FILE_NAME_CHECK		; CURRENT FILE NAME CHECK
	JZ 	BACKUP602		;
	MOV	AH,SEARCH_NEXT		;
	INT	BDOS			; search next
	JMP	SHORT BACKUP600		;

BACKUP602:
	MOV	AH,SEARCH_NEXT		;
	INT	BDOS			; SEARCH NEXT
	JC	BACKUP60		;
	JMP	BACKUP16		;
;
;--------------- update BACKUPID.@@@ file on the first or last diskette
;
BACKUP61:
	MOV	DI,OFFSET DEST_PAIR
	MOV	BYTE PTR [DI+2],'\'	; set path delimiter
	MOV	BYTE PTR [DI+3],0	; set ASCIZ zero
	MOV	DX,OFFSET DEST_PAIR
	MOV	AH,CH_DIR		;
	INT	BDOS			; change directory to root
;
	MOV	BX,OFFSET BACKUPID_BUFF
	MOV	BYTE PTR [BX],00H	; SET MULTI VOLUME FLAG
	MOV	AX,MULTI_VOL_NO		;
	MOV	WORD PTR 1[BX],AX	; SET MULTI VOLUME NO
	MOV	BYTE PTR 3[BX],0
	call	set_end_name		; set end filename into BACKUPID
;
	CMP	MULTI_VOL_FL,0		;
	JE	BACKUP62		;
	MOV	BX,OFFSET BACKUPID_BUFF
	MOV	BYTE PTR [BX],0FFH	; set last backup volume id.
BACKUP62:
	CALL	UP_BACKUPID		; update BACKUPID.@@@
	JNC	BACKUP66		; ERROR CHECK
	MOV	SI,OFFSET ERRMSG_50	;
	JMP	BACKUP_ERR		; error exit
;
BACKUP66:
	CMP	FILE_COPY_FLAG,1	; file copied ?
	JZ	BACKUP68		;
	CMP	DIR_COPY_FLAG,1		; directory copied?
	JZ	BACKUP68
	JMP	BACKUP_NOT_FOUND	; error exit
;
;------ normal return
;
BACKUP68:
	MOV	AL,0			; terminate code 0
	RET				;
;
;------- error exit
;
BACKUP_ERR:
	CALL	PMSG
	MOV	AL,4			; terminate code
	RET
;
;------- file not found exit
;
BACKUP_NOT_FOUND:
	MOV	SI,OFFSET MSG_00
	CALL	PMSG			;
	MOV	AL,1			; terminate code
	RET				;
	page
;******************************************************************
;*
;*   	SUBROUTINE
;*
;******************************************************************
;****************************************
;*	multi file process
;****************************************
multi_file	proc
	call	cl_dest_file		; close destination file
	jc	multi_file_err		; error
;
;--------------- MULTI VOLUME PROCESS EXEC
;
	ADD	MULTI_FILE_NO,1		;
	MOV	COPY_START_FLAG,1	;
	CALL	MULTI_VOLUME_PROCESS	; CALL MULTI VOLUME PROCESS
;
;
;--------------- create destination file 
;
	MOV	AH,FL_CREAT 		;
	MOV	DX,OFFSET DEST_PATH	;
	MOV	CX,0020H		;
	INT	BDOS			; DESTINATION FILE CREATE
	jc	multi_file_err		; error

	MOV	DEST_HAND,AX		; SET DESTINATION HANDLE
	CALL	FILE_DISP		; FILE NAME DISPLAY
;
	MOV	AL,MULTI_FILE_NO 
	call	w_file_header		; write file header 128 bytes
	jc	multi_file_err		; error

;
;--------------- write remaining source block to new diskette
;
	MOV	AX,REMAIN_LNG
	CALL	DISK_FREE_CHECK
;
	PUSH	DS			;
	MOV	DS,BACKUP_BUFFER	;
	XOR	DX,DX			;
	ADD	DX,CS:WTLNG		;
	MOV	CX,AX			;
	MOV	BX,CS:DEST_HAND		;
	MOV	AH,FL_WRITE		;
	MOV	CS:WTLNG,CX		;
	INT	BDOS			; write remaining block
	POP	DS
multi_file_err:
	ret
multi_file	endp
;****************************************
;*   MULTI VOLUME PROCESS		*
;****************************************
MULTI_VOLUME_PROCESS:
	MOV	MULTI_VOL_FL,01H	; SET ON MULTI VOLUME FLAG
	MOV	AX,MULTI_VOL_NO		;
;
;--------------- update BACKUPID.@@@ file
;
	MOV	BX,OFFSET BACKUPID_BUFF
	MOV	BYTE PTR [BX],01H	; SET MULTI VOLUME FLAG
	MOV	WORD PTR 1[BX],AX	; SET MULTI VOLUME NO
	INC	AX			;
	MOV	MULTI_VOL_NO,AX		; MULTI VOLUME NO COUNT UP
	MOV	AL,MULTI_FILE_NO
	MOV	BYTE PTR 3[BX],AL
;
	CMP	FILE_COPY_FLAG,0	; ALREADY FILE COPY ?
	JNZ	MULTI_VOLUME_20		; YES
	CMP	OPTION_A,0		; SPECIFIED OPTION A CHECK
	JNZ	MULTI_VOLUME_30		; YES SKIP
	ADD	BX,256			;
	MOV	DI,BX			;
	MOV	BYTE PTR [DI],0		; SET 0 ON END FILE NAME AREA
	JMP	SHORT MULTI_VOLUME_30	;
;
MULTI_VOLUME_20:
	call	set_end_name		; set end filename in BACKUPID

MULTI_VOLUME_30:
	CALL	UP_BACKUPID		; update BACKUPID.@@@
	jc	MULTI_VOLUME_ERR	; error exit
;
;--------------- require next diskette
;
MULTI_VOLUME_40:
	CALL	PROMPT			;
	MOV	AL,DEST			; destination drive number
	CALL	FILE_DELETE		; ALL FILE DELETE
	JC	MULTI_VOLUME_40		;
;
	MOV	SI,OFFSET MSG_10	; start message out
	CALL	PMSG
;
;-------------- create BACKUPID.@@@
;
	CALL	CR_BACKUPID		; create BACKUPID.@@@
	jc	MULTI_VOLUME_ERR	; error exit
;
	MOV	DX,OFFSET FIND_BUF_RES	;
	MOV	AH,SET_DTA		;
	INT	BDOS			;
	CMP	FILE_COPY_FLAG,0	; ALREADY FILE COPY ?
	jz	MULTI_VOLUME_end
 
	MOV	SI,OFFSET DEST_DIR_PATH
	CALL	DIR_MAKE		; MAKE DIRECTORY
;
	call	set_1st_name		; set first file name
MULTI_VOLUME_END:
	CLC
	RET				; NORMAL RETURN
MULTI_VOLUME_ERR:
	STC				;
	RET				; ERROR RETURN

INCLUDE	B:FILEDEL.INC
;--------------------------------------------------------------
; close source file
;--------------------------------------------------------------
cl_src_file	proc
	MOV	BX,SOURCE_HAND		;
	MOV	AH,FL_CLOSE		;
	INT	BDOS			; SOURCE FILE CLOSE
	jc	cl_src_err		; error
;
	MOV	DX,OFFSET SOURCE_PATH
	MOV	CL,FIND_BUF_ATTR
	AND	CL,0DFH			;
	MOV	CH,0			;
	MOV	AH,CH_MODE		;
	MOV	AL,01H			;
	INT	BDOS			; off attr. A of the source file
cl_src_err:
	ret
cl_src_file	endp
;-----------------------------------------------------------------
; close destination file
;-----------------------------------------------------------------
cl_dest_file	proc
	MOV	CX,FIND_BUF_TIME
	MOV	DX,FIND_BUF_DATE
	MOV	AL,01H
	MOV	AH,FILE_TIME_DATE
	MOV	BX,DEST_HAND		; SET TIME/DATE TO DESTINATION FILE
	INT	BDOS			;
;
	MOV	BX,DEST_HAND		;
	MOV	AH,FL_CLOSE		; DESTINATION FILE CLOSE
	INT	BDOS			;
	jc	cl_dest_err		; error
	MOV	DX,OFFSET DEST_PATH	;
	MOV	CL,FIND_BUF_ATTR	;
	MOV	CH,0			;
	MOV	AL,01H			;
	MOV	AH,CH_MODE		;
	INT	BDOS			; DESTINATION FILE ATTRIBUTE SET
cl_dest_err:
	ret
cl_dest_file	endp
;-------------------------------------------------------------
; write file header 128 bytes
;-------------------------------------------------------------
w_file_header	proc
	MOV	FILE_HEADER,AL		;
;
	MOV	AX,128			;
	CALL	DISK_FREE_CHECK		;
	MOV	DX,OFFSET FILE_HEADER
	MOV	CX,AX
	MOV	BX,DEST_HAND
	MOV	AH,FL_WRITE
	INT	BDOS			; WRITE FILE HEADER TO DESTINATION
	ret
w_file_header	endp
;---------------------------------------------------------------
; set first filename into BACKUPID_BUFFER
;---------------------------------------------------------------
set_1st_name	proc
	MOV	SI,OFFSET SOURCE_DIR_PATH+2
	MOV	DI,OFFSET BACKUPID_BUFF+128
	CALL	TRANS_ASCIZ
	MOV	DI,OFFSET BACKUPID_BUFF+128
	CALL	SKIP_ZERO
	MOV	BYTE PTR [DI],'\'	; append ASCIZ zero
	INC	DI
	MOV	SI,OFFSET FIND_BUF_PNAME
	MOV	CX,13			;
	REP	MOVSB			; FIRST FILE NAME SET
	ret
set_1st_name	endp
;----------------------------------------------------------------
; set end filename into BACKUPID_BUFFER
;----------------------------------------------------------------
set_end_name	proc
	ADD	BX,256			;
	MOV	DI,BX			;
;
	MOV	SI,OFFSET SOURCE_DIR_PATH+2
	CALL	TRANS_ASCIZ
	MOV	DI,BX
	CALL	SKIP_ZERO
	MOV	BYTE PTR [DI],'\'	; set path delimiter
	INC	DI
	MOV	SI,OFFSET END_FILE_NAME
	MOV	CX,13			;
	REP	MOVSB			; SET END FILE NAME
	ret
set_end_name	endp
;**********************************************************
;*   create BACKUPID.@@@ file on the destination diskette *
;**********************************************************
CR_BACKUPID	PROC
	MOV	AH,FL_CREAT		;
	MOV	DX,OFFSET BACKUPID_PATH
	MOV	CX,0020H		; file attribute A
	INT	BDOS			; CREATE BACKUPID.@@@
	JC	CR_BACKUPID_ERR		; create error

	PUSH	AX			; save handler
	MOV	BX,AX			; SET HANDLE
	MOV	AH,FL_WRITE		;
	MOV	DX,OFFSET BACKUPID_BUFF
	MOV	CX,512			;
	INT	BDOS			; write BACKUPID.@@@
	POP	AX
	JC	CR_BACKUPID_ERR		; write error

	MOV	BX,AX			;
	MOV	AH,FL_CLOSE
	INT	BDOS			; close BACKUPID.@@@
CR_BACKUPID_ERR:
	RET				; return CY if i/o error
CR_BACKUPID	ENDP
;****************************************
;*   write open BACKUPID.@@@ for update	*
;****************************************
UP_BACKUPID	PROC
	MOV	AL,1			; WRITE OPEN
	MOV	AH,FL_OPEN		;
	MOV	DX,OFFSET BACKUPID_PATH
	INT	BDOS			; BACKUP OPEN
	JC	UP_BACKUPID_ERR		; open error
 
	PUSH	AX			; save file handler
	MOV	DX,OFFSET BACKUPID_BUFF
	MOV	CX,512
	MOV	BX,AX
	MOV	AH,FL_WRITE		;
	INT	BDOS			; WRITE 'BACKUPID.@@@'
	POP	AX
	JC	UP_BACKUPID_ERR		; write error
 
	MOV	BX,AX
	MOV	AH,FL_CLOSE		;
	INT	BDOS			; CLOSE 'BACKUPID.@@@'
UP_BACKUPID_ERR:
	RET				; return CY if i/o error
UP_BACKUPID	ENDP

;****************************************
;*   DIRECTORY ENTRY FULL CHECK		*
;****************************************
;*		OUT: CF = OFF	NORMAL RETURN
;*			= ON  	ERROR
;*				AX= 5    : ENTRY FULL
;*				  = ELSE : I/O EEROR
DIR_ENTRY_CHECK:
	PUSH	DX			;
	CLC				;
;
	CMP	ROOT_COUNT,0		; ROOT CHECK
	JNZ	DIR_ENTRY_END		; NO EXIT
	CMP	FILE_HEADER+3,0		; ROOT DIRECTORY CHECK
	JNZ	DIR_ENTRY_END		; NO EXIT
;
	MOV	DX,OFFSET ENTRY_CHECK_PATH
	MOV	AH,MK_DIR		;
	INT	BDOS			; MAKE DIRECTORY FOR CHECK
	JNC	DIR_ENTRY_10		; OK
;
	MOV	AX,5			; FOR BUG OF DOS ?
	JMP	SHORT DIR_ENTRY_END	;
DIR_ENTRY_10:
	MOV	DX,OFFSET ENTRY_CHECK_PATH
	MOV	AH,RM_DIR		;
	INT	BDOS			; REMOVE DIRECTORY
DIR_ENTRY_END:
	POP	DX			; RESET REG.
	RET				;
;********************************
;*   DISK FREE SIZE CHECK	*
;********************************
;*		IN = AX (WRITE LENGTH)
;*		OUT= AX (WRITE LENGTH)
;*		     DESTINATION FULL CHECK FLAG
DISK_FREE_CHECK:
	MOV	DEST_FULL_FLAG,0
	PUSH	AX			;
	MOV	AH,GET_FREE		;
	MOV	DL,DEST			;
	INC	DL			;
	INT	BDOS			; GET DISK FREE SPACE
	MUL	BX			;
	MUL	CX			; CALCULATE REMAIN BYTE
	MOV	BX,AX			;
	POP	AX			;
	CMP	DX,0			;
	JNZ	DISK_FREE_00		; OK
	CMP	BX,AX			;
	JAE	DISK_FREE_00		; OK
;
	SUB	AX,BX 			;
	MOV	REMAIN_LNG,AX		;
	MOV	AX,BX			;
	MOV	DEST_FULL_FLAG,1
DISK_FREE_00:
	RET				;
;*************************
;*   DIRECTORY MAKE
;*************************
;	<INPUT>  :  SI = DIRECTORY PATH NAME POINTER
;
DIR_MAKE:
	PUSH	AX
	PUSH	DI
	MOV	DX,OFFSET DEST_ROOT_PATH
	MOV	AH,CH_DIR		;
	INT	BDOS			; ROOT CHANGE DIRECTORY
DIR_MAKE_00:
	MOV	DI,OFFSET DIR_MAKE_PATH+2
DIR_MAKE_10:
	MOV	AL,[SI+3]
	CMP	AL,'\'			; check path delimiter \
	JZ	DIR_MAKE_20		;
	CMP	AL,0			; check ASCIZ 0
	JZ	DIR_MAKE_20		;
	MOV	[DI],AL			; SET DIRECTORY
	INC	SI			;
	INC	DI			;
	JMP	SHORT DIR_MAKE_10

DIR_MAKE_20:
	PUSH	AX			; save last chr. \ or null
	MOV	BYTE PTR [DI],0		; set ASCIZ 0
	MOV	DX,OFFSET DIR_MAKE_PATH
	MOV	AH,MK_DIR		;
	INT	BDOS			; make dir.
	MOV	DX,OFFSET DIR_MAKE_PATH
	MOV	AH,CH_DIR		; 
	INT	BDOS			; change dir to a now made
;
	INC	SI			;
	POP	AX			; load last chr. \ or null
	CMP	AL,0			; end of make dir if ASCIZ 0
	JZ	DIR_MAKE_END		;
	JMP	SHORT DIR_MAKE_00	; make next low level sub-dir.

DIR_MAKE_END:
	POP	DI			;
	POP	AX			;
	RET				;
;************************
;*   PROMPT MESSAGE OUT	*
;************************
;	<INPUT>  :  SI = PRINT MESSAGE POINTER
;
PMSG:
	PUSH	DS			; PRINT MESSAGE AT [SI] TO ZERO
	PUSH	CS			;
	POP	DS			; DS<=CS
	CLD				;
PMSG10:
	LODSB				; GET A CHARACTER
	TEST	AL,AL			; SEE , IF ZERO TERMINATION
	JZ	PMSG_X			; YES EXIT
	PUSH	SI			; SAVE POINTER
	CALL	CONOUT			; 
	POP	SI			; RECOVER POINTER
	JMP	SHORT PMSG10		; AND LOOP

PMSG_X:
	POP	DS
	RET
;************************
;*   CONSOLE OUT ROUTINE*
;************************
CONOUT:
	MOV	DL,AL			; SET CHARACTER
	MOV	AH,CON_OUT		; DISPLAY CHARACTER
	INT	BDOS			;
	RET				;
;************************
;*   PROMPT		*
;************************
PROMPT:
	MOV	AL,DEST			;
	ADD	AL,'A'			;
	MOV	PROMPT_MSG_10,AL	; set drive number chr.
	MOV	AX,MULTI_VOL_NO		; set diskette number
	MOV	SI,OFFSET PROMPT_MSG_00
	CALL	BINASCII		; VOLUME NO SET
	MOV	SI,OFFSET MSG_12
	CALL	BINASCII		;
;
	MOV	SI,OFFSET PROMPT_MSG
	CALL	PMSG
;
	MOV	AX,CON_CHK		;
	INT	BDOS			; flush and get any key
 	RET				;
;************************
;*   FILE NAME DISPLAY	*
;************************
FILE_DISP:
	PUSH	SI
	PUSH	DI
	PUSH	CX
	PUSH	AX
;
	MOV	DI,OFFSET PATH_DISP_AREA
	CALL	SKIP_ZERO
	CMP	DI,OFFSET PATH_DISP_AREA
	JZ	FILE_DISP_00
;
	MOV	SI,OFFSET PATH_DISP_AREA
	MOV	DI,OFFSET FILE_HEADER+3
FILE_DISP_0S:
	LODSB				; 
	CMP	AL,[DI]			; check different from current path
	JNZ	FILE_DISP_1S		; yes
	CMP	AL,0			; check end 
	JZ	FILE_DISP_00		; yes
	INC	DI			;
	JMP	SHORT FILE_DISP_0S	;
FILE_DISP_1S:
	DEC	SI			;
	CMP	BYTE PTR [SI],'\'	; check
	JNZ	FILE_DISP_2S		;
	INC	SI			;
FILE_DISP_2S:
;
	CALL	PMSG			; display path name
	MOV	AL,'\'
	CALL	CONOUT			; display \
;
FILE_DISP_00:
	MOV	DI,OFFSET FILE_DISP_AREA
	MOV	CX,13
	MOV	AL,20H
	REP	STOSB			; space clear
;
	MOV	SI,OFFSET FIND_BUF_PNAME
	MOV	DI,OFFSET FILE_DISP_AREA
	MOV	CX,13
FILE_DISP_01:
	MOV	AL,[SI]
	CMP	AL,0
	JE	FILE_DISP_10
	MOV	[DI],AL
	INC	SI
	INC	DI
	DEC	CX
	JNZ	FILE_DISP_01
FILE_DISP_10:
	MOV 	SI,OFFSET FILE_DISP_AREA
	CALL	PMSG			; display filename
;
	POP	AX
	POP	CX
	POP	DI
	POP	SI
	RET
;*************************
;*   DATE CHECK		 *
;*************************
;
;	<OUTPUT>  : CF  = OFF   NORMAL RETURN
;			= ON    ERROR
;
DATE_CHECK:
	MOV	AX,FIND_BUF_DATE	; set year of file
	MOV	CL,9			;
	SHR	AX,CL			;
	ADD	AX,1980			; add '1980'
	MOV	BX,Y_AREA		;
	CMP	AX,BX			; y_area >= year ?
	JNE	DATE_CHECK00
;
	MOV	AX,FIND_BUF_DATE	; set mounth of file
	MOV	CL,5			;
	SHR	AX,CL			;
	AND	AX,000FH		;
	MOV	BL,M_AREA		;
	MOV	BH,0			;
	CMP	AX,BX			; m_area >= mounth ?
	JNE	DATE_CHECK00
;
	MOV	AX,FIND_BUF_DATE	; set day of file
	AND	AX,001FH		;
	MOV	BL,D_AREA		;
	MOV	BH,0
	CMP	AX,BX			; d_area >= day ?
	JE	DATE_CHECK01		;
;
DATE_CHECK00:
	JNC	DATE_CHECK01		; ok
	JMP	DATE_CHECK02		; error
DATE_CHECK01:
	CLC				; CF=0
	RET
DATE_CHECK02:				; error return
	STC				; CF=1
	RET
;********************************
;  DATE FORMAT CHECK		*
;********************************
;
;	<OUTPUT>  :  CF  = OFF  NORMAL RETURN
;			 = ON   ERROR
;
CHECK_DATE:
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
;
	MOV	CX,0
	MOV	DI,OFFSET OPTION_D_STR
CHECK_DATE10:
	INC	CX			; year check start ?
	CMP	CX,3			;
	JE	CHECK_DATE30		;
	MOV	AL,BYTE PTR [DI+1]	; check '-'
	CMP	AL,'-'			;
	JNE	CHECK_DATE11		;
	MOV	DL,0			;
	JMP	CHECK_DATE12		;
CHECK_DATE11:
	MOV	AL,BYTE PTR [DI]	; two degit check
	CALL	CHECK00			; numeric check
	JC	CHECK_DATE12A		;
	AND	AL,0FH			;
	MOV	DL,10			;
	MUL	DL			;
	MOV	DL,AL			;
	INC	DI			;
;
CHECK_DATE12:
	MOV	AL,BYTE PTR [DI]	;
	CALL	CHECK00			; numeric check
CHECK_DATE12A:
	JC	CHECK_DATE99		; error exit
	AND	AL,0FH			;
	ADD	AL,DL			;
	CMP	CX,1			; month ?
	JE	CHECK_DATE20		;
	CMP	CX,2			; day ?
	JE	CHECK_DATE25		;
	MOV	DL,BYTE PTR [DI+1]	;
	CMP	DL,0			;
	JE	CHECK_DATE50		;
	JMP	CHECK_DATE60		;
;
CHECK_DATE20:
	MOV	M_AREA,AL		; set mounth
	ADD	DI,2			;
	JMP	CHECK_DATE10		;
CHECK_DATE25:
	MOV	D_AREA,AL		; set day
	ADD	DI,2			;
	JMP	CHECK_DATE10		;
CHECK_DATE30:
	MOV	AL,BYTE PTR [DI+2]	; degit check
	CMP	AL,0			;
	JE	CHECK_DATE11		;
	MOV	AL,BYTE PTR [DI]
	CMP	AL,31H			; first degit check
	JE	CHECK_DATE40		; '1' or '2' ?
	CMP	AL,32H			;
	JE	CHECK_DATE40		;
	JMP	CHECK_DATE99		; error
CHECK_DATE40:
	MOV	AH,0			; year check of four degit
	AND	AX,000FH		;
	MOV	BX,1000			;
	MUL	BX			;
	MOV	BX,AX			;
	INC	DI			;
	MOV	AL,BYTE PTR [DI]	;
	CALL	CHECK00			; numeric check
	JC	CHECK_DATE99		; error exit
	AND	AX,000FH		;
	MOV	DX,100			;
	MUL	DX			;
	ADD	BX,AX			;
	INC	DI			;
	JMP	CHECK_DATE11		;
CHECK_DATE50:
	MOV	BX,1900			; add '1900'
CHECK_DATE60:
	MOV	AH,0			;
	ADD	AX,BX			;
	MOV	Y_AREA,AX
	JMP	CHECK_DATE100
CHECK_DATE99:
	STC
	JMP	CHECK_DATE200
CHECK_DATE100:
	CMP	Y_AREA,1980		; add '1900'
	JC	CHECK_DATE130		;
	CMP	M_AREA,1		; MONTH RANGE CHECK
	JC	CHECK_DATE130		;
	CMP	M_AREA,12		;
	JA	CHECK_DATE130		;
	CMP	M_AREA,4		; APRIL CHECK
	JZ	CHECK_DATE110		;
	CMP	M_AREA,6		; JUNE CHECK
	JZ	CHECK_DATE110		;
	CMP	M_AREA,9		; SEPTEMBER CHECK
	JZ	CHECK_DATE110		;
	CMP	M_AREA,11		; NOVEMBER CHECK
	JZ	CHECK_DATE110		;
	CMP	M_AREA,2		; FEBRUARY CHECK
	JZ	CHECK_DATE120		;
	CMP	D_AREA,1		; DAY CHECK
	JC	CHECK_DATE130		;
	CMP	D_AREA,31		;
	JA	CHECK_DATE130		;
	JMP	CHECK_DATE140		;
CHECK_DATE110:
	CMP	D_AREA,1		; DAY CHECK
	JC	CHECK_DATE130		;
	CMP	D_AREA,30		;
	JA	CHECK_DATE130		;
	JMP	CHECK_DATE140		;
CHECK_DATE120:
	CMP	D_AREA,1		; DAY CHECK
	JC	CHECK_DATE130		;
	CMP	D_AREA,29		;
	JA	CHECK_DATE130		;
	JMP	CHECK_DATE140		;
CHECK_DATE130:
	STC				; ERROR SET
	JMP	CHECK_DATE200		;
CHECK_DATE140:
	CLC				;
CHECK_DATE200:
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
;
	RET
;
CHECK00:
	CMP	AL,30H			; numeric check
	JC	CHECK99			;
	CMP	AL,39H			;
	JA	CHECK99			;
	CLC				;
	RET				;
CHECK99:
	STC				;
	RET				;
;
include b:backrest.inc

	ORG	$
	IF	($-BEGIN) MOD 10H
	ORG	($-BEGIN) + 10H - (($-BEGIN) MOD 10H )
	ENDIF
ENDLOC	LABEL	BYTE


CODE	ENDS
	END	START
T


	

k

O

N


N

R




N

