		page
;================================================================
;=
;=	PARSER for BACKUP command
;=
;=	<SYNTAX>
;=		[d:][path][filename][.ext] d:
;=
;=		?
;=
;=		---- switch ----
;=
;=			/S
;=			/M
;=			/A
;=			/D:string
;=
;================================================================

;----------------
;	equ
;----------------

dma			equ	81h
tab			equ	09h
cr			equ	0dh
blank			equ	20h
blank2			equ	(blank shl 8) + blank

;----------------
;	data
;----------------

source_drive		db	0		; source drive char.
path			db	128	dup (0)	; path string
filename		db	8 + 1	dup (0)	; file name string
ext			db	3 + 1	dup (0)	; extention string
destination_drive	db	0		; destination drive char.
option_s		db	0		; s option exist if 1
option_m		db	0		; m 
option_a		db	0		; a
option_d		db	0		; d
option_d_str		db	10	dup (0)	; string of d option

;
;*******************************************************
;*
;*	subroutine
;*

;*******************************************************
;*
;*		convert from low case (a-z) to upper case (A-Z)
;*
toupper		proc				; upper case-ing al
		cmp	al,'a'
		jc	ret2
		cmp	al,'z'+1
		jnc	ret2
		sub	al,'a'-'A'
ret2:
		ret
toupper		endp
;*******************************************************
;*
;*		skip blank and tab
;*
blank_skip	proc				; skip white character
bs1:						; si=string pointer
		lodsb
		cmp	al,blank
		jz	bs1
		cmp	al,tab
		jz	bs1
		dec	si
		ret
blank_skip	endp
;*******************************************************
;*
;*		check delimiter character blank,tab,and carriage return
;*
check_delm	proc				; check if delimiter or not
		cmp	al,blank		; al=char.
		jz	ret1			; yes if zf=1
		cmp	al,tab			; no  if zf=0
		jz	ret1
		cmp	al,cr
ret1:
		ret
check_delm	endp
;*******************************************************
;*
;*		parse BACKUP command line
;*
;*******************************************************

ps		proc				; analyze token

		cld
		mov	si,dma
		mov	di,si
lp1:
		lodsb				; convert upper case
		call	toupper
		stosb
		cmp	al,cr			; string end ?
		jnz	lp1

		mov	ax,(37h shl 8) + 0	; get switch char.
		int	21h			; dl=switch char.

		mov	si,dma
		mov	di,si
		call	blank_skip
		cmp	al,'?'			; "?" case ?
		jnz	ps1
		inc	si
		call	blank_skip
		cmp	al,cr
		jz	quest_boot		; jump if "?" only
ps1:
;
;---------------- analyze switch --------------------------------
;
		mov	si,di			; si=string top
ps2:
		lodsb
		cmp	al,cr			; end of string ?
		jz	end_switch_n
		cmp	al,dl			; switch ?
		jz	found_switch
		jmp	short ps2

end_switch_n:	jmp	end_switch
quest_boot:	jmp	quest			; boot strap jump for "?" case

found_switch:
ps3:
		cmp	byte ptr [si],'S'	; case of "S"
		jz	s_proc
		cmp	byte ptr [si],'M'	;	  "M"
		jz	m_proc
		cmp	byte ptr [si],'A'	;	  "A"
		jz	a_proc
		cmp	byte ptr [si],'D'	;	  "D"
		jz	d_proc
		jmp	error			; error if otherwise
s_proc:		mov	option_s,1
		jmp	com_proc
m_proc:		mov	option_m,1
		jmp	com_proc
a_proc:		mov	option_a,1
		jmp	com_proc
d_proc:
		cmp	option_d,0		; already set ?
		jnz	error_boot
		mov	option_d,1
		mov	word ptr [si-1],blank2	; remove switch char.
		inc	si
		cmp	byte ptr [si],':'	; check syntax
		jnz	error_boot
		mov	byte ptr [si],blank	; remove
		inc	si
		mov	cx,10			; max 10  mm-dd-yy[yy]
		mov	bx,offset option_d_str
cpdate:						; copy d option string
		mov	al,[si]
		call	check_delm		; string end ?
		jz	ps2_n
		cmp	al,dl			; switch char. ?
		jz	ps2_n
		cmp	cx,0			; option_d_str full ?
		jz	cpdate_1		; skip remaining string
		dec	cx
		mov	[bx],al
cpdate_1:
		inc	bx
		mov	byte ptr [si],blank	; remove string
		inc	si
		jmp	short cpdate
ps2_n:		jmp	ps2
com_proc:
		mov	word ptr [si-1],blank2	; remove switch char.
		inc	si
		mov	al,[si]
		call	check_delm		; switch end ?
		jz	ps2_n
		cmp	al,dl			;    or continue switch char.
		jz	ps2_n
		jmp	short ps3		; continue switch
end_switch:
;
;---------------- find destination drive ----------------
;
fd1:
		dec	si			; search from tail to head
		cmp	byte ptr [si],':'	; drive char. ?
		jz	fd2
		mov	al,[si]			; check ilegal char.
		call	check_delm
		jnz	error_boot
		cmp	si,di			; string head ?
		jnz	fd1

error_boot:	jmp	error			; boot strap jump

fd2:
		dec	si
		mov	al,[si]
		mov	destination_drive,al	; set destination drive
		dec	si
		mov	al,[si]
		call	check_delm
		jnz	error_boot
		mov	word ptr [si+1],blank2	; remove drive specification
;
;---------------- check file spec. -----------------------
;
		mov	bp,si			; command tail
		mov	si,di			; command head
		call	blank_skip		; skip white char.
cfs1:
		lodsb				; skip token
		call	check_delm
		jnz	cfs1
		dec	si
		call	blank_skip		; skip white char.
		cmp	si,bp			; more token ?
		jc	error_boot
;
;---------------- find source drive ----------------------
;
		mov	si,di			; set command head
fs1:
		lodsb				; search from head to tail
		cmp	al,':'			; drive char.
		jz	end_source1
		cmp	al,cr			; string end ?
		jz	end_source2
		jmp	short fs1
end_source1:
		dec	si
		dec	si
		mov	al,[si]
		mov	source_drive,al		; set source drive
		dec	si
		mov	al,[si]
		call	check_delm
		jnz	error
		mov	word ptr [si+1],blank2	; remove drive specification
end_source2:
;
;---------------- find extention -------------------
;
		mov	si,bp			; set string tail
se1:
		cmp	si,di			; string head ?
		jz	fname
		dec	si
		cmp	byte ptr [si],'.'	; find extention char.
		jz	fdot
		cmp	byte ptr [si],'\'	; find path char.
		jz	fpath
		jmp	short se1
fdot:
		mov	bx,si			; resave command tail
		mov	al,[si+1]		; extention or path ?
		call	check_delm
		jz	pathp			; jump if path
		push	si			; copy extention
		mov	cx,3			; max 3 char.
		mov	bx,offset ext
cdot:
		inc	si
		mov	al,[si]
		call	check_delm
		jz	end_dot
		mov	[bx],al
		inc	bx
		loop	cdot
end_dot:
		pop	si
		mov	byte ptr [si],blank	; separate extention
		mov	bp,si			; resave command tail
sp1:						; search from tail to head
		dec	si
		cmp	byte ptr [si],'\'
		jz	fpath
		cmp	si,di			; string head ?
		jnz	sp1
;
;---------------- copy file name ------------------------
;
fname:
		call	blank_skip
		cmp	si,bp			; missing file name and path ?
		jnc	nret			; yes.
		dec	si
fpath:
		push	si
		mov	cx,8			; max 8 char.
		mov	bx,offset filename
cpath:
		inc	si
		mov	al,[si]
		call	check_delm
		jz	end_file
		mov	[bx],al
		inc	bx
		loop	cpath
end_file:
		pop	bx
pathp:
		inc	bx			; pointed file name top
;
;---------------- copy path -------------------------
;
		mov	si,di
		mov	di,offset path
		call	blank_skip
cppath:
		cmp	si,bx			; path string end ?
		jz	nret
		movsb
		jmp	short cppath
nret:						; normal return
		xor	al,al			; cf=0,zf=1
		ret

error:						; error return
		stc				; cf=1
		ret

quest:						; question return
		xor	al,al			; cf=0,zf=0
		inc	al
		ret
ps		endp
