		PAGE	58,132
		TITLE	ANSI.SYS	IBM CONSOLE DRIVER
;************************************************************************
;*									*
;*	MODULE NAME	ANSI.SYS					*
;*									*
;*	FUNCTION	CONSOLE DRIVER PROGRAM.			 	*
;*			SYSTEM... MSD-A1				*
;*			OS NAME... MS_DOS 2.0 (FOR A1)			*
;*			THIS PROGRAM IS LOADED WHEN START UP BY	 	*
;*			"SYSINIT". (SET FILE NAME IN "CONFIG.SYS" FILE.)*
;*									*
;*	REMARK		THIS PROGRAME IS MAKED FROM UNASSEMBLE LIST	*
;*									*
;*	DATE		MAR/23/84					*
;*									*
;************************************************************************
		PAGE
;****************************************
;*		EQUATE BLOCK		*
;****************************************
;
;	ASCII CODE
;
$ESC		EQU	1BH		; ESCAPE CODE
CR		EQU	0DH
LF		EQU	0AH
CNTL_C		EQU	03H
BS		EQU	08H
BEL		EQU	07H
SPACE		EQU	20H
;
;
;	ROM BIOS
;
;	(INTERRUPT VECTER)
CRTDUMP		EQU	05H		; CRT DUMP
KB_ROM		EQU	18H		; KB
CRT_ROM		EQU	19H		; CRT
;	(FUNCTION CODE)
CRT_FNC_SETMOD	EQU	0		; CRT	SET SCREEN MODE
CRT_FNC_SETCSR	EQU	1		; CRT	SET CURSOL TYPE
CRT_FNC_CSRDSP	EQU	2		; CRT	SET CURSOL POSITION
CRT_FNC_GETCSR	EQU	3		; CRT	GET CURSOL TYPE
CRT_FNC_SCRUP	EQU	6		; CRT	SCROLL UP/ERASE
CRT_FNC_WRITECA	EQU	9		; CRT	WRITE CHAR/ATTRIB
CRT_FNC_WRITEC	EQU	10		; CRT	WRITE CHARACTER
CRT_FNC_TTY	EQU	14		; CRT	WRITE TELETYPE

KB_FNC_READ	EQU	0		; KB	READ CHARACTER
KB_FNC_RDND	EQU	1		; KB	READ CHARACTER NON DESTROY
KB_FNC_SENCE	EQU	2		; KB	STATUS SENCE
;
;	VRAM AND BUFFER
;
BUF_SIZ		EQU	512		; BUFFER OF REASSIGNMENT LENGTH
ESC_BUF_SIZE	EQU	140		; BUFFER OF ESC SEQUENCE LENGTH
;
LINE_MAX	EQU	24		; MAX LINE NUMBER ( 0 ORIGIN )
LINE_SIZ	EQU	80
;
;****************************************
;*		STRUCTURE BLOCK	 	*
;****************************************
IODAT		STRUC			; PACKET TABLE
CMDLEN		DB	?		;	LENGTH OF COMMAND
UNIT		DB	?		;	SUB UNIT SPECIFIER
CMD		DB	?		;	COMMAND CODE
STATUS		DW	?		;	STATUS
		DB	8 DUP(?)
MEDIA		DB	?		;	MEDIA DESCRIPTOR
TRANS		DD	?		;	TRANSFER ADDRESS
COUNT		DW	?		;	COUNT OF BLOCKS OR CHARACTERS
START		DW	?		;	FIRST BLOCK TO TRANSFER
IODAT		ENDS
		PAGE
;********************************************************
;*							*
;*	SYSTEM PROGRAM SEGMENT AREA			*
;*							*
;********************************************************
INT_VECTOR	SEGMENT AT 0000H	; INTERRUPT VECTOR
;
		ORG	6*4
INT6_VECTOR	LABEL	DWORD		; BREAK KEY INTERRUPT
		ORG	29H*4
INT29_VECTOR	LABEL	DWORD		; DIRECT CRT OUTPUT
INT_VECTOR	ENDS

;****************************************
;*	IO.SYS SEGMENT			*
;****************************************
IO_SEG		SEGMENT	AT 60H
		ORG	8+2
MEM_SW3		LABEL	BYTE
		ORG	10H
CON_WORK	LABEL	DWORD
IO_SEG		ENDS

	INCLUDE	B:SYSCOM.ASM
		PAGE
CODE		SEGMENT PUBLIC 'CODES'
		ASSUME	CS:CODE,DS:NOTHING,ES:NOTHING,SS:NOTHING

		ORG	0
START_PROGRAM	LABEL	NEAR
;********************************************************
;*							*
;*	TABLE BLOCKS (READ ONLY)			*
;*							*
;********************************************************
;****************************************
;*	DEVICE TABLE			*
;****************************************
CON_DEV	 LABEL	WORD
		DD	-1		; NEXT TABLE POINTER
		DW	8013H		; STATUS
					;	(STANDARD CONSOL I/O,
					;	SPECIAL,CHARCTER DEVICE)
		DW	STRATEGY	; STRATEGY ENTRY POINT
		DW	CON_INT		; INTERRUPT ENTRY POINT
		DB	'CON     '	; DEVICE NAME
;
;****************************************
;*	DESPATCH TABLE FOR DEVICES	*
;****************************************
CON_TBL	 LABEL	WORD
		DW	CON_INIT	; 0 - INIT
		DW	CMDERR_EXIT	; 1 - MEDIA CHECK (NOT USED)
		DW	CMDERR_EXIT	; 2 - GET BPB (NOT USED)
		DW	CMDERR_EXIT	; 3 - IO CTRL INPUT
		DW	CON_READ	; 4 - DESTRUCTIVE READ
		DW	CON_RDND	; 5 - NON-DESTRUCTIVE READ
		DW	NORMAL_EXIT	; 6 - INPUT STATUS
		DW	CON_FLUSH	; 7 - FLUSH INPUT BUFFER
		DW	CON_WRITE	; 8 - WRITE
		DW	CON_WRITE	; 9 - WRITE & VERIFY
		DW	NORMAL_EXIT	;10 - WRITE STATUS
		DW	NORMAL_EXIT	;11 - OUTPUT STATUS
		DW	CMDERR_EXIT	;12 - IOCTL OUTPUT
;
;****************************************
;*					*
;*	ANSI ESC MODULE TABLE		*
;*					*
;*		IDENT STRUCTURE		*
;*		0 +---------------+	*
;*		  !END CHARACTER  !	*
;*		1 +---------------+	*
;*		  ! MODULE NAME   !	*
;*		3 +---------------+	*
;*					*
;****************************************
ESC_TBL	 LABEL	BYTE
		DB	'A'
		DW	ESC_CUU		; CURSOL UP
		DB	'B'
		DW	ESC_CUD		; CURSOL DOWN
		DB	'C'
		DW	ESC_CUF		; CURSOL FORWORD
		DB	'D'
		DW	ESC_CUB		; CURSOL BACK
		DB	'H'
		DW	ESC_CUP		; CURSOL POSITION
		DB	'J'
		DW	ESC_ED		; ERASE IN DISPLAY
		DB	'K'
		DW	ESC_EL		; ERASE IN LINE
		DB	'R'
		DW	ESC_CPR		; CURSOL POSITION REPORT
		DB	'f'
		DW	ESC_CUP		; CURSOL POSITION
		DB	'h'
		DW	ESC_SM		; SET MODE
		DB	'l'
		DW	ESC_RM		; RESET MODE
		DB	'm'
		DW	ESC_SGR		; SELECT GRAPHIC RENDITION
		DB	'n'
		DW	ESC_DSR		; DEVICE STATUS REPORT
		DB	'p'
		DW	ESC_STRING	; CHANGE CHARACTER TO STRING
		DB	's'
		DW	ESC_PSCP	; SAVE CURSOL POSITION
		DB	'u'
		DW	ESC_PRCP	; RESTORE CURSOL POSITION
;
		DB	0		; END CODE
;
;****************************************
;*					*
;*	ATTRIBUTE TABLE		 	*
;*					*
;*		IDENT STRUCTURE	 	*
;*		0 +-----------------+	*
;*		  ! PARAMETER VALUE !	*
;*		1 +-----------------+	*
;*		  ! RESET BIT       !	*
;*		2 +-----------------+	*
;*		  ! SET BIT         !	*
;*		3 +-----------------+	*
;*					*
;****************************************
ATTRIBUTE_TBL	LABEL	BYTE
		DB	02,00000000B,00010000B	; VERTICAL LINE
		DB	03,00000000B,00000001B	; OVER LINE
		DB	04,00000000B,00001000B	; UNDER LINE
		DB	05,00000000B,00000010B	; BLINK
		DB	07,00000000B,00000100B	; REVERSE
		DB	08,11100000B,00000000B	; SECRET
;
		DB	30,11100000B,00000000B	; COLOR	: BLACK
		DB	31,11100000B,01000000B	;	: RED
		DB	32,11100000B,10000000B	;	: GREEN
		DB	33,11100000B,11000000B	;	: YELLOW
		DB	34,11100000B,00100000B	;	: BLUE
		DB	35,11100000B,01100000B	;	: MAGENDA
		DB	36,11100000B,10100000B	;	: CYAN
		DB	37,11100000B,11100000B	;	: WHITE
;
		DB	40,11100000B,00000100B	; REVERSE	: BLACK
		DB	41,11100000B,01000100B	;		: RED
		DB	42,11100000B,10000100B	;		: GREEN
		DB	43,11100000B,11000100B	;		: YELLOW
		DB	44,11100000B,00100100B	;		: BLUE
		DB	45,11100000B,01100100B	;		: MAGENDA
		DB	46,11100000B,10100100B	;		: CYAN
		DB	47,11100000B,11100100B	;		: WHITE
		DB	-1		; END CODE
		PAGE
;****************************************
;*	WORK AREA 1			*
;****************************************
PTRSAV		DD	0		; PACKET POINTER SAVE
;
REAS_CONF	LABEL	NEAR		; REASSIMENT CONFIGURATION
		DD	STRING_TBL	;  BUFFER ADDRESS
		DW	BUF_SIZ		; BUFFER BYTE LENGTH
STRING_TBL_LNG	DW	STRING_SIZ	; BUFFER ACCUAL USING SIZE
		DW	0		; RESEARVE
;************************************************
;*						*
;*	PROGRAM WORK AREA 2			*
;*						*
;************************************************
;
;*	CONIN WORK
;
STRING_CNT	DB	0		; COUNT OF STRING CHARACTERS
STRING_ADR	DW	STRING_TBL	; ADDRESS OF STRING CHARACTERS
READ_CHA	DB	0		; BEFORE READ CHARACTER (=0, NONE)
;
;*	CONOUT WORK
;
WRAP_FLAG	DB	0		; WRAP FLAG
					;	BIT0 OFF=WRAP, ON=NO WRAP
					;	BIT1 ON=END OF LINE
CUR_ATTRIB	DB	10000000B	; CURRENT ATTRIBUTE
DEF_FLAG	DB	0		; DEFALT FLAG
;
;*	ESC SEQUENCE WORK
;
JUMP_MODULE	DW	ONE_WRITE	; ENTRY MODULE FOR NEXT DATA
PARA_NUM	DB	0		; PARAMETER NUMBER OF ESC SEQUENCE
START_CHA	DB	0		; START CHARACTER OF ASCII PARAMETER
SR_MOD_CHA	DB	0		; CHARACTER SET/RESET MODE

SAVE_CL		LABEL	WORD		; SAVE CURSOL ADDRESS
COLUMN_SAVE	DB	0		; SAVE COLUMN NUMBER (BY ESC [ s,u)
LINE_SAVE	DB	0		; SAVE LINE NUMBER (BY ESC [ s,u)

CPR_BUF		DB	$ESC,'[00;00R'	; CURSOL POSITION REPORT BUFFER
		DB	CR

MSK_ATTRIB	DB	0		; ATTIBUTE MASK
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	STRATEGY			*
;*							*
;*	FUNCTION	GET CONSOL REQUEST PARAMETER	*
;*							*
;*	INPUT		ES:BX	PACKET TABLE		*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
STRATEGY	PROC	FAR
		MOV	WORD PTR [PTRSAV],BX	 ; SAVE PACKET ADDRESS
		MOV	WORD PTR [PTRSAV+2],ES
		RET
STRATEGY	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	CON_INT			 	*
;*							*
;*	FUNCTION	CONSOLE I/O CONTROL		*
;*							*
;*	INPUT/OUTPUT	NONE				*
;*							*
;********************************************************
CON_INT		PROC	FAR
		PUSH	SI		; ALL REGISTER SAVE
		PUSH	AX
		PUSH	CX
		PUSH	DX
		PUSH	DI
		PUSH	BP
		PUSH	DS
		PUSH	ES
		PUSH	BX
;
		LDS	BX,[PTRSAV]	; GET PACKET ADDRESS
		MOV	CX,[BX.COUNT]	; CX = NUMBER OF CHARACTERS
		MOV	AL,[BX.CMD]	; AL = COMMAND #
		CBW
		MOV	SI,OFFSET CON_TBL
		ADD	SI,AX		; GET BRANCH MODULE FROM DESPATCH TABLE
		ADD	SI,AX		;
		CMP	AL,12
		JA	CMDERR_EXIT
		LES	DI,[BX.TRANS]	; ES:DI = DATA ADDRESS
		PUSH	CS
		POP	DS
		JMP	[SI]
;****************************************
;*	EXIT POINT			*
;****************************************
BUSY_EXIT:
		MOV	AH,03H		; STATUS = BUSY
		JMP	SHORT COMMON_EXIT
;
CMDERR_EXIT:
		MOV	AL,3		; STATUS = COMMAND ERROR
		MOV	AH,81H		;
		JMP	SHORT COMMON_EXIT
;
NORMAL_EXIT:
		MOV	AH,1
;*
COMMON_EXIT:
		LDS	BX,[PTRSAV]	; SET STATUS
		MOV	[BX.STATUS],AX
;
		POP	BX		; ALL REGISTER RESTORE
		POP	ES
		POP	DS
		POP	BP
		POP	DI
		POP	DX
		POP	CX
		POP	AX
		POP	SI
		RET
CON_INT		ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	INT6_PROC			*
;*							*
;*	FUNCTION	INTERRUPT WHEN BREAK KEY IN.	*
;*							*
;*	INPUT/OUTPUT	NONE				*
;*							*
;*							*
;*							*
;********************************************************
INT6_PROC	PROC	FAR
		PUSH	AX
		MOV	[READ_CHA],CNTL_C
		MOV	[STRING_CNT],0	; CLEAR READING STRING
INT6_PROC20:
		MOV	AH,KB_FNC_RDND	; KB DATA NONE ?
		INT	KB_ROM
		JZ	INT6_PROC50
;
		MOV	AH,KB_FNC_READ	; DATA GET
		INT	KB_ROM
		JMP	INT6_PROC20
INT6_PROC50:
		POP	AX
		IRET
INT6_PROC	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	INT29_PROC			*
;*							*
;*	FUNCTION	DIRECT CONSOLE OUTPUT		*
;*							*
;*	INPUT		AL : OUTPUT DATA		*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
INT29_PROC	PROC	FAR
		STI
		PUSH	DS
		PUSH	CS
		POP	DS
		CALL	CONOUT		; OUTPUT CHARACTER TO CRT
		POP	DS
		IRET
INT29_PROC	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	CON_RDND			*
;*							*
;*	FUNCTION	NON-DESTRUCTIVE READ		*
;*							*
;*	INPUT		NONE				*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
	ASSUME	CS:CODE,DS:CODE,ES:NOTHING,SS:NOTHING
CON_RDND	PROC	NEAR
		MOV	AL,[READ_CHA]	; FINISH READ ?
		OR	AL,AL
		JNZ	CON_RDND80	; GO SET DATA TO PACKET
;
		CMP	[STRING_CNT],0	; READING CHARACTER FROM STRING ?
		JZ	CON_RDND40	; NO
;
		MOV	BX,[STRING_ADR] ; GET CHARACTER FROM STRING
		MOV	AL,[BX]
		JMP	SHORT	CON_RDND80
;
CON_RDND40:
		MOV	AH,KB_FNC_RDND	; INPUT SENCE
		INT	KB_ROM
		JZ	CON_RDND90	; READ CHARACTER NONE ?
		CALL	CONV_SEARCH	; CHECK CHANGE STRING
		JNZ	CON_RDND60	; FOUND ?
;
		CMP	AL,0		; FUNCTION CODE ?
		MOV	AL,[BX+2]
		JNZ	CON_RDND80
		MOV	AL,[BX+3]
		JMP	SHORT CON_RDND80
;
CON_RDND60:
		CMP	AL,0		; FUNCTION CODE ?
		JNZ	CON_RDND80
;
		MOV	AH,KB_FNC_READ	; GET FUNCTION DATA
		INT	KB_ROM
		JMP	CON_RDND40
CON_RDND80:
		LDS	BX,[PTRSAV]	; GET PACKET TABLE
		MOV	[BX.MEDIA],AL	; SET CHARACTER
CON_RDND_RET:
		JMP	NORMAL_EXIT
CON_RDND90:
		JMP	BUSY_EXIT
;
CON_RDND	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	CON_READ			*
;*							*
;*	FUNCTION	READ MULTI CHARACTER FROM KB	*
;*							*
;*	INPUT		ES:DI	DATA STORE ADDRESS	*
;*			CX	DATA LENGTH		*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
CON_READ	PROC	NEAR
		JCXZ	CON_READ_RET	; CHARACTER NONE ?
CON_READ10:
		PUSH	CX
		CALL	CONIN		; CONSOL READ
		POP	CX
		JNZ	CON_READ90
		STOSB
		LOOP	CON_READ10
CON_READ_RET:
;
		JMP	NORMAL_EXIT
CON_READ90:
		JMP	BUSY_EXIT
CON_READ	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	CONIN				*
;*							*
;*	FUNCTION	READ ONE CHARACTER FROM KB	*
;*							*
;*	INPUT		NONE				*
;*							*
;*	OUTPUT		AL : ASCII CODE		 	*
;*							*
;********************************************************
CONIN		PROC	NEAR
;
;*	CNTL_C CHECK
;
		XOR	AX,AX
		XCHG	[READ_CHA],AL
		OR	AL,AL		; FINISH READ ?
		JNZ	CONIN80
;
;*	GET CHARACTER
;
CONIN10:	CMP	[STRING_CNT],0	; READING CHARACTER STRING ?
		JNZ	CONIN25
		MOV	AH,KB_FNC_RDND
		INT	KB_ROM
		JZ	CONIN90
		MOV	AH,KB_FNC_READ
		INT	KB_ROM		; READ A CHARACTER
;
		CALL	CONV_SEARCH	; CHECK CHANGE STRING
		JNZ	CONIN30		; NOT FOUND ?
		DEC	CX		; CX = STRING LENGTH
		DEC	CX
		INC	BX		; BX = STRING ADDRESS
		INC	BX
		OR	AL,AL		; FUNCTION CODE ?
		JNZ	CONIN20		; NO
		DEC	CX
		INC	BX
CONIN20:
		MOV	[STRING_CNT],CL ; SET STRING ADDRESS AND LENGTH
		MOV	[STRING_ADR],BX
CONIN25:
		CALL	GET_STRING	; GET TOP CHARACTER OF STRING
		JMP	CONIN80
CONIN30:
		CMP	AL,0		; FUNCTION CODE ?
		JZ	CONIN10
CONIN80:
		XOR	CX,CX
CONIN_RET:
		RET
CONIN90:
		OR	CX,1
		JMP	CONIN_RET
CONIN		ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	GET_STRING			*
;*							*
;*	FUNCTION	GET A CHARACTER FROM STRING	*
;*							*
;*	INPUT		NONE				*
;*							*
;*	OUTPUT		AL : ASCII CODE			*
;*							*
;********************************************************
GET_STRING	PROC	NEAR
		MOV	SI,[STRING_ADR]
		LODSB			; GET CHARACTER
		DEC	[STRING_CNT]	; STRING ADDRESS & COUNTER UP
		MOV	[STRING_ADR],SI	; SET STRING ADDRESS
		RET
GET_STRING	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	CONV_SEARCH			*
;*							*
;*	FUNCTION	SEARCH CHARACTER - STRING	*
;*							*
;*	INPUT		AL : ASCII	OR		*
;*			AX : FUNCTION CODE		*
;*							*
;*	OUTPUT		ZF : ON=FOUND,	OFF=NOT FOUND	*
;*			BX : STRING BLOCK ADDRESS	*
;*			CX : STRING BLOCK LENGTH	*
;*							*
;********************************************************
CONV_SEARCH	PROC	NEAR
		PUSH	DX
		MOV	BX,OFFSET STRING_TBL	; BX=TOP ADDRESS
		MOV	DX,BX
		ADD	DX,[STRING_TBL_LNG]	; DX=TALE ADDRESS
		XOR	CH,CH
CONV_SRC10:
		CMP	BX,DX
		JZ	CONV_SRC70
		MOV	CL,[BX]
;
		OR	AL,AL		; FUNCTION CODE ?
		JNZ	CONV_SRC30	; NO
;
		CMP	AX,[BX+1]	; SAME FUNCTION CODE ?
		JMP	SHORT	CONV_SRC50
CONV_SRC30:
		CMP	AL,[BX+1]	; SAME ASCII CODE ?
CONV_SRC50:
		JZ	CONV_SRC_RET
;
		ADD	BX,CX		; ID UP
		JMP	CONV_SRC10
;
CONV_SRC70:
		OR	BX,BX		; RESET ZF
;
CONV_SRC_RET:
		POP	DX
		RET
CONV_SEARCH	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	CON_FLUSH			*
;*							*
;*	FUNCTION	CONSOLE INPUT BUFFER CLEAR	*
;*							*
;*	INPUT		NONE				*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
CON_FLUSH	PROC	NEAR
		MOV	[READ_CHA],0	; CLEAR READ FINISH
		MOV	[STRING_CNT],0	; CLEAR READING STRING
CON_FLUSH20:
		MOV	AH,KB_FNC_RDND	; KB DATA NONE ?
		INT	KB_ROM
		JZ	CON_FLUSH50
;
		MOV	AH,KB_FNC_READ	; DATA GET
		INT	KB_ROM
		JMP	CON_FLUSH20
CON_FLUSH50:

		JMP	NORMAL_EXIT
;
CON_FLUSH	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	CON_WRITE			*
;*							*
;*	FUNCTION	WRITE MULTI CHARACTER TO CRT	*
;*							*
;*	INPUT		ESIDI	DATA STORE ADDRESS	*
;*			CX	DATA LENGTH		*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
CON_WRITE	PROC	NEAR
		JCXZ	CON_WRITE80	; OUTPUT CHARACTER NONE ?
CON_WRIT10:
		MOV	AL,ES:[DI]	; GET CHARACTER
		INC	DI
		CALL	CONOUT		; OUTPUT CHARACTER
		LOOP	CON_WRIT10
CON_WRITE80:
		JMP	NORMAL_EXIT
CON_WRITE	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	CONOUT				*
;*							*
;*	FUNCTION	OUTPUT ONE CHARACTER TO CRT	*
;*							*
;*	INPUT		AL : OUTPUT CHARACTER		*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
CONOUT		PROC	NEAR
		PUSH	AX		; SAVE ALL REGISTER
		PUSH	BX
		PUSH	CX
		PUSH	DX
		PUSH	SI
		PUSH	DI
		PUSH	ES
		PUSH	BP

		MOV	SI,SYSCOM
		MOV	ES,SI
	ASSUME	ES:SYSCOM
;
;*	DATA OUTPUT
;
		CALL	CON_BRANCH
;
		POP	BP		; ALL REGISTER RESTORE
		POP	ES
		POP	DI
		POP	SI
		POP	DX
		POP	CX
		POP	BX
		POP	AX
		RET
;
CONOUT		ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	CON_BRANCH			*
;*							*
;*	FUNCTION	BRANCH A MODULE CASE BY CASE	*
;*							*
;*			"ONE_WRITE" (DEFAULT)		*
;*			"ESC_ANSI_CHK"			*
;*			"ESC_PARA_CHK"			*
;*			"ESC_ASCII_CHK"		 	*
;*							*
;*	INPUT		NONE				*
;*							*
;*	OUTPUT		[SI]	BRANCH ADDRESS WHEN	*
;*				NEXT DATA OUTPUT	*
;*							*
;********************************************************
CON_BRANCH	PROC	NEAR
		MOV	SI,OFFSET JUMP_MODULE
		JMP	[SI]
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	ONE_WRITE			*
;*							*
;*	FUNCTION	DATA OUTPUT TO CRT		*
;*							*
;*	INPUT		AL : OUTPUT DATA		*
;*			SI : BRANCH ADDRESS		*
;*							*
;*	OUTPUT		SI : BRANCH ADDRESS		*
;*							*
;********************************************************
ONE_WRITE	LABEL	NEAR
		CMP	AL,$ESC		; ESC CODE ?
		JNZ	ONE_WRITE40
		MOV	WORD PTR [SI],OFFSET ESC_ANSI_CHK
					; SET MODULE ADDRESS FOR NEXT DATA
		RET
;
ONE_WRITE40:
		CALL	DATA_OUT	; DATA OUTPUT
ESC_SEQ_RESET:
		MOV	[JUMP_MODULE],OFFSET ONE_WRITE
					; SET MODULE ADDRESS FOR NEXT DATA
		RET
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	DATA_OUT			*
;*							*
;*	FUNCTION	A CHARACTER OUTPUT TO CRT	*
;*							*
;*	INPUT		AL : OUTPUT DATA		*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
DATA_OUT	PROC	NEAR
;
;*	CONTROL CHARACTER (CR,LF,BS,BELL)
;
		CMP	AL,BEL		; BELL CODE ?
		JZ	DATA_OUT15
		CMP	AL,LF		; LF CODE ?
		JZ	DATA_OUT10
		CMP	AL,BS		; BS CODE ?
		JZ	DATA_OUT10
		CMP	AL,CR		; CR CODE ?
		JNZ	DATA_OUT30
DATA_OUT10:
		AND	[WRAP_FLAG],NOT 02H
DATA_OUT15:
		CALL	TTY_OUT		; OUTPUT TO CRT
		JMP	SHORT	DATA_OUT_RET
;
;*	DATA OUTPUT (NORMAL CHARACTER)
;
DATA_OUT30:
		CMP	[WRAP_FLAG],03H	; NO WRAP AND END OF LINE ?
		JZ	DATA_OUT_RET

		MOV	BL,[CUR_ATTRIB]	; GET ATTRIBUTE
		TEST	[DEF_FLAG],0FFH	; COLOR IS DEFAULT ?
		JNZ	DATA_OUT42
		OR	BL,10000000B	;  (GREEN COLOR)
		MOV	CX,IO_SEG
		MOV	DS,CX
	ASSUME	DS:IO_SEG
		TEST	[MEM_SW3],40H
		PUSH	CS
		POP	DS
	ASSUME	DS:CODE
		JNZ	DATA_OUT42
		OR	BL,11100000B	;  (WHITE)
DATA_OUT42:
		CMP	[CRT_MODE],4	; GRAPHIC ?
		JB	DATA_OUT44
		MOV	CL,5
		SHR	BL,CL
DATA_OUT44:
		MOV	BH,[ACTIVE_PAGE]	; GET PAGE NUMBER
		MOV	CX,1		; CX=NUMBER OF CHARACTER
		MOV	AH,CRT_FNC_WRITECA
		INT	CRT_ROM		; WRITE CHARACTER AND ATTRIBUTRE
;
;*	CURSOL UP
;
		MOV	BL,[ACTIVE_PAGE]	; GET CURSOL POSITION
		MOV	BH,0
		SHL	BX,1
		MOV	DX,CURSOR_POSN[BX]
		INC	DL		; CURSOL UP
		CMP	DL,[CRT_COLS]	; END OF LINE ?
		JB	DATA_OUT80
		OR	[WRAP_FLAG],02H
		CMP	[WRAP_FLAG],03H	; NO WRAP ?
		JZ	DATA_OUT_RET
;
		MOV	DL,0		; NEXT LINE
		INC	DH
		CMP	DH,LINE_MAX	; END OF SCREEN ?
		JBE	DATA_OUT80
;

		MOV	AL,LF		; SCROLL UP
		CALL	TTY_OUT
		MOV	DX,(LINE_MAX SHL 8)
;
;*	CURSOL DISPLAY
;
DATA_OUT80:
		CALL	CURSOL_DISPLAY
;
;
;*	RETURN
;
DATA_OUT_RET:
		RET
DATA_OUT	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	TTY_OUT				*
;*							*
;*	FUNCTION	CONTROL CHARACTER OUTPUT	*
;*							*
;*	INPUT		CONTROL CHARACTER		*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
TTY_OUT		PROC	NEAR
		MOV	AH,CRT_FNC_TTY	; DIRECT OUTPUT
		INT	CRT_ROM
		RET
TTY_OUT		ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	CURSOL_DISPLAY			*
;*							*
;*	FUNCTION	OUTPUT CURSOL POSITION		*
;*							*
;*	INPUT		DX = CURSOL POSITION		*
;*				DL=COLUMN NUMBER	*
;*				DH=LINE   NUMBER	*
;*							*
;*	OUTPUT		NONE				*
;*							*
;*							*
;*	BREAK REG.	AX,BX,DX			*
;*							*
;********************************************************
CURSOL_DISPLAY	PROC	NEAR
		AND	[WRAP_FLAG],NOT 02H
		MOV	BH,[ACTIVE_PAGE]	; BH = PAGE NUMBER
		MOV	AH,CRT_FNC_CSRDSP	; CURSOL DISPLAY
		INT	CRT_ROM
		RET
CURSOL_DISPLAY	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	ESC_ANSI_CHK			*
;*							*
;*	FUNCTION	CHECK.ANSI TYPE ESC SEQUENCE	*
;*							*
;*	INPUT		AL : OUTPUT DATA		*
;*			SI : BRANCH ADDRESS		*
;*							*
;*	OUTPUT		SI : BRANCH ADDRESS		*
;*							*
;********************************************************
ESC_ANSI_CHK	LABEL	NEAR
		CMP	AL,'['		; ANSI TYPE ?
		JNZ	ESC_ANSI_40
		MOV	WORD PTR [SI],OFFSET ESC_PARA_CHK
					; SET MODULE ADDRESS FOR NEXT DATA
		XOR	AX,AX
		MOV	[START_CHA],AL	; RESET START CHARACTER IN ASCII
		MOV	[PARA_NUM],AL
		CALL	GET_PARA
		PUSH	CS
		POP	ES
		MOV	DI,BX
		MOV	CX,ESC_BUF_SIZE/2
		CLD
		REP	STOSW

		RET
ESC_ANSI_40:
		CMP	AL,80H		; CRT DUMP ?
		JNZ	ESC_ANSI_80
		MOV	WORD PTR [SI],OFFSET ESC_DUMP_CHK
		RET
ESC_ANSI_80:
		JMP	ONE_WRITE40
		PAGE
;********************************************************
;*							*
;*	MODULE_NAME	ESC_DUMP_CHK			*
;*	FUNCTION	CHECK CRT DUMP PARAMETER	*
;*							*
;*							*
;*	INPUT		AL : DUMP CODE (00H/01H)	*
;*							*
;********************************************************
ESC_DUMP_CHK	LABEL	NEAR
		CMP	AL,2		; PARAMETER ERROR ?
		JNC	ESC_DUMP_CHK40

		INT	CRTDUMP
ESC_DUMP_CHK40:
		JMP	ESC_SEQ_RESET

		PAGE
;********************************************************
;*							*
;*	MODULE_NAME	ESC_PARA_CHK			*
;*							*
;*	FUNCTION	CHECK PARAMETER OF ESC SEQUENCE *
;*							*
;*	INPUT		AL : DATA (ONE OF PARAMETER)	*
;*			SI : BRANCH ADDRESS		*
;*							*
;*	OUTPUT		SI : BRANCH ADDRESS		*
;*							*
;********************************************************
ESC_PARA_CHK	LABEL	NEAR
;
;*	NUMERIC PARAMETER END CHECK
;
		CMP	AL,';'
		JNZ	ESC_NUM_CHK	; GO NUMERIC CHARACTER CHECK

		INC	[PARA_NUM]	; PARAMETER NUMBER UP
		RET
;
;*	NUMERIC PARAMETER CHECK
;
ESC_NUM_CHK:
		CMP	AL,'0'		; '0'--'9' ?
		JB	ESC_SPC_CHK	; NO
		CMP	AL,'9'
		JA	ESC_SPC_CHK	; NO
;
		CALL	GET_PARA	; GET CURRENT PARAMETER STORE ADDRESS
;
;*	CONVERT TO BINARY AND SET
;
		SUB	AL,'0'
		MOV	AH,[BX]
		AAD
		MOV	[BX],AL
;
		RET
;
;*	SPECIAL CHARACTER CHECK
;
ESC_SPC_CHK:
		CMP	AL,'='
		JZ	ESC_SPC90	; GO RETURN
		CMP	AL,'?'
		JZ	ESC_SPC90	; GO RETURN
		CMP	AL,'>'
		JZ	ESC_SPC90	; GO RETURN
;
;*	ASCII PARAMETER START CHARACTER [',"] CHECK
;
		CMP	AL,'"'
		JZ	ESC_SPC60
		CMP	AL,"'"
		JNZ	ESC_END_CHK	; GO END CODE CHECK
ESC_SPC60:
		MOV	WORD PTR [SI],OFFSET ESC_ASCII_CHK
					; SET MODULE ADDRESS FOR NEXT DATA
		MOV	[START_CHA],AL	; SAVE START/END CODE
;
ESC_NOP_RET:
		RET
ESC_SPC90:
		MOV	[SR_MOD_CHA],AL
		JMP	ESC_NOP_RET
;********************************************************
;*							*
;*	MODULE NAME	ESC_ASCII_CHK			*
;*							*
;*	FUNCTION	SET ASCII STRING PARAMETER	*
;*							*
;*	INPUT		AL : DATA (ASCII PARAMETER)	*
;*			SI : BRANCH ADDRESS		*
;*							*
;*	OUTPUT		SI : BRANCH ADDRESS		*
;*							*
;********************************************************
ESC_ASCII_CHK:
;
;*	CHECK ASCII PARAMETER END
;
		CMP	AL,[START_CHA]	; ASCII PARAMETER END ?
		JNZ	ESC_ASCII40
;
		DEC	[PARA_NUM]
		MOV	[SI],OFFSET ESC_PARA_CHK
					; SET MODULE ADDRESS FOR NEXT DATA
		RET
;
;*	STORE ASCII PARAMETER
;
ESC_ASCII40:
		CALL	GET_PARA	; GET CURRENT PARAMETER STORE ADDRESS
		MOV	[BX],AL
		INC	[PARA_NUM]
					; SET MODULE ADDRESS FOR NEXT DATA
					; AND NEXT PARAMETER AREA CLEAR
		RET
;
;****************************************
;*	ESC SEQUENCE END CODE CHECK	*
;****************************************
ESC_END_CHK:
		CMP	[PARA_NUM],ESC_BUF_SIZE
		JNC	ESC_END90

;
;*	SEARCH END CODE TABLE
;
		MOV	BX,OFFSET ESC_TBL - 3
					; ESC SEQUENCE END CODE TABLE
ESC_END10:
		ADD	BX,3
		CMP	BYTE PTR [BX],0 ; TABLE END ? (INVALID CODE)
		JZ	ESC_END80	; GO DATA OUTPUT TO CRT
		CMP	[BX],AL		; SAME CHARACTER ?
		JNZ	ESC_END10	; NO
;
		MOV	AX,[BX+1]	; AX = BRANCH ADDRESS
;
;*	GET PARAMETER TO REG.
;
		MOV	BL,[ACTIVE_PAGE]	; GET CURSOL POSITION
		MOV	BH,0
		SHL	BX,1
		MOV	DX,CURSOR_POSN[BX]
		MOV	BX,OFFSET ESC_BUF
		MOV	CX,[BX]		; CX = FIRST AND SECOND PARAMETER
		JMP	AX		; BRANCH ROUTINE
ESC_END80:
		JMP	ONE_WRITE40
ESC_END90:
		JMP	ESC_SEQ_RESET
		PAGE
;********************************************************
;*							*
;*	FUNCTION	ANSI ESC SEQUENCE PROCESS	*
;*							*
;*	INPUT		BX : PARAMETER ADDRESS		*
;*			CL : FIRST  PARAMETER		*
;*			CH : SECOND PARAMETER		*
;*			DL : CURSOL POSITION (COLUMN)	*
;*			DH : CURSOL POSITION (LINE)	*
;*			SI : BRANCH ADDRESS FOR NEXT	*
;*				DATA			*
;*							*
;*	OUTPUT		NENE				*
;*							*
;*							*
;*							*
;********************************************************
;****************************************
;*	ESC SEQUENCE COMMON EXIT	*
;****************************************
;
;*	CURSOL SHIFT COMMON EXIT
;
CUR_DISP:
		CALL	CURSOL_DISPLAY
		JMP	ESC_SEQ_RESET	; ESC SEQUENCE FINISH
;****************************************
;*	ESC [ Pl;Pc H OR ESC [ Pl;Pc f	*
;*	[DIRECT CURSOL MOVE]		*
;*	INPUT	CL = LINE NUMBER	*
;*		CH = COLUMN NUMBER	
;*					*
;****************************************
ESC_CUP:
		OR	CL,CL		; OMIT ? (LINE)
		JZ	ESC_CUP10
		DEC	CL
ESC_CUP10:
		OR	CH,CH		; OMIT ? (COLUMN)
		JZ	ESC_CUP20
		DEC	CH
ESC_CUP20:
		MOV	DL,CH		; DL=COLUMN NUMBER
		MOV	DH,CL		; DH=LINE   NUMBER
ESC_CUP30:
		CMP	DL,[CRT_COLS]	; COLUMN OVER ?
		JB	ESC_CUP40
		MOV	DL,[CRT_COLS]
		DEC	DL
ESC_CUP40:
		CMP	DH,LINE_MAX	; LINE OVER ?
		JBE	ESC_CUP50
		MOV	DH,LINE_MAX
ESC_CUP50:
		JMP	CUR_DISP

;****************************************
;*	ESC [ p C			*
;*	(CURSOL FORWORD)		*
;*	INPUT	CL = FORWORD COLUMN	*
;*			NUMBER		*
;****************************************
ESC_CUF:
		OR	CL,CL		; OMIT ?
		JNZ	ESC_CUF20
		INC	CL
ESC_CUF20:
		ADD	DL,CL		; COLUMN UP
		JMP	ESC_CUP30

;****************************************
;*	ESC [ p D			*
;*	(CURSOL BACK)			*
;*	INPUT	CX = BACK COLUMN NUMBER *
;*					*
;****************************************
ESC_CUB:
		OR	CL,CL		; OMIT ?
		JNZ	ESC_CUB20
		INC	CL
ESC_CUB20:
		SUB	DL,CL		; COLUMN DOWN
		JNC	ESC_CUB40
		MOV	DL,0
ESC_CUB40:
		JMP	CUR_DISP
;****************************************
;*	ESC [ p A			*
;*	(CURSOL UP)			*
;*	INPUT	CX = UP LINE NUMBER	*
;****************************************
ESC_CUU:
		OR	CL,CL		; OMIT ?
		JNZ	ESC_CUU20
		INC	CL
ESC_CUU20:
		SUB	DH,CL		; LINE DOWN
		JNC	ESC_CUU40
		MOV	DH,0
ESC_CUU40:
		JMP	CUR_DISP
;****************************************
;*	ESC [ p B			*
;*	(CURSOL DOWN)			*
;*	INPUT	CX = DOWN LINE NUMBER	*
;****************************************
ESC_CUD:
		OR	CL,CL		; OMIT ?
		JNZ	ESC_CUD10
		INC	CL
ESC_CUD10:
		ADD	DH,CL		; LINE UP
		JMP	ESC_CUP30
;
;****************************************
;*	ESC [ s			 	*
;*	(CURSOL SAVE)			*
;*					*
;****************************************
ESC_PSCP:
		MOV	[SAVE_CL],DX
		JMP	CUR_DISP
;****************************************
;*	ESC [ u			 	*
;*	(CURSOL RESTORE)		*
;*					*
;****************************************
ESC_PRCP:
		MOV	DX,[SAVE_CL]
		JMP	CUR_DISP
;****************************************
;*	ESC [ PN;PN;.... m		*
;*	(SET ATTRIBUTE)		 	*
;*	INPUT	BX=PARAMETER ADDRESS	*
;****************************************
ESC_SGR:
		MOV	DL,0			; DL = DEFALT ATTRIBUTE
		MOV	DH,0			; DH = ATTRIBUTE MASK

		MOV	CL,[PARA_NUM]		; GET NUMBER OF PARAMETER
		MOV	CH,0
		INC	CX
ESC_SGR20:
		MOV	AL,[BX]			;
		CMP	AL,02H			; DEFALT ?
		JB	ESC_SGR70		; Y (NOP)

		MOV	SI,OFFSET ATTRIBUTE_TBL
ESC_SGR40:
		MOV	AH,[SI]
		CMP	AH,-1
		JZ	ESC_SGR90

		ADD	SI,3
		CMP	AL,AH
		JNZ	ESC_SGR40

		MOV	AL,[SI-2]	; DOUBLE COLOR ?
		AND	AL,DH
		JNZ	ESC_SGR90
;
		MOV	AX,[SI-2]	; GET ATTRIBUTE BIT AND MASK
		OR	DH,AL		; SET COLOR MASK
		OR	DL,AH		; ADD NEW ATTRIBUTE MASK
;
ESC_SGR60:
ESC_SGR70:
		INC	BX
		LOOP	ESC_SGR20
;
ESC_SGR80:
		MOV	[CUR_ATTRIB],DL	; SET ATTRIBUTE
		MOV	[DEF_FLAG],DH	; SET COLOR DEFAULT FLAG
		JMP	ESC_SEQ_RESET
ESC_SGR90:
		JMP	ESC_SEQ_RESET
;****************************************
;*					*
;*	MODULE NAME	CRT_ERASE	*
;*					*
;*	FUNCTION	A PART OF 	*
;*			SCREEN ERASE	*
;*					*
;*	INPUT		CL=MIN COLUMN NO*
;*			CH=MIN LINE   NO*
;*			DL=MAX COLUMN NO*
;*			DH=MAX LINE   NO*
;*					*
;*	OUTPUT		NONE		*
;*					*
;****************************************
CRT_ERASE:
		MOV	BH,[CUR_ATTRIB]
		AND	BH,0E0H		; RESET WITHOUT COLOR
		TEST	[DEF_FLAG],0FFH
		JNZ	CRT_ERS30
		OR	BH,10000000B
		MOV	AX,IO_SEG
		MOV	DS,AX
	ASSUME	DS:IO_SEG
		TEST	[MEM_SW3],40H
		PUSH	CS
		POP	DS
	ASSUME	DS:CODE
		JNZ	CRT_ERS30
		OR	BH,11100000B
CRT_ERS30:
		CMP	[CRT_MODE],4	; GRAFIC ?
		JB	CRT_ERS50
		MOV	BH,0
;
CRT_ERS50:
		MOV	AH,CRT_FNC_SCRUP
		MOV	AL,0		; SCREEN ERASE
		INT	CRT_ROM
		RET
;****************************************
;*	ESC [ Pn J			*
;*	(ERASE ALL SCREEN)		*
;*					*
;****************************************
ESC_ED:
;
;*	ERASE FROM CURSOL TO END OF SCREEN
;
		CMP	CL,0		; FROM CURSOL TO END ?
		JNZ	ESC_ED30
		PUSH	DX
ESC_ED10:
		MOV	CL,0		; (CH,CL)=START POINT OF LINE ON CURSOL
		MOV	CH,DH
		INC	CH
		MOV	DL,[CRT_COLS]	; (DH,DL)=SCREEN END POINT
		DEC	DL
		MOV	DH,LINE_MAX
		CMP	DH,CH		; END LINE OF SCREEN ?
		JB	ESC_ED20
;
		CALL	CRT_ERASE	; SCREEN ERASE
ESC_ED20:
		POP	DX
		JMP	SHORT ESC_EL10
;
;*	ERASE FROM START OF SCREEN TO CURSOL
;
ESC_ED30:
		CMP	CL,1		; FROM START TO CURSOL ?
		JNZ	ESC_ED60
ESC_ED40:
		PUSH	DX
		MOV	CX,0000H	; (CH,CL)=SCREEN START POINT
		MOV	DL,[CRT_COLS]	; (DH,DL)=END POINT OF LINE ON CURSOL
		DEC	DL
		DEC	DH
		JS	ESC_ED50
;
		CALL	CRT_ERASE	; SCREEN ERASE
ESC_ED50:
		POP	DX
		JMP	SHORT ESC_EL40
;
;*	ERASE ALL SCREEN
;
ESC_ED60:
		CMP	CL,2		; ALL ERASE ?
		JNZ	ESC_ED_RET
ESC_ED70:
		MOV	CX,0		; (CH,CL)=SCREEN START POINT
		MOV	DL,[CRT_COLS]	; (DH,DL)=SCREEN END   POINT
		DEC	DL
		MOV	DH,LINE_MAX
;
		CALL	CRT_ERASE	; SCREEN ERASE
		MOV	DX,0000H
		JMP	CUR_DISP
;
ESC_ED_RET:
		JMP	ESC_SEQ_RESET
;****************************************
;*	ESC [ Pn K		 	*
;*	(ERASE CURSOL TO END OF LINE)	*
;*					*
;****************************************
ESC_EL:
;
;*	ERASE FROM CURSOL TO END OF LINE
;
		CMP	CL,0		; FROM CURSOL TO END ?
		JNZ	ESC_EL30
ESC_EL10:
		MOV	CX,DX			; (CH,CL)=CURSOL POINT
		MOV	DL,[CRT_COLS]	; (DH,DL)=LINE END POINT
		DEC	DL
;
		CALL	CRT_ERASE	; SCREEN ERASE
		JMP	SHORT ESC_EL_RET
;
;*	ERASE START OF LINE TO CURSOL
;
ESC_EL30:
		CMP	CL,1		; FROM START TO CURSOL ?
		JNZ	ESC_EL60
ESC_EL40:
		MOV	CX,DX		; (CH,CL)=LINE START POINT
		MOV	CL,0		; (DH,DL)=CURSOL POINT
;
		CALL	CRT_ERASE	; SCREEN ERASE
		JMP	SHORT ESC_EL_RET
;
;*	ERASE A LINE
;
ESC_EL60:
		CMP	CL,2		; ALL ERASE ?
		JNZ	ESC_EL_RET
ESC_EL70:
		MOV	CH,DH		; (CH,CL)=LINE START POINT
		MOV	CL,0		; (DH,DL)=LINE END   POINT
		MOV	DL,[CRT_COLS]
		DEC	DL
;
		CALL	CRT_ERASE	; SCREEN ERASE
;
ESC_EL_RET:
		JMP	ESC_SEQ_RESET
;
;****************************************
;*					*
;*	MODULE NAME	BIN_DEC_CONV	*
;*					*
;*	FUNCTION	BINARY CONVER	*
;*			TO 2 ASCII	*
;*					*
;*	INPUT		AL : BINALY	*
;*					*
;*	OUTPUT		AL,AH : ASCII	*
;*					*
;****************************************
BIN_DEC_CONV:
		INC	AL
		AAM
		ADD	AX,'00'
		XCHG	AL,AH
		RET

;****************************************
;*	ESC [ 6n			*
;*	(GET CURSOL POSITION)		*
;*					*
;****************************************
ESC_DSR:
		 MOV	AL,DH		; MAKE CURSOL POSITION REPORT
		 CALL	BIN_DEC_CONV
		 MOV	WORD PTR [CPR_BUF+2],AX
		 MOV	AL,DL
		 CALL	BIN_DEC_CONV
		 MOV	WORD PTR [CPR_BUF+5],AX
;
		 MOV	[STRING_CNT],8	; SET CPR BY STRING
		 MOV	[STRING_ADR],OFFSET CPR_BUF
;****************************************
;*	ESC [ PL;PC R			*
;*	(CURSOL POSITION REPORT)	*
;*					*
;****************************************
ESC_CPR:
		JMP	ESC_SEQ_RESET
;****************************************
;*	ESC [ = PN l OR ESC [ ? 7l	*
;*	ESC [ > 5l			*
;*	(RESET MODE)			*
;*	INPUT	CL : PARAMETER VALUE	*
;****************************************
ESC_RM:
		MOV	DL,1		; WRAP RESET FLAG
		JMP	SHORT ESC_SR_COMMON
;****************************************
;*	ESC [ = PN h OR ESC [ ? 7h	*
;*	ESC [ > 5h			*
;*	(SET MODE)			*
;*	INPUT	CL : PARAMETER VALUE	*
;****************************************
ESC_SM:
		MOV	DL,0		; WRAP SET FLAG
;****************************************
;*	SET/RESET MODE COMMON MODULE	*
;*	INPUT	DL : WRAP FLAG		*
;*		CL : PARAMETER VALUE	*
;****************************************
ESC_SR_COMMON:
;
;*	CURSOL DISPLAY/ERASE
;
		MOV	AL,[SR_MOD_CHA]
		CMP	AL,'>'		; CURSOL DISPLAY/ERASE ?
		JNZ	ESC_SR30
		CMP	CL,5		; PARAMETER ERROR ?
		JNZ	ESC_SR80
;
		PUSH	DX
		MOV	AH,CRT_FNC_GETCSR
		INT	CRT_ROM		; GET CURSOL TYPE
		POP	AX
		AND	CH,07FH
		CMP	AL,0		; SET CURSOL ERASE ?
		JZ	ESC_SR20
		OR	CH,80H
ESC_SR20:
		MOV	AH,CRT_FNC_SETCSR
		INT	CRT_ROM		; SET CURSOL TYPE
		JMP	SHORT ESC_SR_RET
;
;*	SET/RESET AUTO FEED FLAG
;
ESC_SR30:
		CMP	AL,'?'		; AUTO FEED ?
		JNZ	ESC_SR50
		CMP	CL,7		; PARAMETER ERROR ?
		JNZ	ESC_SR80
ESC_SR40:
		AND	[WRAP_FLAG],NOT 01H
		OR	[WRAP_FLAG],DL	; WRAP/AUTO FEED FLAG
		JMP	SHORT ESC_SR_RET
;
;*	SET CRT MODE
;
ESC_SR50:
		CMP	AL,'='		; CRT MODE SET
		JNZ	ESC_SR80
		CMP	CL,7
		JZ	ESC_SR40	; AUTO FEED ?
		JA	ESC_SR80	; PARAMETER ERROR ?
;
		MOV	AL,CL
		MOV	AH,CRT_FNC_SETMOD
					; SET SCREEN MODE
		INT	CRT_ROM
;
ESC_SR80:
ESC_SR_RET:
		MOV	[SR_MOD_CHA],0
		JMP	ESC_SEQ_RESET	; ESC SEQUENCE RESET
;****************************************
;*	ESC [ Pn;Pn... p		*
;*	(SET CHANGE STRING)		*
;*					*
;*					*
;****************************************
ESC_STRING:
		PUSH	CS
		POP	ES
		XOR	DX,DX
		XCHG	[PARA_NUM],DL	; GET NUMBER OF PARAMETER
		INC	DX
		INC	DX		; DE = STRING ID LENGTH
;
		CALL	GET_PARA	; GET PARAMETER TOP ADDRESS
		MOV	AX,[BX]		; AL=ASCII CODE OR AX=FUNCTION CODE
		CALL	CONV_SEARCH	; STRING ID SEARCH
		JNZ	ESC_STRING40	; NOT FOUND ?
;
;*	DELETE STRING ID FROM STRING TABLE
;
		SUB	[STRING_TBL_LNG],CX
					; TABLE LENGTH DOWN
		MOV	DI,BX
		MOV	SI,BX		; DI = CURRENT ID ADDRESS
		ADD	SI,CX		; SI = NEXT ID ADDRESS
		MOV	CX,OFFSET STRING_FIN
		SUB	CX,SI		; CX = REMAIN LENGTH OF TABLE
		CLD
		REPZ	MOVSB
ESC_STRING40:
		MOV	DI,OFFSET STRING_TBL
		ADD	DI,[STRING_TBL_LNG]
		CALL	GET_PARA	; GET PARAMETER TOP ADDRESS
		MOV	AH,3
		CMP	BYTE PTR [BX],0	; FUNCTION CODE ?
		JNZ	ESC_STRING50
		INC	AH
ESC_STRING50:
		CMP	DL,AH		; STRING NONE ?
		JB	ESC_STRING60
;
		MOV	CX,DX
		ADD	DX,[STRING_TBL_LNG]
		CMP	DX,BUF_SIZ		; BUFFER OVER ?
		JG	ESC_STRING60
		MOV	[STRING_TBL_LNG],DX
		MOV	AL,CL
		STOSB
		MOV	SI,BX
		DEC	CX
		REP	MOVSB
ESC_STRING60:
		MOV	AL,0
		STOSB
		JMP	ESC_SEQ_RESET	; RESET ESC SEQUENCE
;****************************************
;*					*
;*	MODULE NAME	GET_PARA	*
;*					*
;*	FUNCTION	GET CURRENT	*
;*			PARAMETER ADDRES*
;*					*
;*	INPUT		NONE		*
;*					*
;*	OUTPUT		BX : PARAMETER	*
;*				ADDRESS	*
;*					*
;****************************************
GET_PARA:
		MOV	BL,[PARA_NUM]
		MOV	BH,0
		CMP	BX,ESC_BUF_SIZE
		JB	GET_PARA40
		MOV	BX,ESC_BUF_SIZE - 1
GET_PARA40:
		ADD	BX,OFFSET ESC_BUF

		RET
;
CON_BRANCH	ENDP
		PAGE
;********************************************************
;*							*
;*	CHARACTER - STRING TABLE			*
;*							*
;*		IDENT STRUCTER				*
;*		+-------------------------------+	*
;*		! IDENT LENGTH		 	!	*
;*		+-------------------------------+	*
;*		! CHARACTER CODE		!	*
;*		! (ASCII=1BYTE,FUNCTION=2BYTE)	!	*
;*		+-------------------------------+	*
;*		! CHANGE STRING			!	*
;*		+-------------------------------+	*
;*							*
;*	REMARK : TABLE SIZE IN "STRING_TBL_LNG"		*
;*							*
;*							*
;*							*
;********************************************************
STRING_TBL	LABEL	BYTE
		DB	4,0, 02H,00H		; CNTL+@ ---> NULL
		DB	4,0, 60H,13H		; BREAK OR SHIFT+BREAK ---> CNTL+S
		DB	5,0, 62H,$ESC,'S'	; PF1 ---> C1
		DB	5,0, 63H,$ESC,'T'	; PF2 ---> CM
		DB	5,0, 64H,$ESC,'U'	; PF3 ---> CT
		DB	5,0, 65H,$ESC,'V'	; PF4 ---> S1
		DB	5,0, 66H,$ESC,'W'	; PF5 ---> SM
		DB	5,0, 67H,$ESC,'E'	; PF6 ---> ST
		DB	5,0, 68H,$ESC,'P'	; PF7 ---> QI
		DB	5,0, 69H,$ESC,'Q'	; PF8 ---> INS
		DB	5,0, 6AH,$ESC,'J'	; PF9 ---> NL
		DB	4,0,0BAH,10H		; CNTL+PRINT ---> CNTL+P
STRING_SIZ	EQU	$ - STRING_TBL
ESC_SIZ		EQU	BUF_SIZ - STRING_SIZ
		DB	ESC_SIZ DUP (0)
STRING_FIN	LABEL	BYTE
ESC_BUF		LABEL	BYTE
		DB	ESC_BUF_SIZE DUP (0)	; ESC SEQUENCE PARAMETER BUFFER
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	CON_INIT			*
;*							*
;*	FUNCTION	INITIARIZE CONSOL DRIVER	*
;*							*
;*	INPUT		NONE				*
;*							*
;*	OUTPUT		NONE				*
;*							*
;*							*
;*							*
;********************************************************
CON_INIT	PROC	NEAR
;
;*	SET INITIAL VALUE TO WORK AREA
;
		MOV	AX,IO_SEG
		MOV	DS,AX
	ASSUME	DS:IO_SEG
		LDS	BX,[CON_WORK]
		MOV	WORD PTR [BX+0],OFFSET REAS_CONF
		MOV	WORD PTR [BX+2],CS

;
;*	SET ENTRY POINT OF INTERRUPT VECTOR
;
		MOV	AX,SEG INT_VECTOR
		MOV	DS,AX
	ASSUME	DS:INT_VECTOR
		MOV	WORD PTR [INT6_VECTOR+0],OFFSET INT6_PROC
		MOV	WORD PTR [INT6_VECTOR+2],CS
		MOV	WORD PTR [INT29_VECTOR+0],OFFSET INT29_PROC
		MOV	WORD PTR [INT29_VECTOR+2],CS
;
;*	SET DRIVER END ADDRESS
;
		LDS	BX,CS:[PTRSAV]
		MOV	WORD PTR [BX+TRANS+0],OFFSET CON_INIT
		MOV	WORD PTR [BX+TRANS+2],CS
		JMP	NORMAL_EXIT
CON_INIT	ENDP
;
;****************************************
;*	PROGRAM END			*
;****************************************
CODE		ENDS
		END	START_PROGRAM
*

P

	