	PAGE	58,132
	TITLE	'A1 ROMINIT'
;----------------------------------------------------------------
;
; HISTORY :
;
;  11-17-1983 : SET CRT TYPE (80/88) AND FONT (7X11 OR 6X7)
;  11-18-1983 : FIX MASTER PIC MASK BUG.
;  11-21-1983 : OFF INTERVAL TIMER'S MASK (MASTER PIC)
;  11-23-1983 : ADD KB I/F (8251) INITIALIZATION
;  12-08-1983 : SET RS232C H/W INTERRUPT VECTOR
;  12-09-1983 : RS232C INT. MASK OFF FOR PIC (8259)
;  02-27-1984 : DELETE --- INITIALIZE CRTROM-WORK AREA
;  03-20-1984 : Add sound off sequence (required from GW-BASIC)
;  03-26-1984 : Add setting up FONT_TBL_PTR (required from UNIX)
;
;----------------------------------------------------------------
	INCLUDE	B:EQCOM.LIB
	INCLUDE	B:SYSCOM.LIB
;
;---------------------------------------------------------------------
;
;	ROM_INIT : DO THE INITIALIZATION FOR ROM BIOS.
;
;	(1) FOR KB BIOS
;		CLEAR WORKAREAS, INIT. FIFO BUFFER.
;	(2) SET INT. VECTORS
;		MOVE INT. VECTORS TABLE TO THE 8086 INT. AREA
;	(3) OPEN INT. MASKS (8259)
;		OPEN THESE :
;		TIMER, KB, CRT, RS232C, PR, 5FD, 5HD, 8087
;
;---------------------------------------------------------------------
;
PAGE
;--------------------------------------
;
;	EQUATES
;
;--------------------------------------
;
;*** NOTE : 8259 MASK (0 = MASK RESET, MEANS ENABLE INT.)
;
MASTER_8259_PATTERN	EQU	01111001B	; FOR CRT & KB

;;; RS232C IS OFF AT INIT. (WILL BE OPENED/CLOSED BY AUXROM)
;;; ---------------- 12-09-1983 (C) -------------------------------

;;; INTERVAL TIMER IS OFF, AT INIT. (WILL BE OPEN ON CALLING
;;; ROM BIOS FROM AP.) --------------- 11-21-1983 (C)

SLAVE_8259_PATTERN	EQU	10111000B	; FOR 8087, 5FD,
						; 5HD & PRINTER.
;
; FOR INT. VECTOR TABLE PROC.
;
INT_5H_VECT	EQU	5*4		; ABS. ADDR. FOR INT 5H
					; TABLE STARTS FROM HERE
INT_5_THRU_1FH	EQU	(32-5)*2	; LENGTH OF TABLE
;
;
;--------------------------------------
;
;	PUBLIC/EXTERN
;
;--------------------------------------
;
	EXTRN	BOOT_START :NEAR	; START BOOT AFTER THIS PROC.
	EXTRN	HARD_COPY  :NEAR	; HARD COPY ROUTINE ENTRY
	EXTRN	TIMER_INT  :NEAR	; TIMER    INT. PROC.
	EXTRN	KB_INT     :NEAR	; KEYBOARD INT. PROC.
	EXTRN	RS232C_INT :NEAR	; RS232C   INT. PROC. ---- 12-08-1983 (A) -----------
	EXTRN	KEYBOARD_IO:NEAR	; KEYBOARD BIOS
	EXTRN	CRT_IO     :NEAR	; CRT      BIOS
	EXTRN	RS232C_IO  :NEAR	; RS232C   BIOS
	EXTRN	PRINTER_IO :NEAR	; PRINTER  BIOS
	EXTRN	TIMER_IO   :NEAR	; TIMER    BIOS
	EXTRN	DISK_IO    :NEAR	; DISK     BIOS
	EXTRN	MDXI1      :NEAR	; EOI PROC. IN ITF.
;------------------ 03-26-1984 (I) ------------------------
	EXTRN	FONT_88    :BYTE	; FONT TABLE FOR 88 CRT
;----------------------------------------------------------
;
;
	PUBLIC	ROM_INIT		; JMPED FROM ITF.
PAGE
;
;--------------------------------------
;
;	CODE SEGMENT
;
;--------------------------------------
;
ROM	SEGMENT	WORD PUBLIC
	ASSUME	CS:ROM,DS:SYSCOM,ES:SYSCOM,SS:SYSCOM
;
;----------------------------------------------------------------
;
;	THESE ARE THE VECTORS WHICH ARE MOVED INTO 8086
;	INTERRUPT AREA.
;
;----------------------------------------------------------------
;
;;;;;;;;   INT 0H -- INT 4H ARE SET BY ITF.
;

INT_VECTOR	LABEL	WORD

	DW	OFFSET HARD_COPY	; # 5	HARD COPY ENTRY
	DW	ROM

	DW	OFFSET UN_USED		; # 6	BREAK KEY ENTRY (DUMMY)
	DW	ROM

	DW	OFFSET UN_USED		; # 7	UNUSED VECTOR
	DW	ROM

	DW	OFFSET TIMER_INT	; # 8	TIMER INT. PROC.
	DW	ROM

	DW	OFFSET KB_INT		; # 9	KEYBOARD INT.
	DW	ROM

	DW	OFFSET MDXI1		; # A	UNUSED VECTOR
	DW	ROM			; (SEE NOTE BELOW)
;------------------------------------------------------------
; THIS VECTOR IS USED FOR CRT VSYNC H/W INT.
; BECAUSE THIS INT. IS USED FREELY BY SEVERAL USERS,
; DEFAULT VALUE POINTS MERE EOI ROUTINE.
; USER WHO WANT TO USE THIS, MUST SAVE CURRENT VECTOR VALUES
; BEFORE HE USE IT, AND RECOVER AFTER PROCESSING.
; (FOR EXAMPLE, CRT ROM BIOS USE THIS VECTOR IN THE MANNER
;  DESCRIBED ABOVE. SEE IT.)
;-------------------------------------------------------------

	DW	OFFSET MDXI1  		; # B	UNUSED VECTOR
	DW	ROM

	DW	OFFSET RS232C_INT  	; # C	(RS232C H/W) ----- 12-08-1983 (C) -------
	DW	ROM

	DW	OFFSET MDXI1  		; # D	UNUSED VECTOR
	DW	ROM

	DW	OFFSET MDXI1  		; # E	UNUSED VECTOR
	DW	ROM

	DW	OFFSET MDXI1  		; # F	UNUSED VECTOR
	DW	ROM

	DW	OFFSET MDXI1  		; #10	UNUSED VECTOR
	DW	ROM

	DW	OFFSET MDXI1  		; #11	5HD INT. (DUMMY)
	DW	ROM

	DW	OFFSET MDXI1   		; #12	5FD INT. (DUMMY)
	DW	ROM

;
;---- 5FD, 5HD INT. VECTORS WILL BE SET AT BOOTROM.
;

	DW	OFFSET MDXI1  		; #13	UNUSED VECTOR
	DW	ROM

	DW	OFFSET MDXI1  		; #14	UNUSED VECTOR
	DW	ROM

	DW	OFFSET MDXI1  		; #15	UNUSED VECTOR
	DW	ROM

	DW	OFFSET MDXI1  		; #16	UNUSED VECTOR
	DW	ROM

	DW	OFFSET MDXI1  		; #17	UNUSED VECTOR
	DW	ROM

	DW	OFFSET KEYBOARD_IO	; #18	KEYBOARD BIOS
	DW	ROM

	DW	OFFSET CRT_IO		; #19	CRT      BIOS
	DW	ROM

	DW	OFFSET RS232C_IO	; #1A	RS232C   BIOS
	DW	ROM

	DW	OFFSET PRINTER_IO	; #1B	PRINTER  BIOS
	DW	ROM

	DW	OFFSET TIMER_IO		; #1C	TIMER    BIOS
	DW	ROM

	DW	OFFSET DISK_IO		; #1D	DISK     BIOS
	DW	ROM

	DW	OFFSET UN_USED		; #1E	UNUSED VECTOR
	DW	ROM

	DW	OFFSET UN_USED		; #1F	UNUSED VECTOR
	DW	ROM
;
;-----------------------------------------
;
;	FOR UNUSED VECTORS
;
;-----------------------------------------
;
UN_USED:
	IRET		; DUMMY RETURN
PAGE
;
;;;----------------------------------------------------------
;;;
;;;	MAIN PROCEDURE OF ROM_INIT
;;;
;;;----------------------------------------------------------
;
;----------------------
;
;  FOR KB BIOS
;
;----------------------
;
ROM_INIT:
;
;  CLEAR WORKAREAS
;
	MOV	AL        ,0	; CLEAR TO 0
	MOV	KB_FLAG   ,AL	; KB STATUS AREA
	MOV	KB_FLAG1  ,AL	; KB STATUS WORKAREA
	MOV	ALT_INPUT ,AL	; ALT + 10 KEY DATA AREA
	MOV	KB_RETRY  ,AL	; KB RETRY COUNTER
;
;  INIT. FIFO BUFFER
;
	MOV	DS:BUFFER_HEAD ,OFFSET KB_BUFFER	; SET HEAD
	MOV	DS:BUFFER_TAIL ,OFFSET KB_BUFFER	; SET TAIL
;
;  INIT. KB I/F (8251)
;
;-------------------------------------------------------
;  THIS ROUTINE IS EXTRACTED FROM ITFROM (11-23-1983)
;-------------------------------------------------------
;
	MOV	AL,02H
	OUT	KB_CMD,AL
	MOV	CX,4
	LOOP	$			;WAIT FOR TIMING ADJUST
	MOV	AL,40H
	OUT	KB_CMD,AL	;IR:=1
	MOV	CX,4
	LOOP	$			;WAIT FOR TIMING ADJUST
	MOV	AL,5EH
	OUT	KB_MOD,AL	;SET MODE
	MOV	CX,4
	LOOP	$			;WAIT FOR TIMING ADJUST
	MOV	AL,3AH
	OUT	KB_CMD,AL	;RST:=1
	MOV	CX,0060H	;WAIT 160 MICROSEC
	LOOP	$
	MOV	AL,32H
	OUT	KB_CMD,AL	;RST:=0
	MOV	CX,0040H	;WAIT 107 MICROSEC
	LOOP	$
	MOV	AL,16H
	OUT	KB_CMD,AL	;RXE:=1
;
;---------------------------
;
;	INT. VECTORS
;
;---------------------------
;
	XOR	AX,AX
	MOV	ES,AX		; SET ES = 0
;
	PUSH	CS
	POP	DS		; SET DS = CS (TABLE IS IN ROM)
;
	CLD			; DIRECTION = FORWARD FOR COPY
	MOV	SI,OFFSET INT_VECTOR	; TABLE ADDR.
	MOV	DI,INT_5H_VECT		; INT 5H ADDR.
	MOV	CX,INT_5_THRU_1FH	; SET INT 5H THROUGH 1FH
REP	MOVSW			; COPY WHOLE TABLE
;
;---------------------------
;
;	INT. MASKS
;	(8259)
;
;---------------------------
;
	MOV	AL,MASTER_8259_PATTERN
	OUT	INTM_O1,AL	; SET FOR MASTER 8259
	MOV	AL, SLAVE_8259_PATTERN
	OUT	INTS_O1,AL	; SET FOR SLAVE  8259
;
;------------------------------------------------------------------
;
;	Sound board off sequence (03-20-1984)
;
;------------------------------------------------------------------
;
	MOV	DX,02B8H	; Gate control & Speaker data
	XOR	AL,AL
	OUT	DX,AL
;
;-------------------------------------------------------------------
;	Setting up FONT_TBL_PTR (added 03-26-1984)
;-------------------------------------------------------------------
;
	XOR	AX,AX		; NOTE DS = F800 NOW !
	MOV	DS,AX		; ESTABLISH DATA ADDRESSING
;
	MOV	AX,OFFSET FONT_88	; get offset
	MOV	FONT_TBL_PTR,AX
	MOV	WORD PTR (FONT_TBL_PTR + 2),0F800H	; rom segment
;
	JMP	BOOT_START	; GOTO BOOT PROCEDURE
;
ROM	ENDS
	END
	

