;
; TEST FILE FOR 6800 CROSS-ASSEMBLER
;
; File created 4-Dec-79 by J. Zurkow
;
; Modified  5-Dec-79  JLZ
;	   18-Jan-79  JLZ
;	    9-Nov-80  JLZ  Added 6801 ops.
;

	ORG	100H
	WIDTH	80

SMAL	EQU	25H
BIG	EQU	4455H


;
; Primary Memory Reference Instructions
;
; Modes available:  immediate
;		    zero-page
;		    extended
;		    indexed



	ADCA	#5
	ADCA	SMAL
	ADCA	BIG
	ADCA	SMAL,X

	ADCB	#5
	ADCB	SMAL
	ADCB	BIG
	ADCB	SMAL,X

	ADDA	#5
	ADDA	SMAL
	ADDA	BIG
	ADDA	SMAL,X

	ADDB	#5
	ADDB	SMAL
	ADDB	BIG
	ADDB	SMAL,X

	ADDD	#BIG		; 6801/6803 only
	ADDD	SMAL
	ADDD	BIG
	ADDD	SMAL,X

	ANDA	#5
	ANDA	SMAL
	ANDA	BIG
	ANDA	SMAL,X

	ANDB	#5
	ANDB	SMAL
	ANDB	BIG
	ANDB	SMAL,X

	BITA	#5
	BITA	SMAL
	BITA	BIG
	BITA	SMAL,X

	BITB	#5
	BITB	SMAL
	BITB	BIG
	BITB	SMAL,X

	CMPA	#5
	CMPA	SMAL
	CMPA	BIG
	CMPA	SMAL,X

	CMPB	#5
	CMPB	SMAL
	CMPB	BIG
	CMPB	SMAL,X

	CPX	#5
	CPX	SMAL
	CPX	BIG
	CPX	SMAL,X

	EORA	#5
	EORA	SMAL
	EORA	BIG
	EORA	SMAL,X

	EORB	#5
	EORB	SMAL
	EORB	BIG
	EORB	SMAL,X

	LDAA	#5
	LDAA	SMAL
	LDAA	BIG
	LDAA	SMAL,X

	LDAB	#5
	LDAB	SMAL
	LDAB	BIG
	LDAB	SMAL,X

	LDD	#BIG		; 6801/6803 only
	LDD	SMAL
	LDD	BIG
	LDD	SMAL,X

	LDS	#5
	LDS	SMAL
	LDS	BIG
	LDS	SMAL,X

	LDX	#5
	LDX	SMAL
	LDX	BIG
	LDX	SMAL,X

	ORAA	#5
	ORAA	SMAL
	ORAA	BIG
	ORAA	SMAL,X

	ORAB	#5
	ORAB	SMAL
	ORAB	BIG
	ORAB	SMAL,X

	SBCA	#5
	SBCA	SMAL
	SBCA	BIG
	SBCA	SMAL,X
	
	SBCB	#5
	SBCB	SMAL
	SBCB	BIG
	SBCB	SMAL,X

	SUBA	#5
	SUBA	SMAL
	SUBA	BIG
	SUBA	SMAL,X

	SUBB	#5
	SUBB	SMAL
	SUBB	BIG
	SUBB	SMAL,X

	SUBD	#BIG		; 6801/6803 only
	SUBD	SMAL
	SUBD	BIG
	SUBD	SMAL,X


;
; STORE Instructions
;
; Modes available:  zero-page
;		    extended
;		    indexed


	STAA	SMAL
	STAA	BIG
	STAA	SMAL,X

	STAB	SMAL
	STAB	BIG
	STAB	SMAL,X

	STD	SMAL		; 6801/6803 only
	STD	BIG
	STD	SMAL,X

	STS	SMAL
	STS	BIG
	STS	SMAL,X

	STX	SMAL
	STX	BIG
	STX	SMAL,X


;
; Secondary Memory Reference Instructions
;
; Modes available: extended
;		   indexed
;

	ASL	BIG
	ASL	SMAL,X

	ASR	BIG
	ASR	SMAL,X

	CLR	BIG
	CLR	SMAL,X

	COM	BIG
	COM	SMAL,X

	DEC	BIG
	DEC	SMAL,X
	
	INC	BIG
	INC	SMAL,X

	JMP	BIG
	JMP	SMAL,X

	JSR	BIG
	JSR	SMAL,X
	JSR	SMAL		; Direct mode- 6801/6803 only

	LSL	BIG		; Synonym for ASL
	LSL	SMAL,X

	LSR	BIG
	LSR	SMAL,X

	NEG	BIG
	NEG	SMAL,X

	ROL	BIG
	ROL	SMAL,X

	ROR	BIG
	ROR	SMAL,X

	TST	BIG
	TST	SMAL,X





;
; Branch Instructions
;

	BCC	$
	BCS	$
	BEQ	$
	BGE	$
	BGT	$
	BHI	$
	BHS	$		; Synonym for BCC
	BLE	$
	BLO	$		; Synonym for BCS
	BLS	$
	BLT	$
	BMI	$
	BNE	$
	BPL	$
	BRA	$
	BRN	$		; 6801/6803 only
	BSR	$
	BVC	$
	BVS	$



;
; Instructions With Implied Operands
;

	ABA
	ABX			; 6801/6803 only
	ASLA
	ASLB
	ASLD			; 6801/6803 only
	ASRA
	ASRB

	CBA
	CLC
	CLI
	CLRA
	CLRB
	CLV
	COMA
	COMB

	DAA
	DECA
	DECB
	DES
	DEX

	INCA
	INCB
	INS
	INX

	LSLA			; Synonym for ASLA
	LSLB			; Synonym for ASLB
	LSLD			; 6801/6803 only (synonym ASLD)
	LSRA
	LSRB
	LSRD			; 6801/6803 only

	MUL			; 6801/6803 only

	NEGA
	NEGB
	NOP

	PSHA
	PSHB
	PSHX			; 6801/6803 only
	PULA
	PULB
	PULX			; 6801/6803 only

	ROLA
	ROLB
	RORA
	RORB
	RTI
	RTS

	SBA
	SEC
	SEI
	SEV
	SWI

	TAB
	TAP
	TBA
	TPA
	TSTA
	TSTB
	TSX
	TXS

	WAI







;
; Miscellaneous Test Cases
;

	ADCA	SMAL2	; Should assemble as extended mode

	ADCA	SMAL,Y	; Should give syntax error- illegal index specifier

	ADCA	#BIG	; Should give range error

	ADCA	BIG,X	; Should give range error

	ADCA	0,X	; Should be OK

	ADCA	255,X	; Should be OK

	ADCA	-1,X	; Should give range error

	STAA	#5	; Should give syntax error- immediate not allowed

	ASR	SMAL	; Should assemble as extended despite magnitude

	ASR	BIG,X	; Should give range error

	ASR	SMAL,Y	; Should give syntax error

	ASR	SMAL2	; Make sure no problems with forward references

	BRA	$-126	; Should be OK

	BRA	$-127	; Should give range error

	BRA	$+129	; Should be OK

	BRA	$+130	; Should give range error



;
; SMAL2 is not defined until the end of pass 1, so references to it
; should result in use of extended mode even if zero-page mode is available.
;

SMAL2	EQU	7

	END

