	PAGE	58,132
	TITLE	OEMFOR
	.LFCOND
;****************************************************************
;*
;*	OEMFOR
;*
;*		OEM module for format
;*
;****************************************************************
;
;06/05/1984 remove drive SENSE logic
;08/20/1984 change 2D/2DD sense
;	    dynamic file allocation unit for HD
;
;

DSKIO		EQU	1DH	; FD INT. VECTOR


CODE	SEGMENT WORD PUBLIC 'CODE'

	ASSUME	CS:CODE, DS:CODE, ES:CODE

	PUBLIC	FATID, STARTSECTOR, SWITCHLIST, FREESPACE
	PUBLIC	HARDFLAG, FATSPACE

	PUBLIC	INIT, DISKFORMAT, BADSECTOR, WRTFAT, DONE

	EXTRN	SWITCHMAP:WORD, DRIVE:BYTE
	EXTRN	INVPAR:NEAR

	PAGE

SWS		EQU	 1			;SW /S
SWV		EQU	 2			;   /V
SWO		EQU	 4			;   /O
SWC		EQU	 8			;   /C
SW8		EQU	16			;   /8
SW1		EQU	32			;   /1


BPB_52DD8:
	DW	512			;SECTOR LENGTH
	DB	2			;SEC / ALLOC
	DW	1			;RES SEC
	DB	2			;FATS
	DW	112			;DIR
	DW	8*2*80			;SEC / VOL
	DB	0FBH			;FAT ID
	DW	2			;SEC / FAT
	DW	8			;SEC / TRK
	DW	2			;HEADS

BPB_52DD9:
	DW	512			;SEC LENGTH
	DB	2			;SEC / ALLOC
	DW	1			;RES SEC
	DB	2			;FATS
	DW	112			;DIR
	DW	9*2*80			;SEC / VOL
	DB	0F9H			;FAT ID
	DW	3			;SEC / FAT
	DW	9			;SEC / TRK
	DW	2			;HEADS

BPB_52D8:
	DW	512			;SECTOR LENGTH
	DB	2			;SEC / ALLOC
	DW	1			;RES SEC
	DB	2			;FATS
	DW	112			;DIR
	DW	8*2*40			;SEC / VOL
	DB	0FFH			;FAT ID
	DW	1			;SEC / FAT
	DW	8			;SEC / TRK
	DW	2			;HEADS

BPB_52D9:
	DW	512			;SEC LENGTH
	DB	2			;SEC / ALLOC
	DW	1			;RES SEC
	DB	2			;FATS
	DW	112			;DIR
	DW	9*2*40			;SEC / VOL
	DB	0FDH			;FAT ID
	DW	2			;SEC / FAT
	DW	9			;SEC / TRK
	DW	2			;HEADS

BPB_51D8:
	DW	512
	DB	1
	DW	1
	DB	2
	DW	64
	DW	8*40
	DB	0FEH
	DW	1
	DW	8
	DW	1

BPB_51D9:
	DW	512
	DB	1
	DW	1
	DB	2
	DW	64
	DW	9*40
	DB	0FCH
	DW	2
	DW	9
	DW	1

	PAGE
;================================================================
;
;	FD PART
;
;================================================================
;
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%
;%	INIT
;%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
INIT:
	MOV	AL,DRIVE		;GET TARGET DRIVE
	CMP	AL,2			; HD ?
	JC	INIT1
;-----------------------------------------check ROM version----------------
	PUSH	ES
	MOV	AX,0FFFFH
	MOV	ES,AX
	CMP	BYTE PTR ES:[0DH],5
	POP	ES
	JNC	INIT0
	MOV	DX,OFFSET INV_ROM
	JMP	INIT_ERR
INV_ROM	DB	0DH,0AH,'Invalid ROM version.',0DH,0AH,'$'
INIT0:
;------------------------------------------------------------------------
	JMP	HD_INIT
INIT1:
;-----------------------------------------------06/05/1984,08/20/1984--------

PORT_A		equ	31h

		mov	al,drive
		mov	bx,seg dsk_ptr
		mov	es,bx
		mov	bx,offset dsk_ptr
		les	bx,dword ptr es:[bx]
		cmp	byte ptr es:[bx-1],0	; check single drive
		jne	init11
		mov	al,0
init11:
		push	ds
		pop	es
		cmp	al,0
		mov	ah,0001b		; check SW1-1 : drive A:
		je	init12
		mov	ah,0010b		; check SW1-2 : drive B:
init12:
		in	al,PORT_A
		test	al,ah
		mov	al,drive
		jz	not_ddd
		or	al,40h
not_ddd:

;	MOV	AL,DRIVE
;	MOV	BX,SEG DSK_PTR
;	MOV	ES,BX
;	MOV	BX,OFFSET DSK_PTR
;	LES	BX,DWORD PTR ES:[BX]
;	MOV	AH,40
;	MUL	AH
;	ADD	BX,AX
;	MOV	AL,BYTE PTR ES:[BX+2]
;	PUSH	DS
;	POP	ES
;;
;;	PUSH	DS
;;	POP	ES
;;	MOV	AH,04H			; SENSE
;;	INT	DSKIO
;;	JC	DRV_ERRRET2
;;	TEST	AH,00000001B
;;	MOV	AL,DRIVE
;;	JZ	NOT_DDD
;;	OR	AL,40H
;;NOT_DDD:
;----------------------------------------------------------------

	MOV	DA_UA,AL		;SAVE DA/UA
	AND	AL,0F0H			;GET DA
	CMP	AL,40H			;5"2DD ?
	JE	T_52DD			;JUMP IF SO
	CMP	AL,00H			;5"2D ?
	JE	T_52D
DRV_ERRRET1:
	JMP	DRV_ERRRET		;JUMP IF NOT
;-----------------------------------------------------06/05/1984----------
;DRV_ERRRET2:
;	MOV	DX,OFFSET NOT_RDYM
;	JMP	INIT_ERR
;-------------------------------------------------------------------------
G_INVSW:
	JMP	INV_SW1
E_2DD:
	TEST	SWITCHMAP,SW1		;/1 ?
	JNZ	G_INVSW
	CLC				;NO ERROR
	RET

T_52DD:
	MOV	BYTE PTR DSK5_SW,2	;SET 5"2DD
	MOV	BYTE PTR FATID,0FBH	;SET FATID
	TEST	SWITCHMAP,SW8		;/8 ?
	JNZ	SKP_FATID8		;JUMP IF NO
	MOV	BYTE PTR FATID,0F9H
SKP_FATID8:
	MOV	SI,OFFSET BPB_52DD8
	CMP	BYTE PTR FATID,0FBH	;8 SECTOR ?
	JE	NOT_92DD
	MOV	SI,OFFSET BPB_52DD9
NOT_92DD:
MOV_BPB:
	MOV	DI,OFFSET IPL_FD + 11
	MOV	CX,17
	CLD
	REP	MOVSB			;MOVE BPB
	CMP	BYTE PTR DSK5_SW,2	;5"2DD ?
	JE	E_2DD
	CLC
	RET

T_52D:
	TEST	SWITCHMAP,SWS		;/S ?
	JZ	NOT_SYS5X
	TEST	SWITCHMAP,SW1		;/1 ?
	JNZ	NOTSYSDSK
NOT_SYS5X:
	MOV	BYTE PTR DSK5_SW,1	;5"2D
	MOV	BYTE PTR FATID,0FFH	;5"2D
	MOV	SI,OFFSET BPB_52D8
	TEST	SWITCHMAP,SW1		;/1
	JZ	NOT_SNG5
	MOV	SI,OFFSET BPB_51D8
	AND	BYTE PTR FATID,0FEH
NOT_SNG5:
	TEST	SWITCHMAP,SW8		;/8 ?
	JNZ	NOT_SEC9
	AND	BYTE PTR FATID,0FDH
	MOV	SI,OFFSET BPB_52D9
	TEST	SWITCHMAP,SW1		;/1 ?
	JZ	NOT_SNG51
	MOV	SI,OFFSET BPB_51D9
NOT_SNG51:
NOT_SEC9:
	JMP	MOV_BPB

INV_SW1:
NOTSYSDSK:
CLR_ERR:
	MOV	DX,OFFSET INV_SWM
	JMP	SHORT INIT_ERR
DRV_ERRRET:
	MOV	DX,OFFSET INV_DRVM
INIT_ERR:
	CALL	MSG
	STC
	RET

	PAGE
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%
;%	DISKFORMAT
;%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
DISKFORMAT:
	CMP	HARDFLAG,0
	JZ	DF0
	JMP	HD_DISKFORMAT
DF0:
	PUSH	DS
	POP	ES
	MOV	CX,5			;WAIT ABOUT 1 SEC
L_1:
	PUSH	CX
	XOR	CX,CX
	LOOP	$
	POP	CX
	LOOP	L_1

	CMP	BYTE PTR DSK5_SW,2	;5"2DD ?
	JE	SKP_SET8FD
	JMP	FORM_5FD
SKP_SET8FD:
	MOV	WORD PTR STARTSECTOR,12
	MOV	BYTE PTR ENDCYL,80
	TEST	SWITCHMAP,SW8		;/8 ?
	JNZ	SKP_SNG
	MOV	WORD PTR STARTSECTOR,14
SKP_SNG:
	TEST	SWITCHMAP,SWC		;CHECK 'C' SWITCH
	JZ	SKP_DSK8C		;JUMP IF NO 'C'
	JMP	FORMAT_RET
SKP_DSK8C:
	MOV	AH,07H
	MOV	AL,DA_UA
	INT	DSKIO			;RECABLIRATE
	MOV	DX,OFFSET FORM_EXEM
	CALL	MSG
	CALL	SET_BUF
	MOV	BYTE PTR COM,5DH	;SET COMMAND
	MOV	BX,4*9
	MOV	CX,0200H		;SET SECTOR LENGTH & CYLINDER #
	MOV	DX,00E5H		;SET HEAD# & DATA PATTERN
	MOV	AL,DA_UA		;SET DA/UA
	MOV	BP,OFFSET BUF		;SET DMA ADDRESS
WRT_ID:
	MOV	BYTE PTR RTRY,10	;SET RETRY COUNTER
ID_ERR_ENT:
	MOV	AH,COM			;SET COMMAND
	INT	DSKIO			;CALL FD BIO
	JC	ID_ERR			;JUMP ERROR IN FORMAT
	XOR	DH,01H			;FLIP HEAD#
	TEST	DH,DH			;CHECK HEAD# = 0
	JNZ	SKP_CYL			;JUMP IF NOT
	INC	CL			;SET NEXT CYLINDER#
	CMP	CL,ENDCYL		;END OF CYLINDER ?
	JNE	SKP_CYL			;JUMP IF NOT
	MOV	DX,OFFSET FORM_ENDM
	CALL	MSG
	JMP	FORMAT_RET
SKP_CYL:
	CALL	RWRT_BUF
	JMP	SHORT WRT_ID
ID_ERR:
	AND	AH,0F0H
	CMP	AH,50H			;WRITE PROTECT ?
	JE	ID_ERR1
	CMP	AH,40H			;NOT READY ?
	JE	ID_ERR1
	DEC	BYTE PTR RTRY
	JZ	ID_ERR1
	MOV	AH,07H			;SEC COMMAND
	INT	DSKIO			;RECABLIRATE
	JMP	SHORT ID_ERR_ENT
ID_ERR1:
	JMP	SHORT ERR_RET1
ERR_RET:
	CALL	MSG			;PRINT MESSAGE
ERR_RET1:
	STC				;SET CARRY FOR ERROR
	RET

FORM_5FD:
	MOV	STARTSECTOR,10		;5"2D8
	TEST	SWITCHMAP,SW8		;/8 ?
	JNZ	NOT_SEC91
	MOV	STARTSECTOR,12
NOT_SEC91:
	TEST	SWITCHMAP,SW1		;/1 ?
	JZ	NOT_SNG52
	MOV	STARTSECTOR,7		;51D8
	TEST	SWITCHMAP,SW8		;/8 ?
	JNZ	NOT_SEC92
	MOV	STARTSECTOR,9
NOT_SEC92:
NOT_SNG52:
	TEST	SWITCHMAP,SWC		;/C ?
	JNZ	NOT_FORM5EXE
	MOV	AH,07H
	MOV	AL,DA_UA
	INT	DSKIO
	MOV	DX,OFFSET FORM_EXEM
	CALL	MSG
	CALL	SET_BUF
	MOV	CX,0200H
	MOV	BX,4*9
	MOV	DX,00E5H
	MOV	AL,DA_UA
	MOV	BP,OFFSET BUF
WRT_ID1:
	MOV	BYTE PTR RTRY,10
ID_ERR_ENT1:
	MOV	AH,05DH
	INT	DSKIO
	JC	ID_ERR11
	TEST	SWITCHMAP,SW1
	JNZ	SNG_SET11
	XOR	DH,01H
	TEST	DH,DH
	JNZ	SKP_CYL1
SNG_SET11:
	INC	CL
	CMP	CL,40
	JNE	SKP_CYL1
	JMP	SHORT VOLFOR5_EXIT
SKP_CYL1:
	CALL	RWRT_BUF
	JMP	SHORT WRT_ID1
ID_ERR11:
	AND	AH,0F0H
	CMP	AH,50H			; WRITE PROTECT
	JE	ID_ERR1BT
	CMP	AH,40H			; NOT READY
	JE	ID_ERR1BT
	DEC	BYTE PTR RTRY
	JZ	ID_ERR1BT
	MOV	AH,07H
	INT	DSKIO
	JMP	SHORT ID_ERR_ENT1
ID_ERR1BT:
	JMP	ID_ERR1
VOLFOR5_EXIT:
	MOV	DX,OFFSET FORM_ENDM
	CALL	MSG
NOT_FORM5EXE:

FORMAT_RET:
	PUSH	ES
	PUSH	DS
	POP	ES
	MOV	BP,OFFSET IPL_FD
	MOV	CX,0200H
	MOV	DX,0001H
	MOV	BX,512
DONE0:
	MOV	BYTE PTR RTRY,10
	MOV	AL,DA_UA
DONE1:
	MOV	AH,0F5H
	INT	DSKIO
	JNC	NXT_DONE
	AND	AH,0F0H
	CMP	AH,20H
	JE	DB_DONE
	DEC	BYTE PTR RTRY
	JZ	DONE_ERR
	MOV	AH,07H
	INT	DSKIO
	JMP	DONE1
DONE_ERR:
	POP	ES
	MOV	DX,OFFSET WRT_IPL_M
	JMP	ERR_RET
DB_DONE:
	PUSH	CX
	MOV	SI,BP
	MOV	DI,OFFSET IPL_FD + 512
	MOV	BP,DI
	MOV	CX,BX
	CLD
	REP	MOVSB
	POP	CX
	JMP	DONE0
NXT_DONE:
	POP	ES
	CALL	SET_AI
	CLC				;CLEAR CARRY FOR SUCCESS
	RET

SET_AI:
	MOV	AL,DRIVE
	PUSH	DS
	MOV	BX,SEG DSK_PTR
	MOV	DS,BX
	MOV	BX,OFFSET DSK_PTR
	LDS	BX,DS:DWORD PTR [BX]
	MOV	AH,40
	MUL	AH
	ADD	BX,AX
	OR	DS:BYTE PTR [BX],00001000B
	POP	DS
	RET

SET_BUF:
	MOV	BL,2
	MOV	CX,9
SKP_1:
	MOV	SI,OFFSET BUF
	MOV	AX,0001H		;SET ( CYLINDER# & HEAD# ) &
					;SECTOR#
WRT_BUF:
	MOV	[SI],AH			;SET CYLINDER#
	INC	SI
	MOV	[SI],AH			;SET HEAD#
	INC	SI
	MOV	[SI],AL			;SET SECTOR#
	INC	SI
	MOV	[SI],BL			;SET SECTOR LENGTH
	INC	SI
	INC	AL			;SET NEXT SECTOR#
	LOOP	WRT_BUF
	RET

RWRT_BUF:
	PUSH	AX			;SAVE AX
	PUSH	BX			;SAVE BX
	MOV	BL,9
SKP_3:
	MOV	DI,OFFSET BUF
	MOV	AH,DH			;SET HEAD#
	MOV	AL,CL			;SET CYLINDER#
LOOP_RWRT:
	STOSW				;SET CYLINDER# & HEAD#
	ADD	DI,2
	DEC	BL
	JNZ	LOOP_RWRT
	POP	BX			;RESTORE BX
	POP	AX			;RESTORE AX
	RET

MSG:
	MOV	AH,09H			;SET FUNCTION
	INT	21H			;BDOS FUNCTION CALL
	RET

	PAGE
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%
;%	BADSECTOR
;%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
BADSECTOR:
	CMP	HARDFLAG,0
	JZ	BS0
	JMP	HD_BADSECTOR
BS0:
	XOR	AX,AX			;NO BAD SECTOR & CLEAR CARRY
	RET

	PAGE
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%
;%	WRTFAT
;%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
WRTFAT:
	CMP	HARDFLAG,0
	JZ	WF0
	JMP	HD_WRTFAT
WF0:
	MOV	BYTE PTR LOOP_CNT,2
	PUSH	ES			;SAVE ES
	PUSH	DS
	POP	ES			;ES <- DS
	MOV	BP,FATSPACE		;SET I/O BUFFER
	MOV	CH,02H			; SECTOR LENGTH
	MOV	CL,00H			; CYLINDER
	MOV	BYTE PTR COM,0F5H	; COMMAND (WRITE)
	MOV	DX,0002H		;SET HEAD # & SECTOR #
	CMP	BYTE PTR DSK5_SW,2	;5"2DD ?
	JNE	SET_5FD
	MOV	BX,512*3
	MOV	BYTE PTR SEC_INC,3
	MOV	CH,02H
	TEST	SWITCHMAP,SW8		;/8 ?
	JZ	SKP_SEC82
	MOV	BX,512*2
	MOV	BYTE PTR SEC_INC,2
	JMP	SHORT SKP_SET8
SET_5FD:
	MOV	BYTE PTR SEC_INC,1
	MOV	BX,512*1
	TEST	SWITCHMAP,SW8		;/8 ?
	JNZ	NOT_SEC95
	MOV	BYTE PTR SEC_INC,2
	MOV	BX,512*2
NOT_SEC95:
SKP_SEC82:
SKP_SET8:
	MOV	BYTE PTR RTRY,10	;SET RETRY COUNTER
	MOV	AL,DA_UA		;SET DA/UA
WRT_FATLOOP:
	MOV	AH,COM
	INT	DSKIO			;CALL FD BIOS
	JNC	NXT_CHECK		;JUMP IF NO ERROR
	AND	AH,0F0H
	CMP	AH,20H			;DB ERROR ?
	JE	DB_WRTFAT
	DEC	BYTE PTR RTRY
	JZ	WRT_FATERR
	MOV	AH,07H
	INT	DSKIO
	JMP	WRT_FATLOOP
WRT_FATERR:
	POP	ES			;RESTORE ES
	STC				;SET ERROR
	RET

NXT_CHECK:
	ADD	DL,SEC_INC		;SET NEXT SECTOR
	DEC	BYTE PTR LOOP_CNT
	JNZ	WRT_FATLOOP
	POP	ES
	CALL	SET_AI
	CLC
	RET
DB_WRTFAT:
	PUSH	CX
	MOV	SI,BP
	MOV	DI,OFFSET ENDBUFF + 1024*2
	MOV	BP,DI
	MOV	CX,BX
	CLD
	REP	MOVSB
	POP	CX
	JMP	SKP_SET8

	PAGE
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%
;%	DONE
;%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
DONE:
	CLC
	RET

		PAGE
;================================================================
;
;	HD PART
;
;================================================================
;
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%
;%	INIT
;%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
HD_INIT:
		PUSH	DS
		POP	ES
;
;	READ VOLUME INFORMATION
;
		MOV	BX,512
		MOV	CX,1		; TRACK 0
		MOV	DX,0
		MOV	BP,OFFSET BUF
		CALL	READ_HD
		JNC	HD_INIT1
		AND	AH,0F0H
		CMP	AH,20H
		JNE	HD_INIT_ERROR
		MOV	BP,OFFSET BUF_HD
		CALL	READ_HD
		JNC	HD_INIT1
HD_INIT_ERROR:
		MOV	CX,18		; TRACK 1
		MOV	BP,OFFSET BUF
		CALL	READ_HD
		JNC	HD_INIT1
		AND	AH,0F0H
		CMP	AH,20H
		JNE	HD_INIT_ERROR2
		MOV	BP,OFFSET BUF_HD
		CALL	READ_HD
		JC	HD_INIT_ERROR2
HD_INIT1:
		CMP	DS:[BP+512-2],55AAH
		JNZ	HD_INIT_ERROR2
		MOV	SI,32
		MOV	CL,DS:[BP]
		MOV	CH,0
HD_INIT2:
		JCXZ	HD_INIT_ERROR2

		CMP	WORD PTR DS:[BP+SI],0101H
		JZ	HD_INIT3
		DEC	CX
		ADD	SI,32
		JMP	SHORT HD_INIT2
HD_INIT_ERROR2:
		STC
		RET

;
;	SET UP VOLUME INFORMATION
;
HD_INIT3:
		MOV	AX,DS:[BP+SI+4]
		MOV	SEC_IPL_L,AX
		MOV	AX,DS:[BP+SI+6]
		MOV	SEC_IPL_H,AX
		MOV	AX,DS:[BP+SI+8]
		MOV	SEC_START_L,AX
		MOV	AX,DS:[BP+SI+10]
		MOV	SEC_START_H,AX
		MOV	AX,DS:[BP+SI+12]
		MOV	SEC_END_L,AX
		MOV	AX,DS:[BP+SI+14]
		MOV	SEC_END_H,AX
;
;	MAKE BPB
;
		MOV	AX,SEC_END_L
		SUB	AX,SEC_START_L
		INC	AX
		MOV	BX,OFFSET IPL_HD
		MOV	DS:[BX+13H],AX

;-------------------------------------------------08/20/1984-----
		cmp	ax,(1240/2)*17		; 5M byte
		jnc	mkbpb1
		mov	byte ptr ds:[bx+0dh],4	; 4 sector/file allocation unit
		jmp	short mkbpb9
mkbpb1:
		cmp	ax,1240*17		; 10M byte
		jnc	mkbpb9
		mov	byte ptr ds:[bx+0dh],8	; 8 sector/file allocation unit
mkbpb9:
;----------------------------------------------------------------

		MOV	AL,DS:[BX+15H]
		MOV	FATID,AL
		MOV	HARDFLAG,1
		MOV	STARTSECTOR,17 * 2
		CLC
		RET

		PAGE
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%
;%	DISKFORMAT
;%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
HD_DISKFORMAT:
		PUSH	DS
		POP	ES
		MOV	DX,OFFSET FORM_EXEM
		CALL	MSG
;
;	WRITE IPL CODE
;
HD_DF0:
		MOV	BX,512
		MOV	CX,SEC_IPL_L
		MOV	DX,SEC_IPL_H
		MOV	BP,OFFSET IPL_HD
		CALL	WRITE_HD
		JNC	HD_DF1
		AND	AH,0F0H
		CMP	AH,20H
		JNE	HD_DF_ERROR
		MOV	SI,OFFSET IPL_HD
		MOV	DI,OFFSET BUF_HD
		CLD
		MOV	CX,256
		REP	MOVSW
		MOV	CX,SEC_IPL_L
		MOV	BP,OFFSET BUF_HD
		CALL	WRITE_HD
		JC	HD_DF_ERROR
HD_DF1:
		MOV	N_DB_BUF,BP
		MOV	AX,SEC_START_L
		MOV	SEC_BAD_L,AX
		MOV	AX,SEC_START_H
		MOV	SEC_BAD_H,AX
		MOV	AX,SEC_END_L
		ADD	AX,1
		MOV	SEC_BADE_L,AX
		MOV	AX,SEC_END_H
		ADC	AX,0
		MOV	SEC_BADE_H,AX
		CALL	SET_AI
		CLC
		RET

HD_DF_ERROR:
		MOV	DX,OFFSET WRT_IPL_M
		CALL	MSG
		STC
		RET

		PAGE
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%
;%	BADSECTOR
;%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
HD_BADSECTOR:
		PUSH	DS
		POP	ES
;
;	READ/WRITE CHECK
;
HD_BS0:
		MOV	BX,512 * 17
		MOV	CX,SEC_BAD_L
		MOV	DX,SEC_BAD_H
		CMP	DX,SEC_BADE_H
		JC	HD_BS2
		JNZ	HD_BS01
		CMP	CX,SEC_BADE_L
		JC	HD_BS2
HD_BS01:
		MOV	DX,OFFSET FORM_ENDM
		CALL	MSG
		XOR	AX,AX
		RET
HD_BS2:
		CALL	VERIFY_HD
		JC	HD_BS1
		ADD	SEC_BAD_L,17
		ADC	SEC_BAD_H,0
		JMP	SHORT HD_BS0
HD_BS1:
		ADD	SEC_BAD_L,17
		ADC	SEC_BAD_H,0
		MOV	BX,CX
		SUB	BX,SEC_START_L
		MOV	AX,17
		CLC
		RET

		PAGE
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%
;%	WRTFAT
;%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
HD_WRTFAT:
		PUSH	ES
		PUSH	DS
		POP	ES
;
;	WRITE FAT
;
		MOV	BX,512*8
		MOV	CX,SEC_START_L
		MOV	DX,SEC_START_H
		ADD	CX,1
		ADC	DX,0
		MOV	BP,FATSPACE
		CALL	WRITE_HD
		JNC	HD_WF1
		AND	AH,0F0H
		CMP	AH,20H
		JNE	HD_WF_ERROR
		PUSH	CX
		MOV	SI,BP
		ADD	BP,512*8
		MOV	DI,BP
		MOV	CX,512*4
		CLD
		REP	MOVSW
		POP	CX
		MOV	BX,512*8
		CALL	WRITE_HD
		JC	HD_WF_ERROR
HD_WF1:
		ADD	CX,8
		ADC	DX,0
		CALL	WRITE_HD
		JC	HD_WF_ERROR
		POP	ES
		CLC
		RET
HD_WF_ERROR:
		POP	ES
		STC
		RET

		PAGE
;----------------------------------------------------------------
;	SUBROUTINES
;----------------------------------------------------------------

READ_HD		PROC
		MOV	AL,DRIVE
		SUB	AL,2
		OR	AL,10010000B
		MOV	RTRY,3
READ_HD1:
		MOV	AH,0D6H		; READ COMMAND
		INT	DSKIO
		JNC	READ_HD_OK
		DEC	RTRY
		JZ	READ_HD_ERROR
		MOV	AH,0D7H		; RECALIBRATE COMMAND
		INT	DSKIO
		JMP	SHORT READ_HD1
READ_HD_ERROR:
		STC
READ_HD_OK:
		RET
READ_HD		ENDP

WRITE_HD	PROC
		MOV	AL,DRIVE
		SUB	AL,2
		OR	AL,10010000B
		MOV	RTRY,3
WRITE_HD1:
		MOV	AH,0D5H		; WRITE COMMAND
		INT	DSKIO
		JNC	WRITE_HD_OK
		DEC	RTRY
		JZ	WRITE_HD_ERROR
		MOV	AH,0D7H		; RECALIBRATE COMMAND
		INT	DSKIO
		JMP	SHORT WRITE_HD1
WRITE_HD_ERROR:
		STC
WRITE_HD_OK:
		RET
WRITE_HD	ENDP

VERIFY_HD	PROC
		MOV	AL,DRIVE
		SUB	AL,2
		OR	AL,10010000B
		MOV	RTRY,3
VERIFY_HD1:
		MOV	AH,0D1H		; VERIFY COMMAND
		INT	DSKIO
		JNC	VERIFY_HD_OK
		DEC	RTRY
		JZ	VERIFY_HD_ERROR
		MOV	AH,0D7H		; RECALIBRATE COMMAND
		INT	DSKIO
		JMP	SHORT VERIFY_HD1
VERIFY_HD_ERROR:
		STC
VERIFY_HD_OK:
		RET
VERIFY_HD	ENDP

	PAGE
;================================================================
;
;	DATA AREA
;
;================================================================
	EVEN
STARTSECTOR	DW	10
FREESPACE	DW	OFFSET ENDBUFF + (8*1024)
FATSPACE	DW	OFFSET ENDBUFF
LOOP_CNT	DB	0
SEC_INC		DB	0
HARDFLAG	DB	0
COM		DB	0
RTRY		DB	10
DSK5_SW		DB	0
DA_UA		DB	0
ENDCYL		DB	0
N_DB_BUF	DW	0
SEC_IPL_L	DW	0
SEC_IPL_H	DW	0
SEC_START_L	DW	0
SEC_START_H	DW	0
SEC_END_L	DW	0
SEC_END_H	DW	0
SEC_BAD_L	DW	0
SEC_BAD_H	DW	0
SEC_BADE_L	DW	0
SEC_BADE_H	DW	0
FATID		DB	0FEH
SWITCHLIST	DB	6,"18COVS"
WRT_IPL_M	DB	'Unable to write BOOT',13,10,'$'
INV_DRVM	DB	'Invalid drive specification',13,10,'$'
FORM_EXEM	DB	'Formatting ... $'
FORM_ENDM	DB	'Format complete',13,10,'$'
INV_SWM		DB	'Invalid switch',13,10,'$'
;------------------------------------------------------06/05/1984-----------
;NOT_RDYM	DB	'Drive not ready',13,10,'$'
;---------------------------------------------------------------------------

	EVEN
BUF_HD		EQU	(THIS BYTE)
IPL_FD		EQU	(THIS BYTE)
BUF_FD		EQU	(THIS BYTE) + 512
IPL_HD		EQU	(THIS BYTE) + 512
BUF		EQU	(THIS BYTE) + 512 + 512
ENDBUFF		EQU	(THIS BYTE) + 512 + 512 + 512

CODE	ENDS

	PAGE

IOSYS	SEGMENT AT 0060H
	ORG	20H
DSK_PTR	LABEL	DWORD
IOSYS	ENDS

	END
