	PAGE	58,132
	TITLE	'A1 INIT'
;************************************************************************
;*									*
;*	INITIALIZE MEMORY AND I/O FOR START UP MS-DOS 2.0 IN A1.	*
;*									*
;*	FUNCTION							*
;*									*
;*		1. INITIALIZE MEMORY					*
;*			(1) INTERRUPT VECTOR				*
;*			(2) MEMORY SWITCH , DITP SWITCH			*
;*			(3) WORK AREA USED IN ANY DRIVER PROGRAM	*
;*									*
;*		2. INITIALIZE INTERFACE I/O				*
;*			(1) CRT (88/80)					*
;*			(2) PRINTER (SENTRO/ODA)			*
;*			(3) RAMDISK (AND FORMATTING)			*
;*									*
;*		3. START UP MS-DOS 2.0					*
;*			(1) SET INITIAL VALUE TO WORK AREA ON "SYSINIT"	*
;*			(2) GO TO SYSINIT				*
;*			(3) RE-INITIALIZE (NO OPERARTION)		*
;*									*
;*	CALLING SEQUENCE						*
;*									*
;*		THIS PROGRAM AND "MSDOS.SYS" ARE IS LOADED AND JUMPED	*
;*		FROM BOOT PROGRAM ON DEFALT DISK. (5'FD AND 5'HD)	*
;*		BOOT PROGRAM IS LOADED AND JUMPED FROM ROM BIOS PROGRAM	*
;*		THIS PROGRAM JUMP TO "SYSINIT" FOR START UP MS-DOS 2.0	*
;*									*
;************************************************************************
;	MAR/16/84
;	mar/19/84
;	MAR/27/84
;	APR/17/84
;	APR/23/84
;	may/16/84
;	jun/07/84	; move exchange interrupt vector
			; io.sys is 16 boundary
;	JLY/27/84		; ADD BAUD RATE AND COMMAND
;	AUG/10/84
;****************************************
;*	EXTERNAL SYMBOL AND LABEL	*
;****************************************
;*
;**	DRIVER ADDRESS OR MODULE ADDRESS
;*
;----------------------------------------------INSERT JUN/07/84--------
	EXTRN	INT9_PNT:DWORD		; SAVE INTERRUPT VECTOR OF KB
	EXTRN	AUXROM_ADR:DWORD	; SAVE INTERRUPT VECTOR OF AUX

	EXTRN	INT6_PROC:FAR		; ENTRY POINT INT 6 (BREAK KEY)
	EXTRN	INT9_PROC:FAR		; ENTRY POINT INT 9 (KB INTERRUPT)
	EXTRN	INT29_PROC:FAR		; ENTRY POINT INT 29 (DIRECT CONSOLE OUTPUT)
	EXTRN	RS232C_IO_INT:FAR	; ENTRY POINT INT 1A (AUXROM)
;----------------------------------------------------------------------
;*
;**	CRT/AUX/PRN WORK AREA
;*
	EXTRN	SETDATE:NEAR
	EXTRN	GETDATE:NEAR
;*
;**	SYSTEM FLAG
;*
	EXTRN	MEM_SW1:BYTE		; MEMORY SWITCH 1 SAVE AREA
	EXTRN	MEM_SW2:BYTE		; MEMORY SWITCH 2 SAVE AREA
	EXTRN	MEM_SW3:BYTE		; MEMORY SWITCH 3 SAVE AREA
	EXTRN	MEM_SW4:BYTE		; MEMORY SWITCH 4 SAVE AREA
	EXTRN	MEM_SW5:BYTE		; MEMORY SWITCH 5 SAVE AREA
;*
;**	SYSINIT INTERFACE MEMORY
;*

	EXTRN	DEV_TBL:WORD		; DEVICE TABLE TOP ADDRESS
	EXTRN	CURRENT_DOS_LOCATION:WORD	; CURRENT MSDOS PROGRAM ADDRESS
	EXTRN	FINAL_DOS_LOCATION:WORD	; FINAL MSDOS PROGRAM ADDRESS
	EXTRN	DEVICE_LIST:DWORD	; DEVICE TABLE TOP ADDRESS SET AREA
	EXTRN	MEMORY_SIZE:WORD	; MAX MEMORY
	EXTRN	DEFAULT_DRIVE:BYTE	; DEFALT DRIVE NUMBER
	EXTRN	BUFFERS:BYTE		; BUFFER NUMBER
	EXTRN	FILES:BYTE		; FILE NUMBER
	EXTRN	SYSINIT:FAR		; "SYSINIT" ENTRY POINT
;---------------------------------------------ins-----mar/19/84----
;*
;**	common subroutine
;*
	EXTRN	INT_TRAP:NEAR		; ENTRY PONT WHEN INVALID INTERRUPT
	EXTRN	HD_DSK_DEV:NEAR		; HD DEVICE TABLE
	EXTRN	RAMDISK_TOP:NEAR	; START POINT OF RAMDISK DRIVER
	EXTRN	RAMDISK_TALE:NEAR	; END   POINT OF RAMDISK DRIVER
	EXTRN	INIT_CHECK:NEAR		; CHECK FORMATED AT RAMDISK
	EXTRN	FORMAT:NEAR		; FORMATING OF RAMDISK
	EXTRN	RAMDISK_INIT:NEAR	; INITIALIZE RAMDISK DRIVER
	EXTRN	AUX_WORK:DWORD
;------------------------------------------------------------------
;*
;**	SYSTEM COMMON AND WORK AREA
;*
		PAGE
;****************************************
;*					*
;*	EQUATE TABLE			*
;*					*
;****************************************
BIOSSIZS	EQU	0400H		; PARAGRAPHS (16K)...
;*
;**	ROM BIOS FUNCTION CODE
;*
CRT_FNC_SETMOD	EQU	0		; CRT	SET SCREEN MODE
CRT_FNC_SETCSR	EQU	1		; CRT	SET CURSOL TYPE
CRT_FNC_CSRDSP	EQU	2		; CRT	SET CURSOL POSITION
CRT_FNC_GETCSR	EQU	3		; CRT	GET CURSOL POSITION
CRT_FNC_SETPAGE	EQU	5		; CRT	SET CURRENT PAGE NUMBER
CRT_FNC_TTY	EQU	14		; CRT	WRITE TELETYPE
PRN_FNC_INIT	EQU	1		; PRINT	INITIALIZE
CLK_FNC_GET	EQU	00H		; GET TIME AND DATE
;*
;**	INTERRUPT VECTOR
;*
KB_ROM		EQU	18H
CRT_ROM		EQU	19H
AUX_ROM		EQU	1AH
PRN_ROM		EQU	1BH
CLK_ROM		EQU	1CH
	PAGE
;********************************************************
;*							*
;*	OTHOR SEGMENT MEMORY				*
;*							*
;********************************************************
;************************************************;
;*						*;
;*     INTERRUPT VECTOR AND SYSTEM COMMON AREA	*;
;*						*;
;************************************************;
INT_VEC		SEGMENT	AT 0000H
;*
;**	INTERRUPT VECTOR
;*
;------------------------------------------------INSERT JUN/07/84------
	ORG	6*4
INT6_OFFSET	DW	?
INT6_SEGMENT	DW	?
	ORG	9*4
INT9_OFFSET	DW	?
INT9_SEGMENT	DW	?
	ORG	1AH*4
INT_AUX_OFFSET	DW	?
INT_AUX_SEGMENT	DW	?
;----------------------------------------------------------------------
	ORG	4*32
INT32_OFFSET	DW	?
INT32_SEGMENT	DW	?
;-----------------------------------------------INSERT JUN/07/84-------
	ORG	29H*4
INT29_OFFSET	DW	?
INT29_SEGMENT	DW	?
;----------------------------------------------------------------------
;*
;*	SYSTEM COMMON AREA AND ROM WORK AREA
;*
	ORG	400H			; ------CHG NOV/15/83----
BIOS_FLAG	DW	?
	ORG	402H			; ----------CHG NOV/15/83----
BT_TYPE		DB	?
INT_VEC	ENDS
;************************************************
;*						*
;*	C-MOS					*
;*						*
;************************************************
CMOS_SEG	SEGMENT	AT 0A3FEH
		ORG	2
MEMORY_SW1	LABEL	BYTE
CMOS_SEG	ENDS
		PAGE
CODE	SEGMENT	WORD PUBLIC 'CODES'
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
;************************************************
;*						*
;*	PUBLIC SYMBOL AND LABEL			*
;*						*
;************************************************
	PUBLIC	INIT
	PAGE
;********************************************************
;*							*
;*		A1 INIT MAIN PROGRAM			*
;*							*
;********************************************************

;---------------------------------------------------------DEL MAR/19/84-
;----------------------------------------------------ins----mar/16/84--

END_ADR		DW	INIT
mem_lng		db	0		; memory length (*128kb+128kb)
WORK_TBL	LABEL	BYTE
		DW	64 DUP(0)
STACKTOP	LABEL	WORD
;-----------------------------------------------------------------
		PAGE
INIT:		 			;PRINT	SIGN ON	MESSAGE	AND INITIALIZE
;************************************************
;*	SET INTIAL VALUE TO ANY REGISTER	*
;************************************************
	CLI				;INTERRUPT DISABLE
	MOV	AX,CS			;WE ENTERED WITH A JMPF	SO USE
	MOV	SS,AX			;CS: AS	THE INITIAL VALUE OF SS:,
	MOV	DS,AX			;			     DS:
	MOV	ES,AX			;			 AND ES:
	MOV	SP,OFFSET STACKTOP	; USE LOCAL STACK DURING INITIALIZATION
;************************************************
;*						*
;*	SET UP INTERRUP VECTOR IN LOW MEMORY	*
;*	EXCEPT 00H -- 1FH. (SET BY ROM BIOS)	*
;*						*
;************************************************
	PUSH	DS			;SAVE THE DS REGISTER
	PUSH	ES			;SAVE ES
	MOV	AX,INT_VEC
	MOV	DS,AX
	MOV	ES,AX			;SET ES	AND DS ZERO
;*
	ASSUME	DS:INT_VEC,ES:INT_VEC
	CLD
	MOV	SI,OFFSET INT32_OFFSET
	MOV	DI,SI
	MOV	AX,OFFSET INT_TRAP
	STOSW
	MOV	AX,CS
	STOSW
	MOV	CX,(256-32-1)*4/2
	REP	MOVSW
;*
;**	SET INTERRUP VECTOR
;*
;------------------------------------------------INSERT JUN/07/84------
	ASSUME	DS:INT_VEC,ES:CODE
	POP	ES
	MOV	SI,OFFSET INT9_OFFSET	; SAVE INTERRUPT VECTOR OF KB
	MOV	DI,OFFSET INT9_PNT
	MOVSW
	MOVSW
	MOV	SI,OFFSET INT_AUX_OFFSET; SAVE INTERRUPT VECTOR OF AUX
	MOV	DI,OFFSET AUXROM_ADR
	MOVSW
	MOVSW

	MOV	[INT6_OFFSET],OFFSET INT6_PROC
	MOV	[INT9_SEGMENT],CS
	MOV	[INT9_OFFSET],OFFSET INT9_PROC
	MOV	[INT6_SEGMENT],CS
	MOV	[INT_AUX_OFFSET],OFFSET RS232C_IO_INT
	MOV	[INT_AUX_SEGMENT],CS
	MOV	[INT29_OFFSET],OFFSET INT29_PROC
	MOV	[INT29_SEGMENT],CS
;----------------------------------------------------------------------
		PAGE
;************************************************
;*						*
;*	GET MEMORY SWITCH AND BIOS CONTROL FLAG	*
;*						*
;************************************************
;*
;**	SET MEMORY SW CONTENTS FOR RS232C
;*
	ASSUME	DS:CMOS_SEG,ES:CODE
	MOV	AX,CMOS_SEG		;SET CMOS SEG ADDR
	MOV	DS,AX
	MOV	SI,OFFSET MEMORY_SW1
	MOV	DI,OFFSET MEM_SW1
	MOV	CX,8
L_MEMSW1:
	MOVSB				;GET MEMORY SWITCH 1-8
	ADD	SI,3
	LOOP	L_MEMSW1

	ASSUME	DS:CODE,ES:CODE
	POP	DS

;---------------------------------------------------INSERT JLY/27/84---
	LES	SI,[AUX_WORK]
	MOV	AL,[MEM_SW1]
	MOV	ES:[SI+9],AL		;--------------AUG/10/84----
	MOV	AL,[MEM_SW2]
	AND	AL,0FH
	MOV	ES:[SI+8],AL		;----------------AUG/10/84----
;----------------------------------------------------------------------
		PAGE
;************************************************
;*						*
;*	INITIALIZATION CRT			*
;*						*
;************************************************
	ASSUME	DS:CODE
;*
;**	SET CRT MODE
;*
;-------------------------------------------CHANGE--APR/17/84---------
		IN	AL,33H		; GET SYSTEM PORT
		TEST	AL,08H		; IS CRT TYPE 80 ?
		MOV	AL,1		; 25X40,COLOR
		JZ	INIT_CRT2
		MOV	AL,3		; 25X80,COLOR
INIT_CRT2:
;----------------------------------------------------------------------
		MOV	AH,CRT_FNC_SETMOD
		INT	CRT_ROM		; CRT MODE SET
;************************************************
;*						*
;*	PRINTER INTIALIZE			*
;*						*
;*						*
;************************************************
		MOV	AH,PRN_FNC_INIT	; INITILIZE ODA/CENTRO
		INT	PRN_ROM
INIT_PRNEND:

;::::::::::::::::::::::::::::::::::::::::
;:	KB INTERRUPT MASK OPEN		:
;::::::::::::::::::::::::::::::::::::::::

		MOV	AL,068H
		OUT	02H,AL
		MOV	AL,0B8H
		OUT	0AH,AL
;---------------------------------------------------------------
;::::::::::::::::::::::::::::::::::::::::
;	CHANGE DATE			:
;::::::::::::::::::::::::::::::::::::::::
	MOV	BX,OFFSET WORK_TBL
	MOV	AH,CLK_FNC_GET
	INT	CLK_ROM			; GET WEEK COUNT
	CALL	GETDATE			; GET DATE

	MOV	BX,AX
	ADD	AX,2
	MOV	DX,0
	MOV	CX,7
	DIV	CX
	MOV	AL,[WORK_TBL+1]
	AND	AX,000FH
	SUB	AX,DX
	JZ	INIT_CLK9		; MATCH ?
	JB	INIT_CLK3		; N
	SUB	AX,7
INIT_CLK3:
	CMP	AX,-1			; LEAP MONTH ?
	JZ	INIT_CLK4		; Y

	ADD	AX,7+(7*52)		; ADD DAYS OF ONE YEAR
INIT_CLK4:
	ADD	AX,BX
INIT_CLK7:
	CALL	SETDATE
INIT_CLK9:
;----------------------------------------------------------------
;--------------------------------------------------ins---mar/16/843----
;************************************************
;*	ram disk initialize			*
;************************************************
	mov	ax,int_vec
	mov	ds,ax
	assume	ds:int_vec
	mov	al,byte ptr ds:[bios_flag+1]
	push	cs
	pop	ds
	assume	ds:code
	and	al,07h
;--------------------------------------------------insert may/16/84----
	test	[mem_sw5],02h		; ram disk disable ?
	jz	ramdisk_none		; yes.
;----------------------------------------------------------------------
	mov	dl,[mem_sw3]
	and	dl,07h
	cmp	al,dl			; exist ram memory ?
	jg	ramdisk_exist		; y
ramdisk_none:
	mov	[mem_lng],al		; save memory size ---may/10/84
	mov	ax,-1			; delete device table of ramdisk

	mov	word ptr [hd_dsk_dev+0],ax
	mov	word ptr [hd_dsk_dev+2],ax
	mov	[end_adr],offset ramdisk_top
	jmp	short already_there

ramdisk_exist:
	mov	[mem_lng],dl		; save memory size ---may/10/84
	mov	[end_adr],offset ramdisk_tale
	call	ramdisk_init
;
	call	init_check		; check for ram disk presently there
	jz	already_there		; skip "formatting" if disk there
	call	format			; else format it
already_there:
;---------------------------------------------------------------------
		PAGE
;************************************************
;*						*
;*	GO TO SYSINIT				*
;*						*
;************************************************
;*
;**	GET DEFALT DRIVE NUMBER
;*
	mov	dl,[mem_lng]			; dl = memory size---chg may/10/84
	INC	DL
	MOV	CL,13
	SHL	DX,CL				; DX=MEMORY END
	MOV	AX,SEG INT_VEC
	MOV	DS,AX
	ASSUME	DS:INT_VEC
	MOV	AL,[BT_TYPE]
	MOV	BL,1
	TEST	AL,010H				; HD ? ---NOV/15/83--
	JZ	SKP10				; NO   ---NOV/15/83--
	MOV	BL,3
SKP10:
	AND	AL,0FH
	ADD	BL,AL
;*
;**	SET INTIAL VELUE
;*
	MOV	AX,SEG SYSINIT
	MOV	DS,AX
	ASSUME	DS:SEG SYSINIT
	MOV	AX,CS
	ADD	AX,BIOSSIZS
	MOV	[MEMORY_SIZE],DX
	MOV	[DEFAULT_DRIVE],BL
	MOV	[CURRENT_DOS_LOCATION],AX
	MOV	WORD PTR [DEVICE_LIST+2],CS
	MOV	WORD PTR [DEVICE_LIST],OFFSET DEV_TBL
	MOV	AX,CS:[END_ADR]
	ADD	AX,000FH
	MOV	CL,4
	SHR	AX,CL
	MOV	BX,CS
	ADD	AX,BX
;----------------------------------DELETE 256 BOUNDARY JUN/07/84-------
	MOV	[FINAL_DOS_LOCATION],AX
	JMP	SYSINIT

	ASSUME	DS:CODE
	PAGE
;
CODE	ENDS

;************************************************
;*	PROGRAM END				*
;************************************************
	END

*

