		PAGE	60,132
		TITLE	RS232C		EXTRA 2 SERIAL INTERFACE
;****************************************************************
;*								*
;*	RS232C_BIO	MODULE					*
;*								*
;****************************************************************
;	JLY/31/84
;	OCT/03/84	CHANGE 8251 INITIALIZE

;****************************************
;*	EQUATE AREA			*
;****************************************
;*
;**	I/O PORT ADDRESS
;*
S2_BASE		EQU	0B9H		; PORT ADDRESS OF UPD8251
S2_DATA		EQU	S2_BASE+0	;  READ/WRITE DATA (1BYTE)
S2_STS		EQU	S2_BASE+2	;  READ STATUS
S2_CMD		EQU	S2_BASE+2	;  WRITE COMMAND INSTRUCTION
S2_MODE		EQU	S2_BASE+2	;  WRITE MODE INSTRUCTION
;*
INTM_O1		EQU	02H		; INTERRUPT MASK R/W (MASTER)
INTM_O2		EQU	00H		; INTERRUPT SET/RESET (MASTER)
INTS_O1		EQU	0AH		; INTERRUPT MASK R/W (SUB)
INTS_O2		EQU	08H		; INTERRUPT SET/RESET (SUB)
TIME_MODE	EQU	0BFH		; TIMER CONTER FOR BAUD RATE
TIME_CNT	EQU	0B7H		; TIMER CONTROL FOR BAUD RATE
S2_INTR		EQU	0B2H		; SET INTERRUPT MASK
S2_MASK		EQU	0B2H		; GET INTERRUPT REQUEST
SYS_PORT	EQU	0B2H
EOI		EQU	20H
;*
;**	COMMAND OF 8251 OR 8253
;*
F_RESET		EQU	40H		; INTERNAL RESET
F_RXE		EQU	04H		; RECEIVER ENABLE
F_TXR		EQU	01H		; TRANSMITTER READY (BIT)
F_RXRE		EQU	01H		; PORT-C SIGNAL (RXRDY_INT ENABLE)
F_RXRD		EQU	00H		; 		(RXRDY_INT DISABLE)
S2_TIMMOD	EQU	076H		; CONTROL CODE FOR 8253
C_8MHZ		EQU	80H		; 8MHZ CLOCK
;*
;**	FLAG
;*
F_INIT		EQU	10000000B	; INTIALIZED
F_FUL		EQU	01000000B	; BUFFER FULL
F_OVER		EQU	00100000B	; BUFFER OVER
F_XE		EQU	00010000B	; X PROTOCOL ENABLE
F_XSEND		EQU	00001000B	; XOFF SEND
F_XRECV		EQU	00000100B	; XOFF RECEIVERD

F_SE		EQU	10000000B	; SI/SO ENABLE
F_SRECV		EQU	00010000B	; SO MODE WHEN DATA RECEIVE
F_SSEND		EQU	00000010B	; SO MODE WHEN DATA SEND
;*
;*	ASCII CODE (CONTROL CHARACTER)
;*
C_XON		EQU	11H		; DC1 (CTRL-Q)
C_XOFF		EQU	13H		; DC3 (CTRL-S)
C_SI		EQU	0FH		; SHIFT IN  CODE
C_SO		EQU	0EH		; SHIFT OUT CODE
;****************************************
;*	STRUCTURE			*
;****************************************

;  BUFFER CONTROL BLOCK	        

RSB_WORK	STRUC
RSB_FLAG	DB	?		; CONTROL FLAG
RSB_CMDS	DB	?		; COMMAND BYTE SAVE AREA
RSB_STIM	DB	?		; TIME OUT (SEND)
RSB_RTIM	DB	?		; TIME OUT (RECEIVE)
RSB_XON		DW	?		; XON  VALUE (3/4 BUFF SIZE)
RSB_XOFF	DW	?		; XOFF VALUE (1/4 BUFF SIZE)
RSB_HEAD	DW	?		; BUFFER HEAD POINTER
RSB_TAIL	DW	?		; BUFFER TAIL POINTER
RSB_CNT		DW	?		; DATA COUNT
RSB_PUTP	DW	?		; DATA PUT POINTER
RSB_GETP	DW	?		; DATA GET POINTER
RSB_OFST	DB	?		; BUFFER AREA OFFSET
RSB_WORK	ENDS

INT_BIT		STRUC
PORT		DW	?
MASKON		DB	?
MASKOFF		DB	?
INT_BIT		ENDS
		PAGE
;************************************************
;*						*
;*		OTHOR SEGMENT			*
;*						*
;************************************************

;****************************************
;*	USER PARAMETER SEGMENT		*
;****************************************
USER		SEGMENT	AT 0060H
USER		ENDS
;
INCLUDE		B:SYSCOM.LIB

;********************************
;*	LOCAL WORK AREA		*
;********************************
ROM		SEGMENT	WORD PUBLIC
RS_S2_OFST	DW	?
		DW	?
RS_S2_FLAG	DB	?
ROM		ENDS
		PAGE
;********************************
;*	EXTRENAL LABEL		*
;********************************
;********************************
;*	PUBLIC LABEL		*
;********************************
	PUBLIC	S2_IO
	PUBLIC	S2_INT
	PUBLIC	EXTRS_END
ROM 	SEGMENT	WORD PUBLIC
	ASSUME	CS:ROM ,DS:SYSCOM,ES:USER,SS:USER
;********************************************************
;*							*
;*		DEFINE CONSTANT	(TABLE)			*
;*							*
;********************************************************
;
;------- TIMER COUNTER -------BPS		(X16)	(X64)
;

;	FOR 8MHZ CLOCK----------;		
;
CLKCNT_8MHZ	LABEL	WORD
		DW	0680H		;	75
		DW	0340H		;	150
		DW	01A0H		;	300	75
		DW	00D0H		;	600	150
		DW	0068H		;	1200	300
		DW	0034H		;	2400	600
		DW	001AH		;	4800	1200
		DW	000DH		;	9600	2400

 
;   COMMAND SUBROUTINE ADDRESS TABLE
 
S2_CMD_TBL	LABEL	WORD
		DW	S2_INIT1	; INITIALIZE 1
		DW	S2_INIT2	;	     2 (XON/XOFF ENABLE)
		DW	S2_GETDL	; GET DATA LENGTH
		DW	S2_SEND		; SEND THE CHARACTER
		DW	S2_RECV		; RECEIVE THE CHARACTER
		DW	S2_OUTC		; COMMAND OUT
		DW	S2_STAT		; READ STATUS

S2_BIT_TBL	LABEL	BYTE
		INT_BIT	<INTM_O1,08H,NOT 08H>
		INT_BIT	<INTS_O1,08H,NOT 08H>
		INT_BIT	<INTS_O1,10H,NOT 10H>
		INT_BIT	<INTS_O1,20H,NOT 20H>
	PAGE
;****************************************************************
;   COMMAND ENTRY						*
;								*
;	ENTRY: (AH)= COMMAND					*
;	EXIT : (AH)= RETURN CODE				*
;		   	00 - NORMAL END				*
;		 	01 - PORT NOT INITIALIZED		*
;			02 - COMMUNICATION BUFFER OVERFLOW	*
;			03 - TIME OUT				*
;****************************************************************

S2_IO		PROC	NEAR
		STI				; ENABLE INTERRUPT
		PUSH	ES
		PUSH    DS
		PUSH	DI
		PUSH    SI
		PUSH	BX
		PUSH	DX
;
		CMP	AH,07H			; CHECK COMMAND
		JNB	S2_NOP			; ILLEGAL
;-----------------------------------------------
;
;	SET SEGMENT REGISTER
;		ENTRY
;			ES:DI=USER BUFFER
;			DS:  =SYSTEM WORK SEGMENT
;
;		PROGRAM
;			DS:DI=USER BUFFER
;			ES:  =SYSTEM WORK SEGMENT
;
;-----------------------------------------------
	ASSUME	DS:SYSCOM,ES:USER
		MOV	SI,SYSCOM
		MOV	DS,SI
		CMP	AH,02H			; CMD = INITIALIZE ?
		JNB	S2_P1			; NO

		MOV	[RS_S2_OFST+0],DI
		MOV	[RS_S2_OFST+2],ES
S2_P1:
		MOV	ES,SI
		LDS	DI,DWORD PTR [RS_S2_OFST]
;
		MOV	SI,DS
		OR	SI,DI			; COM_BUFFER ADDRESS = 0:0 ?
		JZ	S2_NI			; Y
;
	ASSUME	DS:USER,ES:SYSCOM
;
		ADD	DI,2
		CMP	AH,2			; GET DATA LENGTH ?
		JE	S2_P2
		CMP	AH,3			; READ ?
		JE	S2_P2
		CMP	AH,4			; WRITE ?
		JNE	S2_P4
S2_P2:
		TEST	[DI.RSB_FLAG],F_INIT	; CHECK INITALIZED
		JZ	S2_NI			; OFF (ERROR RETURN)
S2_P4:
		PUSH	AX
		MOV	AL,AH
		CBW
		SHL	AX,1
		MOV	SI,OFFSET S2_CMD_TBL
		ADD	SI,AX
		POP	AX
		CALL	CS:[SI]
;********************************
;   RETURN FROM RS232_BIO	*
;********************************
RS232C_RET:
		POP 	DX
		POP	BX
		POP	SI
		POP	DI
		POP	DS
		POP	ES
		IRET

;   PORT NOT INITIALIZED
	
S2_NI:
		MOV	AH,1
		JMP     RS232C_RET

;   ILLEGAL COMMAND (NO OPERATION)

S2_NOP:
		MOV	AH,0			; NORMAL RETURN
		JMP     RS232C_RET
S2_IO		ENDP
	PAGE
;************************************************
;   SEND DATA					*
;						*
;	SEND THE CHARACTER IN (AL)		*
;	ENTRY: (AH)=3				*
;	       (AL)=SEND DATA			*
;	EXIT : (AH)=RETURN CODE			*
;************************************************
S2_SEND		PROC	NEAR
		TEST	[RS_S2_FLAG],F_SE	; BITS=8 ?
		JZ	S2_SEND50		; YES
		TEST	AL,80H			; SO CHARACTER ?
		JNZ	S2_SEND30		; YES
		TEST	[RS_S2_FLAG],F_SSEND	; NOW SI MODE ?
		JZ	S2_SEND50
		PUSH	AX
		MOV	AL,C_SI			; OUTPUT SI CODE
		CALL	S2_SS			;
		AND	AH,AH
		POP	AX
		JNZ	S2_SEND_EXIT		;
		AND	[RS_S2_FLAG],NOT F_SSEND
		JMP	SHORT S2_SEND50

S2_SEND30:
		TEST	[RS_S2_FLAG],F_SSEND	; NOW SO MODE ?
		JNZ	S2_SEND50
		PUSH	AX
		MOV	AL,C_SO			; OUTPUT SO CODE
		CALL	S2_SS			;
		AND	AH,AH
		POP	AX
		JNZ	S2_SEND_EXIT		;
		OR	[RS_S2_FLAG],F_SSEND

S2_SEND50:
		CALL	S2_SS
S2_SEND_EXIT:
		RET
S2_SEND		ENDP
	PAGE
;****************************************
;*					*
;*	OUTPUT CHARACTER		*
;*					*
;*	INPUT	AL=OUTPUT CHARACTER	*
;*		[DI.RSB_STIM]=TIME OUT	*
;*	EXIT	AH=RETURN CODE		*
;*					*
;*					*
;****************************************
S2_SS		PROC	NEAR
		PUSH	CX
		MOV	AH,AL			;
		MOV	DL,[DI.RSB_STIM]	; SET TIME OUT COUNT
		MOV	DH,0
		ADD	DX,DX
S2_SS1:
		MOV	CX,19000		; SET COUNTER (0.25 SEC)
		TEST	BYTE PTR [BIOS_FLAG+1],C_8MHZ
		JZ	S2_SS2			; BR. IF 5MHZ SYSTEM
		MOV	CX,28000		; SET LOOP COUNTER
S2_SS2:
		IN	AL,S2_STS		; READ USART STATUS
		AND	AL,F_TXR
		OR	AL,[DI.RSB_FLAG]	; XOFF RECEIVE ?
		AND	AL,04H+F_TXR
		CMP	AL,F_TXR
		JZ	S2_SS3			; BR. TX SEND REDY
		LOOP	S2_SS2			; NOT TXRDY (RETRY)
		DEC	DX
		JNZ	S2_SS1			; RETRY	(498MS)
		CMP	[DI.RSB_STIM],0		; TIMER DEFAULT ?
		JZ	S2_SS1

		MOV	AH,03H			; TIME OUT
		JMP	SHORT S2_SS_EXIT
;
; SEND THE CHARACTER

S2_SS3:
		MOV	AL,AH
		OUT	S2_DATA,AL		; OUTPUT CHARACTER
		MOV	AH,0
S2_SS_EXIT:
		POP	CX
		RET
S2_SS		ENDP
	PAGE
;************************************************
;   RECEIVE DATA				*
;						*
;	RECEIVE	A CHARACTER FROM BUFFER		*
;	ENTRY: (AH)=4				*
;	EXIT : (AH)=RETURN_CODE			*
;	       (CH)=RECEIVED DATA		*
;	       (CL)=STATUS			*
;************************************************
S2_RECV		PROC	NEAR
		CLI				; DISABLE INTERRUPT
		MOV	AH,02H
		MOV	DL,[DI.RSB_FLAG]	; GET FLAG BYTE
		AND	[DI.RSB_FLAG],NOT F_OVER; CLEAR BUFFER OVER
		TEST	DL,F_OVER		; BUFFER OVERFLOW ?
		JNZ	S2_RECV_EXIT		; YES
;*
;**	WAIT UNTIL DATA RECEIVE OR TIME OUT
;*
		STI				; ENABLE INTERRUPT
		MOV	DL,[DI.RSB_RTIM]	; SET TIME OUT COUNT
		MOV	DH,0
		ADD	DX,DX
S2_RECV1:
		MOV	CX,26500 		; SET COUNTER (0.25 SEC)
		TEST	BYTE PTR [BIOS_FLAG+1],C_8MHZ
		JZ	S2_RECV2		; BR. IF 5MHZ SYSTEM
		MOV	CX,39400		; SET COUNTER
S2_RECV2:
		CMP	[DI.RSB_CNT],0
		JNZ	S2_RECV3		; BR. IF RECEIVED
		LOOP	S2_RECV2
		DEC	DX
		JNZ	S2_RECV1
		CMP	[DI.RSB_RTIM],0		; TIMER DEFAUKT ?
		JZ	S2_RECV1

		MOV	AH,03H			; TIME OUT
		JMP	SHORT S2_RECV_EXIT
;*
;**	GET A CHARACTER
;*
S2_RECV3:
		CLI				; DISABLE INTERRUPT
		MOV	BX,[DI.RSB_GETP]	; GET GETP
		MOV	CX,[BX]			; GET DATA & STATUS
		ADD	BX,2
		CMP	BX,[DI.RSB_TAIL]		; GETP = TAILP ?
		JB 	S2_RECV4		; NO
		MOV	BX,[DI.RSB_HEAD]	; GETP := HEADP
S2_RECV4:
		MOV	[DI.RSB_GETP],BX	; SAVE GETP
		AND	[DI.RSB_FLAG],NOT F_FUL	; CLEAR BUFFER FULL
		DEC	[DI.RSB_CNT]		; DATA COUNT DECREMENT
;*
;**	X-PROTOCOL
;*
		MOV	AX,[DI.RSB_CNT]
		CMP	[DI.RSB_XON],AX
		JB	S2_RECV9
		TEST	[DI.RSB_FLAG],F_XSEND	; XON ENABLE ?
		JZ	S2_RECV9

		MOV	AL,C_XON
		CALL	S2_SS			; COUPUT CTL_Q
		CMP	AH,0
		JNZ	S2_RECV_EXIT
		AND	[DI.RSB_FLAG],NOT F_XSEND
S2_RECV9:
		MOV	AH,0
S2_RECV_EXIT:
		RET
S2_RECV		ENDP
	PAGE
;************************************************
;   COMMAND OUT					*
;						*
;	ENTRY: (AH)=5				*
;	       (AL)=COMMAND BYTE		*
;		BIT [7]: ------------		*
;		    [6]: INTERNAL RESET		*
;		    [5]: REQUEST TO SEND	*
;		    [4]: ERROR RESET		*
;		    [3]: SEND BREAK		*
;		    [2]: RECEIVER ENABLE	*
;		    [1]: DATA TERMINAL READY	*
;		    [0]: TRANSMITTER ENABLE	*
;	EXIT : (AH)=RETURN CODE			*
;************************************************
S2_OUTC		PROC	NEAR
		OUT	S2_CMD,AL		; OUTPUT 8251 COMMAND BYTE
		MOV	[DI.RSB_CMDS],AL	; SAVE 8251 COMMAND
		CLI				; DISABLE INTERRUPT
		TEST	AL,F_RESET		; INTERNAL RESET ?
		JNZ	S2_OUT2			; YES
		TEST	AL,F_RXE		; RX ENABLE ?
		JZ	S2_OUT3			; NO
S2_OUT1:
		CALL	MASK_OPEN		; INTERRUPT ENABLE
		JMP	SHORT S2_OUTC_EXIT
S2_OUT2:
		AND	[DI.RSB_FLAG],NOT F_INIT; CLEAR INITIALIZED
S2_OUT3:
		CALL	MASK_CLOSE		; INTERRUPT DISABLE
S2_OUTC_EXIT:
		MOV	AH,0
		RET
S2_OUTC		ENDP
	PAGE
;************************************************
;   STATUS					*
;						*
;	ENTRY: (AH)=6				*
;	EXIT : (AH)=RETURN CODE			*
;	       (CH)=8251 STATUS	BYTE		*
;		BIT [7]: DATA SET READY		*
;		    [6]: BREAK DETECT		*
; 	 	    [5]: FRAMING ERROR		*
;		    [4]: OVERRUN ERROR		*
;		    [3]: PARITY ERROR		*
;		    [2]: TRANSMITTER EMPTY	*
;		    [1]: RECEIVER READY		*
;		    [0]: TRANSMITTER READY	*
;	       (CL)=SYSTEM_PORT	(8255) STATUS	*
;		BIT [7]: 0-CI			*
;		    [6]: 0-CLEAR TO SEND (CS)	*
;		    [5]: 0-CARRIER DETECT (CD)	*
;		    [4]-[0]: ----		*
;************************************************
S2_STAT		PROC	NEAR
		IN	AL,S2_STS		; READ 8251 STATUS BYTE
		MOV	CH,AL
		NOP
		IN	AL,S2_INTR		; READ SYSTEM_PORT STATUS
		MOV	CL,AL
		MOV	AH,0
		RET
S2_STAT		ENDP
	PAGE
;************************************************
;   GET	DTL					*
;						*
;	ENTRY: (AH)=2				*
;	EXIT : (AH)=RETURN CODE			*
;	       (CX)=DATA LENGTH			*
;************************************************
S2_GETDL	PROC	NEAR
		MOV	CX,[DI.RSB_CNT]		; GET DATA COUNTER
		MOV	AH,0
		RET				; RETURN TO MAIN ROUTINE
S2_GETDL	ENDP
	PAGE
;****************************************************************
;   INITIALIZE THE PORT						*
;								*
;	ENTRY: (AH)=0 OR 1					*
;	       (AL)=TRANSFER RATE				*
;		  	(AL): 0 --   75 BAUD			*
;			      1 --  150				*
;			      2 --  300				*
;			      3 --  600				*
;			      4 -- 1200				*
;			      5 -- 2400				*
;			      6 -- 4800				*
;			      7 -- 9600				*
;			      >7 --- TREAT 1200 BAUD		*
;	       (CH)=8251 MODE BYTE				*
;		  BIT  7 - 6     5 - 4     3 - 2     1 - 0	*
;		       STOP BIT  PARITY    BIT/CHAR  BAUD RATE	*
; 			00: --    X0: NONE  00: 5     00: --	*
;			01: 1     01: ODD   01: 6     01: --	*
;   			10: 1.5   11: EVEN  10: 7     10: X16	*
;			11: 2               11: 8     11: X64	*
;	       (CL)=8251 COMMAND BYTE				*
;	       (ES)=BUFFER SEGMENT				*
;	       (DI)=BUFFER OFFSET				*
;	       (DX)=BUFFER SIZE					*
;	       (BH)=SEND TIME OUT (*500MS)			*
;	       (BL)=RECEIVE TIME OUT (*500MS)			*
;	EXIT : (AH)=RETURN CODE					*
;****************************************************************
S2_INIT		PROC	NEAR
S2_INIT1:
		CLI
		MOV	[DI.RSB_FLAG],00H	; X-PROTOCOL DISABLE
		JMP     SHORT	S2_INIT3
;
S2_INIT2:
		CLI
		MOV	[DI.RSB_FLAG],F_XE	; X-PROTOCOL ENABLE
S2_INIT3:
		PUSH	AX			; SAVE BAUD RATE
;****************************************
;*	INTIALIZE MEMORY OF COMMON WORK	*
;****************************************
		MOV	WORD PTR[DI-2],0	; CLEAR	INTERFACE FIELD
		MOV	[DI.RSB_CMDS],CL	; SAVE 8251 COMMAND
		MOV	[DI.RSB_STIM],BH
		MOV	[DI.RSB_RTIM],BL
;
		MOV	AX,DX
		SHR	AX,1
		SHR	AX,1
		MOV	BX,AX
		SHR	AX,1
		ADD	BX,AX
		MOV	[DI.RSB_XON],AX		; SET 1/4
		MOV	[DI.RSB_XOFF],BX	; SET 3/4
		LEA	BX,[DI.RSB_OFST]
		ADD	DX,BX
		MOV	[DI.RSB_HEAD],BX	; SET BUFFER HEAD POINTER
		MOV	[DI.RSB_TAIL],DX	; SET BUFFER TAIL POINTER
		MOV	[DI.RSB_CNT],0		; CLEAR COUNTER
		MOV	[DI.RSB_PUTP],BX	; PUT POINTER
		MOV	[DI.RSB_GETP],BX	; GET POINTER

		MOV	[RS_S2_FLAG],0
		TEST	CH,04H			; 7 BITS ?
		JNZ	S2_INIT36
		OR	[RS_S2_FLAG],F_SE
S2_INIT36:

		CALL	MASK_CLOSE

		POP	AX
		STI
;****************************************
;*	SET MODE AND BOUD RATE		*
;****************************************

;
;	BOUD RATE
;
		TEST	CH,01H			;  CH(01) ON --- X64
		JZ	S2_INIT4		;  CH(01) OFF -- X16
		ADD	AL,2			; SET X64 TABLE OFFSET
S2_INIT4:
;
		CMP	AL,08H
		JB	S2_INIT5
		MOV	AL,04H			; DEFALT = 1200
S2_INIT5:
		MOV	SI,OFFSET CLKCNT_8MHZ
		CBW
		SHL	AL,1			; WORD OFFSET
		ADD	SI,AX

		MOV	AL,S2_TIMMOD		; SET 8253 MODE	INSTRUCTION.
		OUT	TIME_MODE,AL
		MOV	AX,CS:[SI]		; GET
		NOP
		OUT	TIME_CNT,AL		; OUTPUT COUNTER LSB
		MOV	AL,AH
		NOP
		OUT	TIME_CNT,AL		; OUTPUT COUNTER MSB
;
;	MODE INSTRUCTION AND COMMAND
;
;----------------------------------------------------------------10/03/1984-----
		MOV	AL,0			; OUTPUT DUMMY COMMAND
		OUT	S2_MODE,AL
		PUSH	AX
		POP	AX
		MOV	AL,0
		OUT	S2_MODE,AL
		PUSH	AX
		POP	AX
		MOV	AL,0
		OUT	S2_MODE,AL
;		MOV	AL,02H			; SET DUMMY MODE
;		OUT	S2_MODE,AL	
;-------------------------------------------------------------------------------
		PUSH	AX			; TIME DELAY
		POP	AX
		MOV	AL,F_RESET		; 8251 COMMAND BYTE
		OUT	S2_CMD,AL		; [ INTERNAL RESET ]
		PUSH	AX			; TIME DELAY
		POP	AX
		MOV	AL,CH
		OUT	S2_MODE,AL		; OUTPUT 8251 MODE BYTE
		PUSH	AX			; TIME DELAY
		POP	AX
		MOV	AL,CL
		OUT	S2_CMD,AL		; OUTPUT 8251 COMMAND BYTE

		TEST	AL,F_RESET		; CMD(IR) ON ?
		JNZ	S2_INIT8		; YES
		OR	[DI.RSB_FLAG],F_INIT	; GET INIT FLAG
		TEST	AL,F_RXE		; CMD(RXE) ON ?
		JZ	S2_INIT8		; NO
		CALL	MASK_OPEN
		STI
S2_INIT8:
		MOV	AH,0			; RETURN CODE =	0
		RET				; RETURN TO MAIN ROUTINE
S2_INIT		ENDP
	PAGE
;****************************************
;*					*
;*	RS232C INTERRUPT DISABLE	*
;*					*
;*	INPUT/OUTPUT NONE		*
;*					*
;****************************************
MASK_CLOSE	PROC	NEAR
		CLI				; DISABLE INTERRUPT
		MOV	AL,000H			; CLOSE ALL MASK
		OUT	S2_MASK,AL
		IN	AL,SYS_PORT
		AND	AL,03H
		CBW
		SHL	AX,1
		SHL	AX,1
		MOV	SI,OFFSET S2_BIT_TBL
		ADD	SI,AX
		MOV	DX,CS:[SI.PORT]
		IN	AL,DX
		OR	AL,CS:[SI.MASKON]
		OUT	DX,AL
		RET
MASK_CLOSE	ENDP
;****************************************
;*					*
;*	RS232C INTERRUOT ENABLE		*
;*					*
;*	INPUT/OUTPUT	NONE		*
;*					*
;****************************************
MASK_OPEN	PROC	NEAR
		CLI				; DISABLE INTERRUPT
		MOV	AL,001H			; OPEN ONLY RECEIVE READY
		OUT	S2_MASK,AL
		IN	AL,SYS_PORT
		AND	AL,03H
		CBW
		SHL	AX,1
		SHL	AX,1
		MOV	SI,OFFSET S2_BIT_TBL
		ADD	SI,AX
		MOV	DX,CS:[SI.PORT]
		IN	AL,DX
		AND	AL,CS:[SI.MASKOFF]
		OUT	DX,AL
		RET
MASK_OPEN	ENDP
	PAGE
;************************************************
;   EXTRS_INT					*
;	RECEIVE INTERRUPT ENTRY			*
;						*
;************************************************
;****************************************************************
; RS_S2_FLAG							*
;	BIT  7  6  5  4  3  2  1  0				*
;	     I        I        I				*
;	     I        I        0:CH0 -- SI STATE (SEND)		*
;	     I        I        1:CH1 -- SO STATE (SEND)		*
;	     I        I						*
;	     I	      I						*
;	     I	      0:CH0 -- SI STATE (RECEIVE)		*
;	     I	      1:CH0 -- SO STATE (RECEIVE)		*
;	     0:CH0 -- SISO OP. DISABLE				*
;	     1:CH0 -- SISO OP. ENABLE				*
;								*
;****************************************************************
S2_INT		PROC	NEAR
		PUSH	AX
		PUSH	BX
		PUSH	CX
		PUSH	DX
		PUSH	SI
		PUSH	DI
		PUSH	ES
		PUSH	DS
;
;	GET COMMON WORK AREA
;
		MOV	AX,SYSCOM
		MOV	ES,AX			; COMMON AREA BASE SET TO ES
		LDS	DI,DWORD PTR [RS_S2_OFST]
		ADD	DI,2
;****************************************
;*	READ DATA AND STATUS		*
;****************************************
		IN	AL,S2_INTR		; GET STATUS FROM SYSTEMPORT (8255)
		TEST	AL,80H			; DATA RECEIVE ?
		JZ	S2_INT1			; NO
		MOV	AH,AL			; SAVE
		SHL	AH,1
		MOV	CL,6
		SHR	AH,CL
		IN	AL,S2_STS		; GET STATUS FROM USART (8251)
		AND	AL,0FCH
		OR	AH,AL
;
;	ERROR CHECK
;
		TEST	AH,38H			; FE,OE,PE ON ?
		JZ	S2_INT18			; ALL '0'
S2_INT1:
		MOV	AL,[DI.RSB_CMDS]	; COMMAND BYTE
		OR	AL,10H			; ER ON	(ERROR RESET)
		OUT	S2_CMD,AL
		JMP	S2_INT_EXIT
S2_INT18:
		IN	AL,S2_DATA		; GET DATA FROM	8251
		XCHG	AL,AH
;****************************************
;*	CHECK CONTROL CHARACTER		*
;****************************************
;
;	XON AND XOFF
;
		TEST	[DI.RSB_FLAG],F_XE
		JZ	S2_INT27
		CMP	AH,C_XOFF		; CNTL_S
		JNZ	S2_INT25

		OR	[DI.RSB_FLAG],F_XRECV	; SET XOFF RECEIVE
		JMP	S2_INT_EXIT
S2_INT25:
		CMP	AH,C_XON
		JNZ	S2_INT27
		AND	[DI.RSB_FLAG],NOT F_XRECV
		JMP	S2_INT_EXIT
S2_INT27:
;
;	SHIFT IN AND SHIFT OUT
;
		TEST	[RS_S2_FLAG],80H	; SHIFT OP. ENABLE ?
		JZ	S2_INT4			; NO
		CMP	AH,C_SO			; SO DATA
		JNZ	S2_INT32
		OR	[RS_S2_FLAG],F_SRECV	; SET S0 STATE
		JMP	SHORT S2_INT_EXIT
S2_INT32:
		CMP	AH,C_SI			; SI DATA ?
		JNZ	S2_INT35
		AND	[RS_S2_FLAG],NOT F_SRECV; SET SI STATE
		JMP	SHORT S2_INT_EXIT
S2_INT35:
		AND	AH,7FH			; CLEAR 2**7 BIT
		CMP	AH,1FH			; CONTROL CODE ?
		JBE	S2_INT4			; YES, (NO CONVERSION)
		TEST	[RS_S2_FLAG],F_SRECV	; SI STATE ?
		JZ	S2_INT4			; YES
		OR	AH,80H			; SO STATE (2**7 BIT ON)

S2_INT4:
;****************************************
;*	SET DATA TO RECEIVE BUFFER	*
;****************************************
		CLI
		TEST	[DI.RSB_FLAG],F_FUL	; BUFFER FULL ?
		JZ	S2_INT50
		OR	[DI.RSB_FLAG],F_OVER
		JMP	SHORT S2_INT_EXIT

S2_INT50:
		MOV	BX,[DI.RSB_PUTP]	; PUT POINTER
		MOV	[BX],AX			; SET DATA AND STATUS
		ADD	BX,2
		CMP	BX,[DI.RSB_TAIL]
		JB	S2_INT55
		MOV	BX,[DI.RSB_HEAD]
S2_INT55:
		MOV	[DI.RSB_PUTP],BX
		INC	[DI.RSB_CNT]		; DATA COUNTER 1 UP
		CMP	BX,[DI.RSB_GETP]	; BUFFER FULL ?
		JNE	S2_INT6
		OR	[DI.RSB_FLAG],F_FUL	; SET BUFFER FULL
S2_INT6:
;****************************************
;*	X_PROTOCOL			*
;****************************************
		MOV	AX,[DI.RSB_CNT]
		CMP	AX,[DI.RSB_XOFF]	; COUNTER G.E 3/4BUFFER	SIZE ?
		JB	S2_INT7			; NO
		TEST	[DI.RSB_FLAG],F_XE
		JZ	S2_INT7
		TEST	[DI.RSB_FLAG],F_XSEND	;
		JNZ	S2_INT7

		IN	AL,S2_STS
		TEST	AL,F_TXR		; READY TX ?
		JZ	S2_INT7
		MOV	AL,C_XOFF
		OUT	S2_DATA,AL

		OR	[DI.RSB_FLAG],F_XSEND
S2_INT7:
		OR	BYTE PTR [DI-2],80H	; SET 'INT' FLAG
S2_INT_EXIT:
		POP	DS
		POP	ES
		POP 	DI
		POP	SI
		POP	DX
		POP	CX
		POP	BX
		POP	AX
		RET				; RETURN
S2_INT		ENDP
;****************************************
;*	PROGRAM	END			*
;****************************************
EXTRS_END	LABEL	FAR
ROM 	ENDS
	END
