		PAGE	58,132
		TITLE	AUXRAM
;****************************************************************
;*								*
;*	AUX DEVICE DRIVER					*
;*								*
;*		SEND/RECEIVE DATA ON RS232C. (1BYTE)		*
;*								*
;*		IF RECEIVE BUFFER FULL, SEND XON CODE.		*
;*		( STOPED SEND DATA )				*
;*		IF RESTART, SEND XOFF CODE.			*
;*								*
;*								*
;****************************************************************
;	MAR/27/84
;	MAY/17/84	APPEND INFINITE LOOP
;	JUN/06/84	DELETE INIT COMMAND PROCESS
;	JLY/27/84	DELETE AUX2
;	OCT/03/84	CHANGE 8251 INITIALIZE
		PAGE
;****************************************
;*	EXTERNAL LABEL AND SYMBOL	*
;****************************************
		EXTRN	ENTRY:NEAR	; DISPATCH ROUTINE ENTRY POINT
		EXTRN	NORMAL_EXIT:NEAR; NORMAL END
		EXTRN	BUSY_EXIT:NEAR	; DEVICE BUSY END
		EXTRN	ERROR_EXIT:NEAR	; ERROR END EXIT
		EXTRN	CMDERR_EXIT:NEAR; COMMAND ERROR END

		EXTRN	PTRSAV:DWORD	; PACKET POINTER SAVE ADDRESS
;****************************************
;*	EQUATE TABLE			*
;****************************************
AUX_INTR	EQU	0CH		; AUX INTERRUPT
AUX_ROM		EQU	1AH		; INTERRUPT VECTOR OF AUX I/O
;****************************************
;*		STRUCTURE BLOCK	 	*
;****************************************
IODAT		STRUC			; PACKET TABLE
CMDLEN		DB	?		;	LENGTH OF COMMAND
UNIT		DB	?		;	SUB UNIT SPECIFIER
CMD		DB	?		;	COMMAND CODE
STATUS		DW	?		;	STATUS
		DB	8 DUP (?)
MEDIA		DB	?
TRANS		DD	?		;	TRANSFER ADDRESS
COUNT		DW	?		;	COUNT OF BLOCKS OR CHARACTERS
START		DW	?		;	FIRST BLOCK TO TRANSFER
IODAT		ENDS
;--------------------------------------------DELETE JLY/27/84---------
		PAGE
;****************************************************************
;*								*
;*	"DOS" AND "BIOS" INTERFACE MODULES.			*
;*								*
;****************************************************************
CODE		SEGMENT	WORD PUBLIC 'CODES'
		ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
;****************************************
;*	GLOBAL LABEL AND SYMBOL		*
;****************************************
	PUBLIC	AUX_INT
;-------------------------------------------DELETE JLY/27/84-----------
	PUBLIC	AUX_DCT
;--------------------------------------------DELETE JLY/27/84----------
	PUBLIC	AUX_WRITE
;--------------------------------------------DELETE JLY/27/84----------
	PUBLIC	AUX_O_STATUS
;--------------------------------------------DELETE JLY/27/84----------
;---------------------------------------------INSERT JUN/07/84---------
	PUBLIC	AUXROM_ADR
	PUBLIC	RS232C_IO_INT
;----------------------------------------------------------------------
;********************************************************
;*							*
;*	TABLE BLOCKS (READ ONLY)			*
;*							*
;********************************************************
;
;****************************************
;*	DESPATCH TABLE FOR DEVICES	*
;****************************************
AUX_TBL		LABEL	WORD
		DW	NORMAL_EXIT	; 0 - INIT ---CHG JUN/7/84-----
		DW	CMDERR_EXIT	; 1 - MEDIA CHECK (NOT USED)
		DW	CMDERR_EXIT	; 2 - GET BPB (NOT USED)
		DW	CMDERR_EXIT	; 3 - IO CTRL INPUT
		DW	AUX_READ	; 4 - DESTRUCTIVE READ
		DW	AUX_RDND	; 5 - NON-DESTRUCTIVE READ
		DW	NORMAL_EXIT	; 6 - INPUT STATUS
		DW	AUX_FLUSH	; 7 - FLUSH INPUT BUFFER
		DW	AUX_WRITE	; 8 - WRITE
		DW	AUX_WRITE	; 9 - WRITE & VERIFY
		DW	AUX_O_STATUS	;10 - WRITE STATUS
		DW	NORMAL_EXIT	;11 - OUTPUT STATUS
		DW	NORMAL_EXIT	;12 - IO CTL OUTPUT

		PAGE
;********************************************************
;*							*
;*	MODULE NAME	AUX_INT			 	*
;*							*
;*	FUNCTION	AUX I/O CONTROL			*
;*							*
;*	INPUT/OUTPUT	NONE				*
;*							*
;********************************************************
AUX_INT		PROC	FAR
		PUSH	SI		; ALL REGISTER SAVE
		MOV	SI,OFFSET AUX_TBL
		JMP	ENTRY
AUX_INT		ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	AUX_READ			*
;*							*
;*	FUNCTION	RECEIVE MULTI CHARACTER		*
;*			ON RS232C			*
;*							*
;*	INPUT		ES:DI	DATA STORE ADDRESS	*
;*			CX	DATA LENGTH		*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
AUX_READ	PROC	NEAR
		JCXZ	AUX_READ_RET	; CHARACTER NONE ?
AUX_READ10:
		PUSH	CX
		CALL	S0IN		; AUXSOL READ
		POP	CX
		CMP	AH,4		; BUSY ?
		JZ	AUX_READ80
		CMP	AH,0		; ERROR ?
		JNZ	AUX_READ90
		STOSB
		LOOP	AUX_READ10
AUX_READ_RET:
		JMP	NORMAL_EXIT
AUX_READ80:
		JMP	BUSY_EXIT
AUX_READ90:
		MOV	AL,2		; DEVICE NOT READY
		JMP	ERROR_EXIT
AUX_READ	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	AUX_RDND			*
;*							*
;*	FUNCTION	NON-DESTRUCTIVE READ		*
;*							*
;*	INPUT		NONE				*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
AUX_RDND	PROC	NEAR
		CALL	S0RDND		; SENCE READ ENABLE
		CMP	AH,4
		JZ	AUX_RDND80
		CMP	AH,0
		JNZ	AUX_RDND90
		LDS	BX,[PTRSAV]
		MOV	[BX.MEDIA],AL	; SET READ CHARACTER
		JMP	NORMAL_EXIT
AUX_RDND80:
		JMP	BUSY_EXIT
AUX_RDND90:
		MOV	AL,2
		JMP	ERROR_EXIT
AUX_RDND	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	AUX_FLUSH			*
;*							*
;*	FUNCTION	AUX INPUT BUFFER CLEAR		*
;*							*
;*	INPUT		NONE				*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
AUX_FLUSH	PROC	NEAR
		CALL	S0FLUSH		; AUX READ BUFFER CLEAR
		JMP	NORMAL_EXIT
;
AUX_FLUSH	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	AUX_WRITE			*
;*							*
;*	FUNCTION	SEND MULTI CHARACTER ON RS232C	*
;*							*
;*	INPUT		ES:DI	DATA STORE ADDRESS	*
;*			CX	DATA LENGTH		*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
AUX_WRITE	PROC	NEAR
		JCXZ	AUX_WRIT_RET	; OUTPUT CHARACTER NONE ?
AUX_WRIT10:
		PUSH	CX
		MOV	CL,ES:[DI]	; GET CHARACTER
		INC	DI
		CALL	S0OUT		; OUTPUT CHARACTER
		POP	CX
		CMP	AH,4
		JZ	AUX_WRIT80
		TEST	AH,01H
		JNZ	AUX_WRIT90
		LOOP	AUX_WRIT10
AUX_WRIT_RET:
		JMP	NORMAL_EXIT
AUX_WRIT80:
		JMP	BUSY_EXIT
AUX_WRIT90:
		MOV	AL,2
		JMP	ERROR_EXIT
AUX_WRITE	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	AUX_O_STATUS			*
;*							*
;*	FUNCTION	RS232C STATUS READ		*
;*							*
;*	INPUT		NONE				*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
AUX_O_STATUS	PROC	NEAR
		CALL	S0SENCE		; SENCE RS232C
		CMP	AH,4
		JZ	AUX_O_STS80
		TEST	AH,01H
		JNZ	AUX_O_STS90
		JMP	NORMAL_EXIT
AUX_O_STS80:
		JMP	BUSY_EXIT
AUX_O_STS90:
		MOV	AL,2
		JMP	ERROR_EXIT
AUX_O_STATUS	ENDP
		PAGE
;****************************************************************
;*								*
;*								*
;*	MS-DOS V2.00  RS-232C DRIVER				*
;*								*
;*		( MEMORY IS RAM )				*
;*								*
;****************************************************************

;****************************************
;*	EQUATE TABLE			*
;****************************************

AUX_FNC_INIT1	EQU	0		; INITIALIZE 1 (XON/XOFF DISABLE)
AUX_FNC_INIT2	EQU	1		; INITIALIZE 2 (XON/XOFF ENABLE)
AUX_FNC_GETDL	EQU	2		; GET RECEIVE DATA LENGTH
AUX_FNC_SEND	EQU	3		; SEND   A CHARACTER
AUX_FNC_RECV	EQU	4		; RECEIVE A CHARACTER
AUX_FNC_CMDO	EQU	5		; RS232C COMMAND OUTPUT
AUX_FNC_STAT	EQU	6		; READ RS232C STATUS

XON		EQU	13H
XOFF		EQU	11H

RS_BUF_SIZE	EQU	256 * 2
	PAGE
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	EVEN
;************************************************
;*						*
;*	WORK AREA (RAM)				*
;*						*
;*		RS232C BUFFER			*
;*						*
;************************************************
AUX_DCT		LABEL	WORD
;****************************************
;*	FOR AUX				*
;****************************************
		DD	RS232C_WORK
		DW	RS_BUF_SIZE
		DB	0,0		; TIME OUT SECOND ON SEND AND RECEIVE
		DB	0,0		; MODE INSTRUCTION OF UPD8251 AND BAUD RATE
		DB	6 DUP (0)	; RESEARVE
;-----------------------------------------------INSERT JLY/27/84-------

		DD	-1
		DW	0
		DB	0,0
		DB	0,0
		DB	6 DUP (0)	; RESEARVE

		DD	-1
		DW	0
		DB	0,0
		DB	0,0
		DB	6 DUP (0)	; RESEARVE
;----------------------------------------------------------------------


RS232C_WORK	LABEL	BYTE
		DB	0,0		; DUMMY
RSB_FLAG	DB	10H		; FLAG
					;	BIT7 = INITIALIZED
					;	6 = OVERFLOW
					;	5 = BUFFER FULL
					;	4 = XON/XOFF ENABLE
					;	3 = XON SEND
					;	2 = XON RECEIVE
					;	1 = NONE
					;	0 = NONE
RSB_CMDS	DB	37H		; RS232C COMMAND (UPD825)
RSB_STIM	DB	02H		; TIME OUT OF SEND ( 1 SEC)
RSB_RTIM	DB	3CH		; TIME OUT OF RECEIVE (30SEC)
RSB_XON		DW	RS_BUF_SIZE/8	; DATA COUNT WHEN XON SEND
RSB_XOFF	DW	RS_BUF_SIZE/8*3	; DATA COUNT WHEN XOFF SEND
RSB_HEAD	DW	RS232C_BUFFER	; BUFFER HEAD ADDRESS
RSB_TALE	DW	RS232C_BUFFER+RS_BUF_SIZE
					; BUFFER TALE ADDRESS
RSB_CNT		DW	0		; DATA COUNT OF QUING BUFFER
RSB_PUTP	DW	RS232C_BUFFER	; RECEIVE DATA PUT ADDRESS
RSB_GETP	DW	RS232C_BUFFER	; RECEIVE DATA GET ADDRESS
;
RS232C_BUFFER	DB	RS_BUF_SIZE DUP (0)
	PAGE
;****************************************************************
;*								*
;*   AUXILIARY INPUT/OUTPUT					*
;*								*
;****************************************************************
;************************************************
;*						*
;*	DATA SEND				*
;*						*
;*	INPUT	CL=SEND DATA			*
;*						*
;*	OUTPUT	AH=RETURN INFORMATION		*
;*		=0, NORMAL END			*
;*		=1, NOT INTILIZED		*
;*		=2, RECEIVE BUFFER OVERFLOW	*
;*		=3, TIME OUT			*
;*		=4, BUSY			*
;*						*
;*						*
;************************************************
;=====
S0OUT		PROC	NEAR
;=====
		MOV	AL,CL
		MOV	AH,AUX_FNC_SEND
		INT	AUX_ROM		; SEND A CHARACTER
		RET
S0OUT		ENDP
		PAGE
;************************************************
;*						*
;*	DATA RECEIVE				*
;*						*
;*	INPUT	NONE				*
;*						*
;*	OUTPUT	AL=RECEIVE DATA			*
;*		AH=RETURN INFORMATION		*
;*		=0, NORMAL END			*
;*		=1, NOT INTILIZED		*
;*		=2, RECEIVE BUFFER OVERFLOW	*
;*		=3, TIME OUT			*
;*		=4, BUSY			*
;*						*
;*						*
;************************************************
;====
S0IN		PROC	NEAR
;====

		MOV	AH,AUX_FNC_RECV		; GET RECEIVE DATA
		INT	AUX_ROM
		MOV	AL,CH
		RET
S0IN		ENDP
		PAGE
;************************************************
;*						*
;*	READ NON-DESTRUCTIVE			*
;*						*
;*	INPUT	NONE				*
;*						*
;*	OUTPUT	ZF	ON=READY, ON=BUSY	*
;*		AH=RETURN INFORMATION		*
;*		=0, NORMAL END			*
;*		=1, NOT INTILIZED		*
;*		=2, RECEIVE BUFFER OVERFLOW	*
;*		=3, TIME OUT			*
;*		=4, BUSY			*
;*						*
;*						*
;*						*
;************************************************
;======
S0RDND		PROC	NEAR
;======
		PUSH	CX
		MOV	AH,AUX_FNC_GETDL	; GET RECEIVE DATA LENGTH
		INT	AUX_ROM

		CMP	AH,0		; ERROR ?
		JNZ	S0RDND_RET
		CMP	CX,0		; DATA NONE ?
		JZ	S0RDND90
;
		MOV	SI,[RSB_GETP]	; GET DATA
		INC	SI
		LODSB
S0RDND_RET:
		POP	CX
		AND	AH,AH
		RET
S0RDND90:
		MOV	AH,4
		JMP	S0RDND_RET
S0RDND		ENDP
	PAGE
;************************************************
;*						*
;*	CHECK TRANSFER STATUS			*
;*						*
;*	INPUT	NONE				*
;*	OUTPUT					*
;*		AH=RETURN INFORMATION		*
;*		=0, NORMAL END			*
;*		=1, NOT INTILIZED		*
;*		=2, RECEIVE BUFFER OVERFLOW	*
;*		=3, TIME OUT			*
;*		=4, BUSY			*
;*						*
;*						*
;************************************************
;=====
S0SENCE		PROC	NEAR
;=====
		PUSH	CX
		MOV	AH,AUX_FNC_STAT
		INT	AUX_ROM

		CMP	AH,0
		JNZ	S0SENCE_RET
		TEST	CH,01H		; TXRDY
		JZ	S0SENCE90

S0SENCE_RET:
		POP	CX
		RET
S0SENCE90:
		MOV	AH,4
		JMP	S0SENCE_RET
S0SENCE		ENDP
		PAGE
;************************************************
;*						*
;*	RS232C RECEIVE BUFFER CLEAR		*
;*						*
;*	INPUT	NONE				*
;*						*
;*	OUTPUT	NONE				*
;*						*
;************************************************
;=======
S0FLUSH		PROC	NEAR
;=======
		CLI
		MOV	[RSB_PUTP],OFFSET RS232C_BUFFER
		MOV	[RSB_GETP],OFFSET RS232C_BUFFER
		MOV	[RSB_CNT],0

		MOV	AH,0
		MOV	AL,[RSB_FLAG]
		AND	[RSB_FLAG],090H
		TEST	AL,08H
		JZ	S0FLUSH60
		STI
		MOV	CL,XON		; ^Q (XON)
		CALL	S0OUT
S0FLUSH60:
		STI
		RET
S0FLUSH		ENDP
;------------------------------------DELETE "AUX_INIT"MODULE- JUN/07/84
;--------------------------------------------DELETE JLY/27/84----------
	PAGE
;----------------------------------------------INSERT MAY/17/84--------
;********************************************************
;*							*
;*	USURP AUXROM INTERRUPT (INT 1AH).		*
;*	SEND RETRY IF TIMEOUT AND TIMEOUT COUNTER = 0	*
;*	RECEIVE RETRY IF TIMEOUT AND TIMEOUT COUNTER = 0*
;*	SET TIMEOUT COUNTER AND FLAG WHEN INTIALIZATION	*
;*							*
;********************************************************
;
;	WORK AREA
;
;----------------------------------------------------DELETE JUN/07/84--
SAVE_AUX	LABEL	WORD		; SAVE PARAMETER
		DB			;  OUTPUT DATA
SAVE_AUX_CMD	DB	?		;  COMMAND CODE
R_NO_TIMEOUT	DB	0		; RETRY FLAG IF TIMEOUT OF SEND
S_NO_TIMEOUT	DB	0		; RETRY FLAG IF TIMEOUT OF RECEIVE
AUXROM_ADR	DD	RS232C_IO_INT	; POINTER OF AUXROM PROGRAM

	ASSUME	CS:CODE,DS:NOTHING,ES:NOTHING,SS:NOTHING
;************************************************
;*						*
;*	MODULE	INT 1AH PROCESS			*
;*						*
;*	FUNCTION	INFINITE LOOP IF TIMEOUT*
;*						*
;*	INPUT		AH=COMMAND CODE		*
;*			BL=TIMEOUT COUNT OF RECV*
;*			BH=TIMEOUT COUNT OF SEND*
;*			ES:DI=PARAMETER ADDRESS	*
;*						*
;*	OUTPUT		AH=RETURN INF.		*
;*						*
;************************************************
RS232C_IO_INT	PROC	FAR
		MOV	[SAVE_AUX],AX		; SAVE AUX PARAMETER
;----------------------------------------------------------------10/03/1984-----
		CMP	AH,AUX_FNC_INIT2
		JA	IO_INT0
		CLI
		IN	AL,35H			; MASK IR
		AND	AL,0F8H
		OUT	35H,AL
		NOP
		NOP
		IN	AL,02H			; MASK 8259
		OR	AL,10H
		OUT	02H,AL
		STI
		MOV	AL,0			; INITIALIZE 8251
		OUT	32H,AL
		PUSH	AX
		POP	AX
		MOV	AL,0
		OUT	32H,AL
		PUSH	AX
		POP	AX
		MOV	AL,0
		OUT	32H,AL
IO_INT0:
;------------------------------------------------------------------------------
IO_INT1:
		MOV	AX,[SAVE_AUX]		; GET PARAMETER
		PUSHF
		CALL	[AUXROM_ADR]		; GO TO AUXROM PROGRAM
;
;	SEND
;
		CMP	[SAVE_AUX_CMD],AUX_FNC_SEND
		JNZ	IO_INT2
		CMP	AH,03H			; TOMEOUT ?
		JNZ	IO_INT_EXIT
		TEST	[S_NO_TIMEOUT],1	; INFINITE LOOP ?
		JZ	IO_INT_EXIT
		JMP	IO_INT1
;
;	RECEIVE
;
IO_INT2:
		CMP	[SAVE_AUX_CMD],AUX_FNC_RECV
		JNZ	IO_INT3
		CMP	AH,03H			; TOMEOUT ?
		JNZ	IO_INT_EXIT
		TEST	[S_NO_TIMEOUT],1	; INFINITE LOOP ?
		JZ	IO_INT_EXIT
		JMP	IO_INT1
;
;	INITIALIZE
;
IO_INT3:
		CMP	[SAVE_AUX_CMD],AUX_FNC_INIT2
		JA	IO_INT_EXIT

		AND	[S_NO_TIMEOUT],NOT 01H
		AND	[R_NO_TIMEOUT],NOT 01H
		CMP	BH,0			; INFINITE LOOP WHEN SEND ?
		JNZ	IO_INT4
		MOV	BYTE PTR ES:[DI+4],-1
		OR	[S_NO_TIMEOUT],1

IO_INT4:
		CMP	BL,0			; INFINITE LOOP WHEN RECEIVE ?
		JNZ	IO_INT5
		MOV	BYTE PTR ES:[DI+5],-1
		OR	[R_NO_TIMEOUT],1

IO_INT5:
IO_INT_EXIT:
		IRET
RS232C_IO_INT	ENDP
;----------------------------------DELETE "AUXROM_INIT"MODULE JUN/07/84
;****************************************
;*	PROGRAM END			*
;****************************************
CODE		ENDS
		END
