	PAGE	60,132
	TITLE	'CLKRAM'
;	NOV/18/83
;	NOV/21/83
;	MAR/13/84

;****************************************
;*	EXTERNAL SYYMBOL		*
;****************************************
	EXTRN	NORMAL_EXIT:NEAR
	EXTRN	ENTRY:NEAR
	EXTRN	CMDERR_EXIT:NEAR
	EXTRN	BUSY_EXIT:NEAR
;****************************************
;*	EQUATE TABLE			*
;****************************************
CLK_ROM		EQU	1CH


CODE	SEGMENT	WORD PUBLIC 'CODES'
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

;****************************************
;*	PUBLIC SYYMBOL			*
;****************************************
		PUBLIC	CLK_INT
		PUBLIC	CLK_DCT
		PUBLIC	GETDATE		;--------MAR/13/84----
		PUBLIC	SETDATE		;--------MAR/13/84----
;************************************************
;*						*
;*	DATA					*
;*						*
;************************************************

;------------------------------------------------INC------MAR/13/84----
CLK_DCT		LABEL	WORD
		DD	-1	; RESEARVE FOR ALARM CLOCK CONTROL TABLE
		DD	-1	; RESEARVE
;----------------------------------------------------------------------
YEAR		DW	0
MONTH		DW	0
DAY		DW	0
WEEK		DW	0	; WEEK NUMBER
; 
CAL_TBL	LABEL	BYTE
T_YEAR		DB	0
T_MONTH		DB	0
T_DAY		DB	0
T_HOUR		DB	0
T_MIN		DB	0
T_SEC		DB	0
MONTH_TBL	DB	31,28,31,30,31,30,31,31,30,31,30,31

	PAGE
;************************************************
;*						*
;*      DISPATCH TABLE FOR DEVICE		*
;*						*
;************************************************
;
CLK_TBL:
	DW	NORMAL_EXIT
	DW	NORMAL_EXIT
	DW	NORMAL_EXIT
	DW	CMDERR_EXIT
	DW	CLK_READ
	DW	BUSY_EXIT
	DW	NORMAL_EXIT
	DW	NORMAL_EXIT
	DW	CLK_WRIT
	DW	CLK_WRIT
	DW	NORMAL_EXIT
	DW	NORMAL_EXIT
	DW	NORMAL_EXIT

	PAGE
;************************************************
;*						*
;*	MSDOS INTERFACE PROGRAM			*
;*						*
;************************************************
;
;
CLK_INT:
	PUSH	SI
	MOV	SI,OFFSET CLK_TBL
	JMP	ENTRY
;
;
CLK_READ:
	CALL	GETDATE
	STOSW
	MOV	AX,CX
	STOSW
	MOV	AX,DX
	STOSW
	JMP	NORMAL_EXIT
;
;
CLK_WRIT:
	MOV	SI,DI
	LODS	WORD PTR ES:[SI]
	CALL	SETDATE
	LODS	WORD PTR ES:[SI]
	MOV	CX,AX
	LODS	WORD PTR ES:[SI]
	MOV	DX,AX
	CALL	SETTIME
	JMP	NORMAL_EXIT

	PAGE
;
;TIME AND DATE
;
GETDATE:
	PUSH	ES			; SAVE ES
	PUSH	CS
	POP	ES			; ES <- CS
	PUSH	BX			;SAVE BX
	XOR	AH,AH			;SET GET COMMAND
	MOV	BX,OFFSET T_YEAR

	INT	CLK_ROM			;GET DATE FROM ROM BIO
	MOV	AL,T_YEAR		;GET YEAR (BCD)
	CALL	S_HEX
	CMP	AX,80			;AX >= 80 ?
	JAE	SKP_T			;JUMP IF SO
	ADD	AX,100
SKP_T:
	ADD	AX,1900			;COMPUTE YEAR
	MOV	YEAR,AX			;SAVE YEAR
	XOR	AH,AH
	MOV	AL,T_MONTH		;GET MONTH (HEX	OF HIGH	4BITS)
	MOV	CL,4
	SHR	AL,CL			;GET MONTH
	MOV	MONTH,AX		;SAVE MONTH
	MOV	AL,T_DAY		;GET DATE (BCD)
	CALL	S_HEX
	MOV	DAY,AX			;SAVE DATE
;COMPUTE NUMBER	OF DAYS	FROM 1/1/80
	MOV	BX,1980			;SET STARTING YEAR
	XOR	AX,AX
LOOP1:
	CALL	YEAR_CHK		;CHECK LEAP-YEAR
	CMP	BX,YEAR			;SAME YEAR?
	JE	G_MONTH			;JUMP IF SO
	ADD	AX,DX			;COMPUTE NUMBER	OF DAYS
	INC	BX			;INCREASE YEAR
	JMP	SHORT	LOOP1
G_MONTH:
	XOR	BX,BX			;CLEAR TABLE'S POINTER
	XOR	CH,CH
	DEC	WORD PTR MONTH
LOOP2:
	CMP	BX,MONTH		;SAME MONTH?
	JE	G_DAY			;JUMP IF SO
	MOV	CL,MONTH_TBL[BX]	;GET DAYS OF A MONTH
	ADD	AX,CX			;COMPUTE DAYS
	INC	BX			;INCREASE POINTER
	JMP	SHORT	LOOP2
G_DAY:
	ADD	AX,DAY
	DEC	AX			;GET NUMBER OF DAYS
	PUSH	AX			;SAVE AX
	MOV	AL,T_HOUR		;GET HOUR (BCD)
	CALL	S_HEX
	MOV	CH,AL			;SET HOUR
	MOV	AL,T_MIN		;GET MINUTE (BCD)
	CALL	S_HEX
	MOV	CL,AL			;SET MINUTE
	MOV	AL,T_SEC		;GET SECOND (BCD)
	CALL	S_HEX
	MOV	DH,AL			;SET SECOND
	XOR	DL,DL			;SET 0 FOR SEC/100
	POP	AX			;RESTORE AX
	POP	BX			;RESTORE BX
	POP	ES			; RESTORE ES
	RET

	PAGE
SETTIME:
	MOV	AL,CH			;GET HOUR
	CALL	CONV_BCD		;CONVERT TO BCD
	MOV	T_HOUR,AL		;SET HOUR
	MOV	AL,CL			;GET MINUTE
	CALL	CONV_BCD		;CONVERT TO BCD
	MOV	T_MIN,AL		;SET MINUTE
	MOV	AL,DH			;GET SECOND
	CALL	CONV_BCD		;CONVERT TO BCD
	MOV	T_SEC,AL		;SET SECOND
	PUSH	ES			;SAVE ES
	PUSH	BX			;SAVE BX
	MOV	AX,CS
	MOV	ES,AX			;ES <= CS
	MOV	BX,OFFSET CAL_TBL
	MOV	AH,01H			;SET SET COMMAND
	INT	CLK_ROM			;SET TIME
	POP	BX			;RESTORE BX
	POP	ES			;RESTORE ES
	RET

	PAGE
SETDATE:
	PUSH	ES
	PUSH	CS
	POP	ES			;ES <- CS
	PUSH	CX
	PUSH	DX
	PUSH	BX
	PUSH	AX
	CALL	GETDATE
	POP	AX			;RESTORE AX--NOV/18/83	
	PUSH	AX
	ADD	AX,2
	MOV	DX,0
	MOV	CX,7
	DIV	CX
	MOV	[WEEK],DX
	POP	AX
	MOV	BX,1980			;SET STARTING YEAR
	MOV	WORD PTR MONTH,1	;SET STARTING MONTH
LOOP3:
	CALL	YEAR_CHK		;CHECK LEAP-YEAR
	CMP	AX,DX
	JB	S_YEAR			;JUMP IF AX < DX
	INC	BX			;INCREASE YEAR
	SUB	AX,DX
	JMP	SHORT	LOOP3
S_YEAR:
	XCHG	AX,BX
	SUB	AX,1900
	CMP	AX,100
	JB	NOT_SUB
	SUB	AX,100
NOT_SUB:
	CALL	CONV_BCD		;CONVERT TO BCD
	MOV	T_YEAR,AL
	MOV	AX,BX
	XOR	BX,BX			;CLEAR TABLE'S POINTER
	XOR	CH,CH
LOOP4:
	MOV	CL,MONTH_TBL[BX]	;GET DAYS OF A MONTH
	CMP	AX,CX
	JB	S_MD			;JUMP IF AX < CX
	INC	WORD PTR MONTH		;INCREASE MONTH
	SUB	AX,CX
	INC	BX			;INCREASE POINTER
	JMP	SHORT	LOOP4
S_MD:
	INC	AL
	CALL	CONV_BCD		;CONVERT TO BCD
	MOV	T_DAY,AL		;SET DAY
	MOV	AX,MONTH
	MOV	CL,4
	SHL	AL,CL
	ADD	AL,BYTE PTR [WEEK]
	MOV	T_MONTH,AL		;SET MONTH
	MOV	BX,OFFSET CAL_TBL
	MOV	AH,01H			;SET SET COMMAND
	INT	CLK_ROM			;SET DATE
	POP	BX			;RESTORE BX
	POP	DX			;RESTORE DX
	POP	CX			;RESTORE CX
	POP	ES
	RET

	PAGE
;************************************************
;*						*
;*	MODULE NAME	YEAR_CHK		*
;*						*
;*	FUNCTION	CHECK LEAP YEAR		*
;*						*
;*	INPUT		AX=YEAR			*
;*			(from 1980 to 2079)	*
;*						*
;*	OUTPUT		DX=DAYS OF YEAR		*
;*						*
;*	REMARK		IF LEAP YEAR,		*
;*			DAYS OF FEBRARY IN	*
;*			"MONNTH_TBL" IS 29.	*
;*						*
;************************************************
YEAR_CHK:
	PUSH	AX			;SAVE AX
	PUSH	BX			;SAVE BX
	XOR	DX,DX
	MOV	AX,BX
	MOV	CX,4
	DIV	CX
	OR	DX,DX
	JNZ	COMN_Y			;JUMP IF COMMON-YEAR
	MOV	AX,BX
	MOV	CX,100
	DIV	CX
	OR	DX,DX
	JNZ	LEAP_Y			;JUMP IF LEAP-YEAR
	MOV	AX,BX
	MOV	CX,400
	DIV	CX
	OR	DX,DX
	JNZ	COMN_Y			;JUMP IF COMMON-YEAR
LEAP_Y:
	MOV	DX,366			;SET DAYS OF YEAR
	MOV	AL,29			;SET DAYS OF FEB.
	JMP	SHORT	S_FEB
COMN_Y:
	MOV	DX,365			;SET DAYS OF YEAR
	MOV	AL,28			;SET DAYS OF FEB.
S_FEB:
	MOV	BX,1
	MOV	MONTH_TBL[BX],AL	;SET FEB.
	POP	BX			;RESTORE BX
	POP	AX			;RESTORE AX
	RET
;************************************************
;*						*
;*	MODULE NAME	CONV_BCD		*
;*						*
;*	FUNCTION	BINARY CONVER TO BCD	*
;*						*
;*	INPUT		AX=BINARY		*
;*						*
;*	OUTPUT		AL=BCD			*
;*						*
;************************************************
CONV_BCD:
	PUSH	CX			;SAVE CX
	AAM				;CONVERT TO UNPACK BCD
	MOV	CL,4
	SHL	AL,CL
	SHR	AX,CL
	POP	CX			;RESTORE CX
	RET
;************************************************
;*						*
;*	MODULE	NAME	S_HEX			*
;*						*
;*	FUNCTION	BCD CONVERT TO BINATY	*
;*						*
;*	INPUT		AL=BCD			*
;*						*
;*	OUTPUT		AX=BINARY		*
;*						*
;************************************************
S_HEX:
	PUSH	CX
	XOR	AH,AH
	MOV	CL,4
	SHL	AX,CL
	SHR	AL,CL
	AAD
	XOR	AH,AH
	POP	CX
	RET


CODE	ENDS
	END



