		PAGE	58,132
		TITLE	CRTRAM		CONSOLE DRIVER OF A1
;************************************************************************
;*									*
;*	MODULE NAME	CRTRAM						*
;*									*
;*	FUNCTION	CONSOLE DRIVER PROGRAM.			 	*
;*			SYSTEM... MSD-A1				*
;*			OS NAME... MS_DOS 2.0 (FOR A1)			*
;*			THIS PROGRAM IS LINKED WITH OTHOR DRIVE PROGRAM	*
;*									*
;*									*
;************************************************************************
;	APR/17/84
;	APR/27/84
;	MAY/28/84
;	JUN/07/84	; DELETE INT COMMAND PROCESS
		PAGE
;****************************************
;*	EXTENAL SYMBOL AND LABEL	*
;****************************************
		EXTRN	ENTRY:NEAR
		EXTRN	BUSY_EXIT:NEAR
		EXTRN	CMDERR_EXIT:NEAR
		EXTRN	NORMAL_EXIT:NEAR
		EXTRN	COMMON_EXIT:NEAR
		EXTRN	PTRSAV:DWORD
		PAGE
;****************************************
;*		EQUATE BLOCK		*
;****************************************
;
;	ASCII CODE
;
$ESC		EQU	1BH		; ESCAPE CODE
CR		EQU	0DH
LF		EQU	0AH
CNTL_C		EQU	03H
BS		EQU	08H
BEL		EQU	07H
SPACE		EQU	20H
;
;
;	ROM BIOS
;
;	(INTERRUPT VECTER)
KB_ROM		EQU	18H		; KB
CRT_ROM		EQU	19H		; CRT
;	(FUNCTION CODE)
CRT_FNC_SETMOD	EQU	0		; CRT	SET SCREEN MODE
CRT_FNC_SETCSR	EQU	1		; CRT	SET CURSOL TYPE
CRT_FNC_CSRDSP	EQU	2		; CRT	SET CURSOL POSITION
CRT_FNC_GETCSR	EQU	3		; CRT	GET CURSOL TYPE
CRT_FNC_SCRUP	EQU	6		; CRT	SCROLL UP/ERASE
CRT_FNC_WRITECA	EQU	9		; CRT	WRITE CHAR/ATTRIB
CRT_FNC_WRITEC	EQU	10		; CRT	WRITE CHARACTER
CRT_FNC_TTY	EQU	14		; CRT	WRITE TELETYPE

KB_FNC_READ	EQU	0		; KB	READ CHARACTER
KB_FNC_RDND	EQU	1		; KB	READ CHARACTER NON DESTROY
KB_FNC_SENCE	EQU	2		; KB	STATUS SENCE
;
;	VRAM AND BUFFER
;
;
LINE_MAX	EQU	24		; MAX LINE NUMBER ( 0 ORIGIN )
LINE_SIZ	EQU	80
;
;****************************************
;*		STRUCTURE BLOCK	 	*
;****************************************
IODAT		STRUC			; PACKET TABLE
CMDLEN		DB	?		;	LENGTH OF COMMAND
UNIT		DB	?		;	SUB UNIT SPECIFIER
CMD		DB	?		;	COMMAND CODE
STATUS		DW	?		;	STATUS
		DB	8 DUP(?)
MEDIA		DB	?		;	MEDIA DESCRIPTOR
TRANS		DD	?		;	TRANSFER ADDRESS
COUNT		DW	?		;	COUNT OF BLOCKS OR CHARACTERS
START		DW	?		;	FIRST BLOCK TO TRANSFER
IODAT		ENDS

INCLUDE	B:SYSCOM.LIB			;-------INSERT APR/17/84
		PAGE
;********************************************************
;*							*
;*	SYSTEM PROGRAM SEGMENT AREA			*
;*							*
;********************************************************
;****************************************
;*	INTERRUPT VECTOR AREA		*
;****************************************
INT_VECTOR	SEGMENT AT 0000H	; INTERRUPT VECTOR
;
		ORG	6*4
INT6_VECTOR	LABEL	DWORD		; BREAK KEY INTERRUPT
		ORG	9*4		;-----------INSERT APR/17/84---
INT9_VECTOR	LABEL	DWORD		; KEY BOARD INTERRUPT
		ORG	29H*4
INT29_VECTOR	LABEL	DWORD		; DIRECT CRT OUTPUT
INT_VECTOR	ENDS
;
		PAGE
CODE		SEGMENT PUBLIC 'CODES'
		ASSUME	CS:CODE,DS:NOTHING,ES:NOTHING,SS:NOTHING
		ORG	0
START_PROGRAM	LABEL	NEAR
;********************************************************
;*							*
;*	TABLE BLOCKS (READ ONLY)			*
;*							*
;********************************************************
;****************************************
;*	GLOBAL SYMBOL AND LABEL		*
;****************************************
		PUBLIC	CON_INT
		PUBLIC	CON_DCT
		PUBLIC	CONOUT
;----------------------------------------------INSERT JUN/07/84--------
		PUBLIC	INT6_PROC
		PUBLIC	INT9_PROC
		PUBLIC	INT29_PROC
		PUBLIC	INT9_PNT
;----------------------------------------------------------------------
;****************************************
;*	DESPATCH TABLE FOR DEVICES	*
;****************************************
CON_TBL	 LABEL	WORD
		DW	NORMAL_EXIT	; 0 - INIT -----CHG JUN/7/84---
		DW	CMDERR_EXIT	; 1 - MEDIA CHECK (NOT USED)
		DW	CMDERR_EXIT	; 2 - GET BPB (NOT USED)
		DW	CMDERR_EXIT	; 3 - IO CTRL INPUT
		DW	CON_READ	; 4 - DESTRUCTIVE READ
		DW	CON_RDND	; 5 - NON-DESTRUCTIVE READ
		DW	NORMAL_EXIT	; 6 - INPUT STATUS
		DW	CON_FLUSH	; 7 - FLUSH INPUT BUFFER
		DW	CON_WRITE	; 8 - WRITE
		DW	CON_WRITE	; 9 - WRITE & VERIFY
		DW	NORMAL_EXIT	;10 - WRITE STATUS
		DW	NORMAL_EXIT	;11 - OUTPUT STATUS
		DW	CMDERR_EXIT	;12 - IOCTL OUTPUT
		PAGE
;************************************************
;*						*
;*	PROGRAM WORK AREA 2			*
;*						*
;************************************************
CON_DCT		LABEL	WORD
					; CONTROL TABLE POINTER
		DD	REAS_CONF	;  REASSIGNMENT
		DD	-1		;  UNIVERSAL CG TABLE
		DD	-1		;  KEY CLICK
		DD	-1		;  RESEARVE

REAS_CONF	LABEL	NEAR		; REASSIMENT CONFIGRATION
		DD	STRING_TBL	;  BUFFER POINTER
		DW	STRING_SIZ	;  BUFFER BYTE LENGTH
STRING_TBL_LNG	DW	STRING_SIZ	;  ACCUAL USING SIZE
		DW	0		; RESEARVE

STRING_CNT	DB	0		; COUNT OF STRING CHARACTERS
STRING_ADR	DW	STRING_TBL	; ADDRESS OF STRING CHARACTERS

READ_CHA	DB	0		; BEFORE READ CHARACTER (=0, NONE)
INT9_PNT	DD	?		;-----INSERT APR/17/84---------
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	CON_INT			 	*
;*							*
;*	FUNCTION	CONSOLE I/O CONTROL		*
;*							*
;*	INPUT/OUTPUT	NONE				*
;*							*
;********************************************************
CON_INT		PROC	FAR
		PUSH	SI		; ALL REGISTER SAVE
		MOV	SI,OFFSET CON_TBL
		JMP	ENTRY
		
CON_INT		ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	INT6_PROC			*
;*							*
;*	FUNCTION	INTERRUPT WHEN BREAK KEY IN.	*
;*							*
;*	INPUT/OUTPUT	NONE				*
;*							*
;*							*
;*							*
;********************************************************
INT6_PROC	PROC	FAR
;		PUSH	AX		;---------DEL JUN/07/84----
		MOV	[READ_CHA],CNTL_C
		MOV	[STRING_CNT],0	; CLEAR READING STRING
;		POP	AX		;---------DEL JUN/07/84----
		IRET
INT6_PROC	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	INT29_PROC			*
;*							*
;*	FUNCTION	DIRECT CONSOLE OUTPUT		*
;*							*
;*	INPUT		AL : OUTPUT DATA		*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
INT29_PROC	PROC	FAR
		STI
		PUSH	DS
		PUSH	CS
		POP	DS
		CALL	CONOUT		; OUTPUT CHARACTER TO CRT
		POP	DS
		IRET
INT29_PROC	ENDP
;--------------------------------------------------INSERT APR/17/84----
		PAGE
;********************************************************
;*							*
;*							*
;*	MODULE NAME	INT9_PROC			*
;*							*
;*	FUNCTION	CHECK CNTL_C,CNTL_S,CNTL_F	*
;*							*
;*	INPUT/OUTPUT	NONE				*
;*							*
;********************************************************
INT9_PROC	PROC	FAR
	ASSUME	CS:CODE,DS:SYSCOM,ES:NOTHING,SS:NOTHING
		PUSH	DS
		PUSH	AX
		PUSH	BX
		MOV	AX,SYSCOM
		MOV	DS,AX

		PUSHF
		CALL	[INT9_PNT]		; JUMP TO ROM DRIVER
;---------------------------------------------------CHANGE MAY/28/84---
		MOV	AX,0
		XCHG	AL,[KB_CODE]
		CMP	AL,03H			; CNTL_C ?
		JZ	INT9_5
		CMP	AL,13H			; CNTL_S ?
		JZ	INT9_5
		CMP	AL,06H			; CNTL_F ?
		JNZ	INT9_8
INT9_5:
		MOV	BX,[BUFFER_HEAD]
		MOV	[BX],AX
		INC	BX
		INC	BX
		CMP	BX,OFFSET KB_BUFFER_END
		JNZ	INT9_6
		MOV	BX,OFFSET KB_BUFFER
INT9_6:
;----------------------------------------------------------------------
		MOV	[BUFFER_TAIL],BX
		MOV	[STRING_CNT],0
INT9_8:
		POP	BX
		POP	AX
		POP	DS
		IRET
INT9_PROC	ENDP
;---------------------------------------------------------------------
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	CON_RDND			*
;*							*
;*	FUNCTION	NON-DESTRUCTIVE READ		*
;*							*
;*	INPUT		NONE				*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
	ASSUME	CS:CODE,DS:CODE,ES:NOTHING,SS:NOTHING
CON_RDND	PROC	NEAR
		MOV	AL,[READ_CHA]	; FINISH READ ?
		OR	AL,AL
		JNZ	CON_RDND80	; GO SET DATA TO PACKET
;
		CMP	[STRING_CNT],0	; READING CHARACTER FROM STRING ?
		JZ	CON_RDND40	; NO
;
		MOV	BX,[STRING_ADR] ; GET CHARACTER FROM STRING
		MOV	AL,[BX]
		JMP	SHORT	CON_RDND80
;
CON_RDND40:
		MOV	AH,KB_FNC_RDND	; INPUT SENCE
		INT	KB_ROM
		JZ	CON_RDND90	; READ CHARACTER NONE ?
		CALL	CONV_SEARCH	; CHECK CHANGE STRING
		JNZ	CON_RDND60	; FOUND ?
;
		CMP	AL,0		; FUNCTION CODE ?
		MOV	AL,[BX+2]
		JNZ	CON_RDND80
		MOV	AL,[BX+3]
		JMP	SHORT CON_RDND80
;
CON_RDND60:
		CMP	AL,0		; FUNCTION CODE ?
		JNZ	CON_RDND80
;
		MOV	AH,KB_FNC_READ	; GET FUNCTION DATA
		INT	KB_ROM
		JMP	CON_RDND40
CON_RDND80:
		LDS	BX,[PTRSAV]	; GET PACKET TABLE
		MOV	[BX+MEDIA],AL	; SET CHARACTER
CON_RDND_RET:
		JMP	NORMAL_EXIT
CON_RDND90:
		JMP	BUSY_EXIT
;
CON_RDND	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	CON_READ			*
;*							*
;*	FUNCTION	READ MULTI CHARACTER FROM KB	*
;*							*
;*	INPUT		ES:DI	DATA STORE ADDRESS	*
;*			CX	DATA LENGTH		*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
CON_READ	PROC	NEAR
		JCXZ	CON_READ_RET	; CHARACTER NONE ?
CON_READ10:
		PUSH	CX
		CALL	CONIN		; CONSOL READ
		POP	CX
		JNZ	CON_READ90
		STOSB
		LOOP	CON_READ10
CON_READ_RET:
;
		JMP	NORMAL_EXIT
CON_READ90:
		JMP	BUSY_EXIT
CON_READ	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	CONIN				*
;*							*
;*	FUNCTION	READ ONE CHARACTER FROM KB	*
;*							*
;*	INPUT		NONE				*
;*							*
;*	OUTPUT		AL : ASCII CODE		 	*
;*							*
;********************************************************
CONIN		PROC	NEAR
;
;*	CNTL_C CHECK
;
		XOR	AX,AX
		XCHG	[READ_CHA],AL
		OR	AL,AL		; FINISH READ ?
		JNZ	CONIN80
;
;*	GET CHARACTER
;
CONIN10:	CMP	[STRING_CNT],0	; READING CHARACTER STRING ?
		JNZ	CONIN25	
		MOV	AH,KB_FNC_RDND
		INT	KB_ROM
		JZ	CONIN90
		MOV	AH,KB_FNC_READ
		INT	KB_ROM		; READ A CHARACTER
;
		CALL	CONV_SEARCH	; CHECK CHANGE STRING
		JNZ	CONIN30		; NOT FOUND ?
		DEC	CX		; CX = STRING LENGTH
		DEC	CX
		INC	BX		; BX = STRING ADDRESS
		INC	BX
		OR	AL,AL		; FUNCTION CODE ?
		JNZ	CONIN20		; NO
		DEC	CX
		INC	BX
CONIN20:
		MOV	[STRING_CNT],CL ; SET STRING ADDRESS AND LENGTH
		MOV	[STRING_ADR],BX
CONIN25:
		CALL	GET_STRING	; GET TOP CHARACTER OF STRING
		JMP	CONIN80
CONIN30:
		CMP	AL,0		; FUNCTION CODE ?
		JZ	CONIN10
CONIN80:
		XOR	CX,CX
CONIN_RET:
		RET
CONIN90:
		OR	CX,1
		JMP	CONIN_RET
CONIN		ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	GET_STRING			*
;*							*
;*	FUNCTION	GET A CHARACTER FROM STRING	*
;*							*
;*	INPUT		NONE				*
;*							*
;*	OUTPUT		AL : ASCII CODE			*
;*							*
;********************************************************
GET_STRING	PROC	NEAR
		MOV	SI,[STRING_ADR]
		LODSB			; GET CHARACTER
		DEC	[STRING_CNT]	; STRING ADDRESS & COUNTER UP
		MOV	[STRING_ADR],SI	; SET STRING ADDRESS
		RET
GET_STRING	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	CONV_SEARCH			*
;*							*
;*	FUNCTION	SEARCH CHARACTER - STRING	*
;*							*
;*	INPUT		AL : ASCII	OR		*
;*			AX : FUNCTION CODE		*
;*							*
;*	OUTPUT		ZF : ON=FOUND,	OFF=NOT FOUND	*
;*			BX : STRING BLOCK ADDRESS	*
;*			CX : STRING BLOCK LENGTH	*
;*							*
;********************************************************
CONV_SEARCH	PROC	NEAR
		PUSH	DX
		MOV	BX,OFFSET STRING_TBL
		MOV	DX,BX
		ADD	DX,[STRING_TBL_LNG]
		XOR	CH,CH
CONV_SRC10:
		CMP	BX,DX
		JZ	CONV_SRC70	; TABLE END
;
		MOV	CL,[BX]
		OR	AL,AL		; FUNCTION CODE ?
		JNZ	CONV_SRC30	; NO
;
		CMP	AX,[BX+1]	; SAME FUNCTION CODE ?
		JMP	SHORT	CONV_SRC50
CONV_SRC30:
		CMP	AL,[BX+1]	; SAME ASCII CODE ?
CONV_SRC50:
		JZ	CONV_SRC_RET
;
		ADD	BX,CX		; ID UP
		JMP	CONV_SRC10
;
CONV_SRC70:
		OR	BX,BX		; RESET ZF
;
CONV_SRC_RET:
		POP	DX
		RET
CONV_SEARCH	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	CON_FLUSH			*
;*							*
;*	FUNCTION	CONSOLE INPUT BUFFER CLEAR	*
;*							*
;*	INPUT		NONE				*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
CON_FLUSH	PROC	NEAR
		MOV	[READ_CHA],0	; CLEAR READ FINISH
		MOV	[STRING_CNT],0	; CLEAR READING STRING
CON_FLUSH20:
		MOV	AH,KB_FNC_RDND	; KB DATA NONE ?
		INT	KB_ROM
		JZ	CON_FLUSH50
;
		MOV	AH,KB_FNC_READ	; DATA GET
		INT	KB_ROM
		JMP	CON_FLUSH20
CON_FLUSH50:

		JMP	NORMAL_EXIT
;
CON_FLUSH	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	CON_WRITE			*
;*							*
;*	FUNCTION	WRITE MULTI CHARACTER TO CRT	*
;*							*
;*	INPUT		ESIDI	DATA STORE ADDRESS	*
;*			CX	DATA LENGTH		*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
CON_WRITE	PROC	NEAR
		JCXZ	CON_WRITE80	; OUTPUT CHARACTER NONE ?
CON_WRIT10:
		MOV	AL,ES:[DI]	; GET CHARACTER
		INC	DI
		CALL	CONOUT		; OUTPUT CHARACTER
		LOOP	CON_WRIT10
CON_WRITE80:
		JMP	NORMAL_EXIT
CON_WRITE	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE NAME	CONOUT				*
;*							*
;*	FUNCTION	OUTPUT ONE CHARACTER TO CRT	*
;*							*
;*	INPUT		AL : OUTPUT CHARACTER		*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
CONOUT		PROC	NEAR
		PUSH	AX		; SAVE ALL REGISTER
		PUSH	BX
		PUSH	CX
		PUSH	DX
		PUSH	SI		;------INS APR/27/84-----------
		PUSH	DI		;------INS APR/27/84-----------
		PUSH	BP		;------INS APR/27/84-----------
;
;*	DATA OUTPUT
;
		MOV	BL,07H		; PALLETE COLOR (WHITE)
		MOV	AH,CRT_FNC_TTY
		INT	CRT_ROM		; DISPLAY CHARACTER AS TTY
;
		POP	BP		;------INS APR/27/84-----------
		POP	DI		;------INS APR/27/84-----------
		POP	SI		;------INS APR/27/84-----------
		POP	DX
		POP	CX
		POP	BX
		POP	AX
		RET
;
CONOUT		ENDP
		PAGE
;********************************************************
;*							*
;*	CHARACTER - STRING TABLE			*
;*							*
;*		IDENT STRUCTER				*
;*		+-------------------------------+	*
;*		! IDENT LENGTH		 	!	*
;*		+-------------------------------+	*
;*		! CHARACTER CODE		!	*
;*		! (ASCII=1BYTE,FUNCTION=2BYTE)	!	*
;*		+-------------------------------+	*
;*		! CHANGE STRING			!	*
;*		+-------------------------------+	*
;*							*
;*	REMARK : TABLE SIZE IN "STRING_TBL_LNG"		*
;*							*
;*							*
;*		REMAIN AREA OF 200 BYTE IS ESC SEQUENCE	*
;*		PARAMETER BUFFER.			*
;*							*
;*							*
;********************************************************
STRING_TBL	LABEL	BYTE
		DB	4,0, 02H,00H		; CNTL+@ ---> NULL
		DB	4,0, 60H,13H		; BREAK OR SHIFT+BREAK ---> CNTL+S
		DB	5,0, 62H,$ESC,'S'	; PF1 ---> C1
		DB	5,0, 63H,$ESC,'T'	; PF2 ---> CM
		DB	5,0, 64H,$ESC,'U'	; PF3 ---> CT
		DB	5,0, 65H,$ESC,'V'	; PF4 ---> S1
		DB	5,0, 66H,$ESC,'W'	; PF5 ---> SM
		DB	5,0, 67H,$ESC,'E'	; PF6 ---> ST
		DB	5,0, 68H,$ESC,'P'	; PF7 ---> QI
		DB	5,0, 69H,$ESC,'Q'	; PF8 ---> INS
		DB	5,0, 6AH,$ESC,'J'	; PF9 ---> NL
		DB	4,0,0BAH,10H		; CNTL+PRINT ---> CNTL+P
STRING_SIZ	EQU	$ - STRING_TBL
		DB	0			; ESC SEQUENCE PARAMETER BUFFER
;
STRING_FIN	LABEL	BYTE
;
;****************************************
;*	PROGRAM END			*
;****************************************
CODE		ENDS
		END
>

